/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.internal.browser.BrowserPlugin;

public class BrowserUtil {
    private static final String BROWSER_PACKAGE_NAME = "org.eclipse.swt.browser.Browser";
    private static Boolean isInternalBrowserOperational = null;

    private BrowserUtil() {
    }

    public static Object getWindowKey(IWorkbenchWindow window) {
        return new Integer(window.hashCode());
    }

    public static boolean gotoUrl(String url) {
        if (url != null && !BrowserUtil.isWindows()) {
            int index = url.indexOf(" ");
            while (index >= 0) {
                url = String.valueOf(url.substring(0, index)) + "%20" + url.substring(index + 1);
                index = url.indexOf(" ");
            }
        }
        return Program.launch((String)url);
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("win") >= 0;
    }

    public static boolean canUseInternalWebBrowser() {
        if (isInternalBrowserOperational != null) {
            return isInternalBrowserOperational;
        }
        try {
            Class.forName(BROWSER_PACKAGE_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            isInternalBrowserOperational = new Boolean(false);
            return false;
        }
        Shell shell = null;
        try {
            shell = new Shell(PlatformUI.getWorkbench().getDisplay());
            new Browser((Composite)shell, 0);
            isInternalBrowserOperational = new Boolean(true);
            return true;
        }
        catch (Throwable t) {
            BrowserPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.browser", 0, "Internal browser is not available: " + t.getMessage(), null));
            isInternalBrowserOperational = new Boolean(false);
            return false;
        }
        finally {
            if (shell != null) {
                shell.dispose();
            }
        }
    }

    public static boolean canUseSystemBrowser() {
        return !"solaris".equals(Platform.getOS());
    }

    public static String encodeStyle(String clientId, int style) {
        return String.valueOf(clientId) + "-" + style;
    }

    public static int decodeStyle(String id) {
        return Integer.parseInt(id.substring(id.lastIndexOf(45) + 1));
    }

    public static String decodeClientId(String id) {
        return id.substring(0, id.lastIndexOf(45));
    }
}

