/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.util.HashMap;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.browser.IBrowser;
import org.xmind.ui.browser.IBrowserSupport;
import org.xmind.ui.internal.browser.BrowserPref;
import org.xmind.ui.internal.browser.BrowserUtil;
import org.xmind.ui.internal.browser.DefaultBrowser;
import org.xmind.ui.internal.browser.ExternalBrowser;
import org.xmind.ui.internal.browser.InternalBrowser;

public class BrowserSupportImpl
implements IBrowserSupport {
    private static final String DEFAULT_CLIENT_ID = "org.xmind.ui.defaultBrowser";
    private HashMap<String, Object> browsers = new HashMap();

    public IBrowser createBrowser() {
        return this.createBrowser(0, DEFAULT_CLIENT_ID, null, null);
    }

    public IBrowser createBrowser(int style) {
        return this.createBrowser(style, DEFAULT_CLIENT_ID, null, null);
    }

    public IBrowser createBrowser(String browserClientId) {
        return this.createBrowser(0, browserClientId, null, null);
    }

    public IBrowser createBrowser(int style, String browserClientId) {
        return this.createBrowser(style, browserClientId, null, null);
    }

    public IBrowser createBrowser(int style, String browserClientId, String name, String tooltip) {
        String browserId = BrowserUtil.encodeStyle(browserClientId == null ? DEFAULT_CLIENT_ID : browserClientId, style);
        IBrowser existingBrowser = this.getExistingBrowser(style, browserId);
        if (existingBrowser != null && this.matchesStyle(existingBrowser, style)) {
            if (existingBrowser instanceof InternalBrowser) {
                ((InternalBrowser)existingBrowser).setName(name);
                ((InternalBrowser)existingBrowser).setTooltip(tooltip);
            }
            return existingBrowser;
        }
        IBrowser newBrowser = this.doCreateBrowser(style, browserId, name, tooltip);
        this.registerBrowser(newBrowser);
        return newBrowser;
    }

    private boolean matchesStyle(IBrowser browser, int style) {
        if (this.isInternal(style)) {
            return browser instanceof InternalBrowser;
        }
        if (this.isExternal(style)) {
            return browser instanceof ExternalBrowser;
        }
        return browser instanceof DefaultBrowser;
    }

    private IBrowser getExistingBrowser(int style, String browserClientId) {
        Object object = this.browsers.get(browserClientId);
        if (object != null) {
            if (object instanceof IBrowser && this.isExternal(style)) {
                return (IBrowser)object;
            }
            if (object instanceof InternalMap && this.isInternal(style)) {
                InternalMap map = (InternalMap)object;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    return (IBrowser)map.get(BrowserUtil.getWindowKey(window));
                }
            }
        }
        return null;
    }

    private boolean isInternal(int style) {
        return (style & 6) != 0 || style == 0 && BrowserPref.getBrowserChoice() == 0;
    }

    private boolean isExternal(int style) {
        return style == 1 || style == 0 && BrowserPref.getBrowserChoice() == 1;
    }

    private IBrowser doCreateBrowser(int style, String browserClientId, String name, String tooltip) {
        if (this.isInternal(style)) {
            return new InternalBrowser(this, browserClientId, this.asEditor(style));
        }
        if (this.isExternal(style)) {
            return new ExternalBrowser(browserClientId);
        }
        return new DefaultBrowser(this, browserClientId);
    }

    private boolean asEditor(int style) {
        return style != 0 && (style & 2) == 0;
    }

    private void registerBrowser(IBrowser browser) {
        String clientId = browser.getClientId();
        Object object = this.browsers.get(clientId);
        if (browser instanceof InternalBrowser) {
            Object key = ((InternalBrowser)browser).getWindowKey();
            if (object instanceof InternalMap) {
                ((InternalMap)object).put(key, browser);
            } else {
                InternalMap map = new InternalMap();
                map.put(key, browser);
                object = map;
            }
        } else {
            object = browser;
        }
        this.browsers.put(clientId, object);
    }

    void removeInternalBrowser(InternalBrowser browser) {
        String id = browser.getClientId();
        Object key = browser.getWindowKey();
        Object object = this.browsers.get(id);
        if (object instanceof InternalMap) {
            InternalMap map = (InternalMap)object;
            if (map != null) {
                map.remove(key);
                if (map.isEmpty()) {
                    this.browsers.remove(id);
                }
            }
        } else {
            this.browsers.remove(id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalMap
    extends HashMap<Object, IBrowser> {
        private static final long serialVersionUID = -6399662915430504209L;

        public InternalMap() {
            super(4);
        }
    }
}

