/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import net.xmind.signin.ISignInListener;
import net.xmind.signin.IVerifyListener;
import net.xmind.signin.XMindNetEntry;
import net.xmind.signin.internal.Activator;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.json.JSONException;
import org.json.JSONObject;

public class UserInfoVerifier
implements ISignInListener {
    private static final boolean DEBUG = false;
    private static UserInfoVerifier instance = null;
    private IStatus validity = null;
    private List<IVerifyListener> listeners;
    private List<IVerifyListener> callbacks;
    private boolean firingValidity = false;

    public UserInfoVerifier() {
        XMindNetEntry.addSignInListener(this);
    }

    public void postSignOut() {
        this.validity = this.createValidity(2);
        this.notifyValidity(this.validity, null);
    }

    public void postSignIn(Properties userInfo) {
        this.verify(null);
    }

    public void verify() {
        this.verify(null);
    }

    public void verify(IVerifyListener callback) {
        int code;
        if (this.validity != null && ((code = this.validity.getCode()) == 0 || (code & 0x8000000C) != 0)) {
            this.notifyValidity(this.validity, callback);
            return;
        }
        Properties userInfo = XMindNetEntry.getCurrentUserInfo();
        if (userInfo == null) {
            this.validity = this.createValidity(2);
            this.notifyValidity(this.validity, callback);
            return;
        }
        if (callback != null) {
            if (this.callbacks == null) {
                this.callbacks = new ArrayList<IVerifyListener>();
            }
            this.callbacks.add(new Callback(callback));
        }
        new VerifyJob().schedule();
    }

    private IStatus doVerify(Properties userInfo) {
        IStatus validity;
        String userID = userInfo.getProperty("USER_ID");
        String token = userInfo.getProperty("TOKEN");
        UserInfoVerifier.debug("user info -----------");
        UserInfoVerifier.debug("user id: " + userID);
        UserInfoVerifier.debug("token: " + token);
        UserInfoVerifier.debug("generate http method");
        String url = "http://www.xmind.net/xmind/verify/?user=" + userID + "&token=" + token;
        UserInfoVerifier.debug("url: " + url);
        GetMethod method = new GetMethod(url);
        method.setRequestHeader("AuthToken", token);
        method.setRequestHeader("accept", "application/json");
        HttpClient client = new HttpClient();
        try {
            UserInfoVerifier.debug("start execute method");
            int result = client.executeMethod((HttpMethod)method);
            UserInfoVerifier.debug("result: " + result);
            if (200 == result) {
                int state = this.getValidityState(client, method);
                validity = this.createValidity(state);
            } else {
                validity = this.createValidity(Integer.MIN_VALUE);
            }
        }
        catch (Throwable e) {
            UserInfoVerifier.debug(e);
            validity = this.createValidity(Integer.MIN_VALUE, e);
        }
        this.validity = validity;
        UserInfoVerifier.debug("validity: " + validity == null ? "null" : validity.toString());
        this.notifyValidity(validity, null);
        return validity;
    }

    public IStatus getValidity() {
        return this.validity;
    }

    private int getValidityState(HttpClient client, GetMethod method) throws JSONException, IOException {
        String resp = method.getResponseBodyAsString();
        UserInfoVerifier.debug("response: " + resp);
        JSONObject json = new JSONObject(resp);
        long expireDate = json.getLong("expireDate");
        if (expireDate < 0L) {
            UserInfoVerifier.debug("not subscribed");
            return 4;
        }
        boolean expired = json.getBoolean("expired");
        if (expired) {
            UserInfoVerifier.debug("expired");
            return 8;
        }
        Calendar expDate = Calendar.getInstance();
        expDate.setTimeInMillis(expireDate);
        Calendar now = Calendar.getInstance();
        if (expDate.after(now)) {
            UserInfoVerifier.debug(String.format("valid: %1$tF, %2$tF", expDate, now));
            return 0;
        }
        UserInfoVerifier.debug(String.format("expired: %1$tF, %2$tF", expDate, now));
        return 8;
    }

    private IStatus createValidity(int state) {
        return this.createValidity(state, null);
    }

    private IStatus createValidity(int state, Throwable error) {
        int severity = state == Integer.MIN_VALUE ? 2 : 0;
        return new Status(severity, "net.xmind.login", state, null, error);
    }

    private void notifyValidity(IStatus validity, IVerifyListener callback) {
        Assert.isNotNull((Object)validity);
        if (callback != null) {
            callback.notifyValidity(validity);
        } else {
            this.notifyCallbacks(validity);
        }
        this.fireValidify(validity);
    }

    private synchronized void notifyCallbacks(IStatus validity) {
        if (this.callbacks == null) {
            return;
        }
        Object[] objectArray = this.callbacks.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object callback = objectArray[n2];
            try {
                ((IVerifyListener)callback).notifyValidity(validity);
            }
            catch (Throwable e) {
                Activator.log(e);
            }
            ++n2;
        }
        this.callbacks.clear();
        this.callbacks = null;
    }

    private void fireValidify(IStatus result) {
        if (this.listeners == null || this.firingValidity) {
            return;
        }
        this.firingValidity = true;
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener != null) {
                try {
                    ((IVerifyListener)listener).notifyValidity(result);
                }
                catch (Throwable e) {
                    Activator.log(e);
                }
            }
            ++n2;
        }
        this.firingValidity = false;
    }

    public void addVerifyListener(IVerifyListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IVerifyListener>();
        }
        this.listeners.add(listener);
    }

    public void removeVerifyListener(IVerifyListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private static void debug(String message) {
    }

    private static void debug(Throwable e) {
    }

    public static UserInfoVerifier getInstance() {
        if (instance == null) {
            instance = new UserInfoVerifier();
        }
        return instance;
    }

    private static class Callback
    implements IVerifyListener {
        private IVerifyListener callback;
        private Display display;

        public Callback(IVerifyListener callback) {
            this.callback = callback;
            this.display = Display.getCurrent();
        }

        public void notifyValidity(final IStatus validity) {
            if (this.display == null || !this.display.isDisposed()) {
                this.callback.notifyValidity(validity);
            } else {
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        Callback.this.callback.notifyValidity(validity);
                    }
                });
            }
        }
    }

    private final class VerifyJob
    extends Job {
        private VerifyJob() {
            super("Verify user information");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Properties userInfo = XMindNetEntry.getCurrentUserInfo();
            if (userInfo == null) {
                return Status.CANCEL_STATUS;
            }
            return UserInfoVerifier.this.doVerify(userInfo);
        }
    }
}

