/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.xmind.signin.internal.Activator;
import net.xmind.signin.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.InstallWizard2;
import org.eclipse.update.internal.ui.wizards.ResizableInstallWizardDialog;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.BackLevelFilter;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.IUpdateSearchFilter;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;

public class UpgradeRunnable
implements Runnable {
    private static UpgradeRunnable runningInstance = null;
    private Shell parentShell;
    private UpdateSearchRequest searchRequest;
    private List<IInstallFeatureOperation> updates;
    private UpgradeJob job;

    public UpgradeRunnable() {
        this(null);
    }

    public UpgradeRunnable(Shell parentShell) {
        this.parentShell = parentShell;
        if (runningInstance == null) {
            runningInstance = this;
        }
    }

    public void run() {
        UpgradeSourceDialog dialog = new UpgradeSourceDialog(this.parentShell);
        int retCode = dialog.open();
        if (retCode != 0) {
            this.notifyStopped();
            return;
        }
        String url = dialog.getURL();
        UpdateSearchScope scope = new UpdateSearchScope();
        try {
            scope.addSearchSite("XMind Pro", new URL(url), null);
        }
        catch (MalformedURLException e) {
            Activator.log(e);
        }
        scope.setFeatureProvidedSitesEnabled(false);
        this.searchRequest = new UpdateSearchRequest(UpdateSearchRequest.createDefaultSiteSearchCategory(), scope);
        this.searchRequest.addFilter((IUpdateSearchFilter)new EnvironmentFilter());
        this.searchRequest.addFilter((IUpdateSearchFilter)new BackLevelFilter());
        this.searchFeature(Display.getCurrent());
    }

    private void searchFeature(final Display display) {
        this.updates = new ArrayList<IInstallFeatureOperation>();
        this.job = new UpgradeJob();
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UpgradeRunnable.this.afterSearch(display, event.getResult());
            }
        });
        this.job.schedule();
    }

    private void afterSearch(final Display display, final IStatus result) {
        if (result == Status.CANCEL_STATUS) {
            return;
        }
        if (result != Status.OK_STATUS) {
            display.syncExec(new Runnable(){

                public void run() {
                    UpdateUI.log((IStatus)result, (boolean)true);
                }
            });
        }
        display.asyncExec(new Runnable(){

            public void run() {
                BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                    public void run() {
                        UpgradeRunnable.this.openInstallWizard();
                    }
                });
            }
        });
    }

    private void openInstallWizard() {
        if (InstallWizard2.isRunning()) {
            MessageDialog.openInformation((Shell)this.parentShell, (String)UpdateUIMessages.InstallWizard_isRunningTitle, (String)UpdateUIMessages.InstallWizard_isRunningInfo);
            return;
        }
        if (this.updates == null || this.updates.isEmpty()) {
            MessageDialog.openInformation((Shell)this.parentShell, (String)Messages.Upgrade_ErrorDialog_title, (String)Messages.Upgrade_ErrorDialog_message);
            return;
        }
        InstallWizard2 wizard = new InstallWizard2(this.searchRequest, this.updates.toArray(new IInstallFeatureOperation[0]), true);
        ResizableInstallWizardDialog dialog = new ResizableInstallWizardDialog(this.parentShell, (IWizard)wizard, Messages.Upgrade_InstallDialog_title);
        dialog.create();
        dialog.open();
        this.notifyStopped();
    }

    private void notifyStopped() {
        if (runningInstance == this) {
            runningInstance = null;
        }
    }

    public static boolean isRunning() {
        return runningInstance != null;
    }

    private class SearchResultCollector
    implements IUpdateSearchResultCollector {
        private SearchResultCollector() {
        }

        public void accept(IFeature feature) {
            IInstallFeatureOperation operation = OperationsManager.getOperationFactory().createInstallOperation(null, feature, null, null, null);
            UpgradeRunnable.this.updates.add(operation);
        }
    }

    private class UpgradeJob
    extends Job {
        public UpgradeJob() {
            super(Messages.Upgrade_jobName);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                UpgradeRunnable.this.searchRequest.performSearch((IUpdateSearchResultCollector)new SearchResultCollector(), monitor);
                return Status.OK_STATUS;
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
    }

    private static class UpgradeSourceDialog
    extends Dialog {
        private String url;
        private Button onlineButton;
        private Button localFileButton;

        public UpgradeSourceDialog(Shell parentShell) {
            super(parentShell);
            this.setBlockOnOpen(true);
            this.setShellStyle(96);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.UpgradeSourceDialog_title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(Messages.UpgradeSourceDialog_label);
            this.onlineButton = new Button(composite, 16);
            this.onlineButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.onlineButton.setText(Messages.UpgradeSourceDialog_Online);
            this.localFileButton = new Button(composite, 16);
            this.localFileButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.localFileButton.setText(Messages.UpgradeSourceDialog_LocalFile);
            this.onlineButton.setSelection(true);
            this.localFileButton.setSelection(false);
            return composite;
        }

        protected void okPressed() {
            boolean openFileDialog = this.localFileButton.getSelection();
            if (openFileDialog) {
                FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.*"});
                fileDialog.setFilterNames(new String[]{"(*.*)"});
                String path = fileDialog.open();
                if (path == null) {
                    return;
                }
                this.url = "jar:file:" + path + "!/";
            } else {
                this.url = "http://www.xmind.net/xmind/updates/xmindpro3/";
            }
            super.okPressed();
        }

        public String getURL() {
            return this.url;
        }
    }
}

