/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal.actions;

import java.util.Properties;
import net.xmind.signin.ISignInListener;
import net.xmind.signin.XMindNetEntry;
import net.xmind.signin.internal.Messages;
import net.xmind.signin.internal.actions.XMindNetActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class ShowAccountActionDelegate
extends XMindNetActionDelegate
implements IWorkbenchWindowActionDelegate,
IActionDelegate2,
ISignInListener {
    private IWorkbenchWindow window;
    private IAction action;

    public void dispose() {
        this.window = null;
        this.action = null;
        XMindNetEntry.removeSignInListener(this);
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        XMindNetEntry.addSignInListener(this);
        this.update();
    }

    public void init(IAction action) {
        this.action = action;
        this.update();
    }

    private void update() {
        String userID = this.getUserID();
        if (userID == null) {
            this.action.setText(Messages.ShowAccount_text);
            this.action.setToolTipText(Messages.ShowAccount_toolTip);
        } else {
            this.action.setText(NLS.bind((String)Messages.ShowAccount_pattern, (Object)userID));
            this.action.setToolTipText(NLS.bind((String)Messages.ShowAccount_toolTip_pattern, (Object)userID));
        }
        this.action.setEnabled(XMindNetEntry.hasSignedIn());
    }

    private String getUserID() {
        Properties userInfo = XMindNetEntry.getCurrentUserInfo();
        return userInfo == null ? null : userInfo.getProperty("USER_ID");
    }

    private String getToken() {
        Properties userInfo = XMindNetEntry.getCurrentUserInfo();
        return userInfo == null ? null : userInfo.getProperty("TOKEN");
    }

    public void run(IAction action) {
        if (this.window == null || !XMindNetEntry.hasSignedIn()) {
            return;
        }
        this.setURL(String.format("http://www.xmind.net/xmind/account/%s/%s/", this.getUserID(), this.getToken()));
        this.gotoURL();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void postSignIn(Properties userInfo) {
        this.update();
    }

    public void postSignOut() {
        this.update();
    }
}

