/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal;

import java.util.Properties;
import net.xmind.signin.internal.Activator;
import net.xmind.signin.internal.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmind.ui.browser.BrowserSupport;
import org.xmind.ui.browser.IBrowser;
import org.xmind.ui.internal.browser.InternalBrowser;
import org.xmind.ui.internal.browser.InternalBrowserEditor;
import org.xmind.ui.internal.browser.InternalBrowserView;

public class SignInDialog
extends Dialog
implements StatusTextListener,
OpenWindowListener {
    private static final String SIGN_IN_URL = "http://www.xmind.net/xmind/signin/";
    private static final String USER = "user";
    private static final String TOKEN = "token";
    private static final String REMEMBER = "remember";
    private Browser browser;
    private String userID = null;
    private String token = null;
    private boolean shouldRemember = false;

    public SignInDialog(Shell parent) {
        super(parent);
        this.setBlockOnOpen(true);
        this.setShellStyle(65648);
    }

    public String getUserID() {
        return this.userID;
    }

    public String getToken() {
        return this.token;
    }

    public boolean shouldRemember() {
        return this.shouldRemember;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SignInDialog_title);
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle area = Display.getCurrent().getClientArea();
        return new Point(area.x + (area.width - initialSize.x) / 2, area.y + (area.height - initialSize.y) / 2);
    }

    protected Control createContents(Composite parent) {
        try {
            this.browser = new Browser(parent, 32768);
        }
        catch (SWTError sWTError) {
            this.browser = new Browser(parent, 0);
        }
        this.browser.setLayoutData((Object)new GridData(1808));
        this.browser.addStatusTextListener((StatusTextListener)this);
        this.browser.addOpenWindowListener((OpenWindowListener)this);
        this.browser.setUrl(SIGN_IN_URL);
        if ("carbon".equals(SWT.getPlatform())) {
            this.browser.refresh();
        }
        return this.browser;
    }

    protected Browser getBrowser() {
        return this.browser;
    }

    protected Point getInitialSize() {
        return new Point(540, 365);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    public void changed(StatusTextEvent event) {
        this.checkCommand(event.text);
    }

    private boolean checkCommand(String text) {
        String json;
        String[] commandLines = text.split(";");
        Properties commands = new Properties();
        String[] stringArray = commandLines;
        int n = commandLines.length;
        int n2 = 0;
        while (n2 < n) {
            String commandLine = stringArray[n2];
            int index = commandLine.indexOf(61);
            if (index >= 0) {
                commands.setProperty(commandLine.substring(0, index), commandLine.substring(index + 1));
            }
            ++n2;
        }
        String code = commands.getProperty("xmind_status");
        if ("200".equals(code) && (json = commands.getProperty("xmind_json")) != null) {
            return this.executeJSON(json);
        }
        return false;
    }

    private boolean executeJSON(String json) {
        try {
            return this.setUserNameAndToken(json);
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    private boolean setUserNameAndToken(String jsonSource) throws JSONException {
        JSONObject json = new JSONObject(jsonSource);
        String userID = json.getString(USER);
        String token = json.getString(TOKEN);
        if (userID == null || token == null || "".equals(userID) || "".equals(token)) {
            return false;
        }
        this.userID = userID;
        this.token = token;
        this.shouldRemember = json.getBoolean(REMEMBER);
        this.setReturnCode(0);
        return this.close();
    }

    public void open(WindowEvent event) {
        IBrowser browser = BrowserSupport.getInstance().createBrowser(4);
        try {
            browser.openURL("");
            if (browser instanceof InternalBrowser) {
                IWorkbenchPart part = ((InternalBrowser)browser).getPart();
                if (part instanceof InternalBrowserEditor) {
                    event.browser = ((InternalBrowserEditor)part).getViewer().getBrowser();
                } else if (part instanceof InternalBrowserView) {
                    event.browser = ((InternalBrowserView)part).getViewer().getBrowser();
                }
            }
        }
        catch (PartInitException e) {
            Activator.log(e);
        }
        event.display.asyncExec(new Runnable(){

            public void run() {
                SignInDialog.this.setReturnCode(1);
                SignInDialog.this.close();
            }
        });
    }
}

