/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;

public class TreeViewerUpdater {
    private final AbstractTreeViewer viewer;
    private final TreeViewer treeViewer;

    public TreeViewerUpdater(AbstractTreeViewer viewer) {
        this.viewer = viewer;
        this.treeViewer = viewer instanceof TreeViewer ? (TreeViewer)viewer : null;
    }

    public void insert(Object parent, Object element, int position) {
        this.viewer.insert(parent, element, position);
    }

    public void replace(Object parent, Object oldElement, Object newElement, int position) {
        if (this.treeViewer != null && this.viewer.getComparator() == null && this.viewer.getFilters().length == 0) {
            this.treeViewer.replace(parent, position, newElement);
        } else {
            this.remove(parent, oldElement, position);
            this.insert(parent, newElement, position);
        }
    }

    public void move(Object parent, Object element, int oldPosition, int newPosition) {
        if (this.viewer.getComparator() == null && this.viewer.getFilters().length == 0) {
            ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
            this.remove(parent, element, oldPosition);
            this.insert(parent, element, newPosition);
            if (!selection.isEmpty()) {
                IElementComparer comparer = this.viewer.getComparer();
                TreePath[] paths = selection.getPaths();
                int i = 0;
                block0: while (i < paths.length) {
                    TreePath path = paths[i];
                    int j = 0;
                    while (j < path.getSegmentCount()) {
                        Object pathElement = path.getSegment(j);
                        if (comparer == null ? Util.equals((Object)element, (Object)pathElement) : comparer.equals(element, pathElement)) {
                            this.viewer.setSelection((ISelection)selection);
                            break block0;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public void remove(Object parent, Object element, int position) {
        if (this.treeViewer != null && this.viewer.getComparator() == null && this.viewer.getFilters().length == 0) {
            this.treeViewer.remove(parent, position);
        } else {
            this.viewer.remove(parent, new Object[]{element});
        }
    }

    public void add(Object parent, Object[] elements) {
        this.viewer.add(parent, elements);
    }

    public void remove(Object parent, Object[] elements) {
        this.viewer.remove(parent, elements);
    }
}

