/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;

public abstract class SWTObservableList
extends AbstractObservableList {
    static /* synthetic */ Class class$0;

    public SWTObservableList() {
    }

    public SWTObservableList(Realm realm) {
        super(realm);
    }

    public void add(int index, Object element) {
        int size = this.doGetSize();
        if (index < 0 || index > size) {
            index = size;
        }
        String[] newItems = new String[size + 1];
        System.arraycopy(this.getItems(), 0, newItems, 0, index);
        newItems[index] = (String)element;
        System.arraycopy(this.getItems(), index, newItems, index + 1, size - index);
        this.setItems(newItems);
        this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, (Object)element)));
    }

    public int doGetSize() {
        return this.getItemCount();
    }

    public Object get(int index) {
        this.getterCalled();
        return this.getItem(index);
    }

    public Object getElementType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected abstract String getItem(int var1);

    protected abstract int getItemCount();

    protected abstract String[] getItems();

    private void getterCalled() {
        ObservableTracker.getterCalled((IObservable)this);
    }

    public Object remove(int index) {
        this.getterCalled();
        int size = this.doGetSize();
        if (index < 0 || index > size - 1) {
            throw new BindingException("Request to remove an element out of the collection bounds");
        }
        String[] newItems = new String[size - 1];
        String oldElement = this.getItem(index);
        if (newItems.length > 0) {
            System.arraycopy(this.getItems(), 0, newItems, 0, index);
            if (size - 1 > index) {
                System.arraycopy(this.getItems(), index + 1, newItems, index, size - index - 1);
            }
        }
        this.setItems(newItems);
        this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, (Object)oldElement)));
        return oldElement;
    }

    public Object set(int index, Object element) {
        String oldElement = this.getItem(index);
        this.setItem(index, (String)element);
        this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, (Object)oldElement), (ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, (Object)element)));
        return oldElement;
    }

    public Object move(int oldIndex, int newIndex) {
        this.checkRealm();
        if (oldIndex == newIndex) {
            return this.get(oldIndex);
        }
        int size = this.doGetSize();
        if (oldIndex < 0 || oldIndex >= size) {
            throw new IndexOutOfBoundsException("oldIndex: " + oldIndex + ", size:" + size);
        }
        if (newIndex < 0 || newIndex >= size) {
            throw new IndexOutOfBoundsException("newIndex: " + newIndex + ", size:" + size);
        }
        String[] items = this.getItems();
        String[] newItems = new String[size];
        String element = items[oldIndex];
        if (newItems.length > 0) {
            System.arraycopy(items, 0, newItems, 0, size);
            if (oldIndex < newIndex) {
                System.arraycopy(items, oldIndex + 1, newItems, oldIndex, newIndex - oldIndex);
            } else {
                System.arraycopy(items, newIndex, newItems, newIndex + 1, oldIndex - newIndex);
            }
            newItems[newIndex] = element;
        }
        this.setItems(newItems);
        this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)oldIndex, (boolean)false, (Object)element), (ListDiffEntry)Diffs.createListDiffEntry((int)newIndex, (boolean)true, (Object)element)));
        return element;
    }

    public boolean removeAll(Collection c) {
        this.checkRealm();
        List<String> oldItems = Arrays.asList(this.getItems());
        ArrayList<String> newItems = new ArrayList<String>(oldItems);
        boolean removedAll = newItems.removeAll(c);
        if (removedAll) {
            this.setItems(newItems.toArray(new String[newItems.size()]));
            this.fireListChange(Diffs.computeListDiff(oldItems, newItems));
        }
        return removedAll;
    }

    public boolean retainAll(Collection c) {
        this.checkRealm();
        List<String> oldItems = Arrays.asList(this.getItems());
        ArrayList<String> newItems = new ArrayList<String>(oldItems);
        boolean retainedAll = newItems.retainAll(c);
        if (retainedAll) {
            this.setItems(newItems.toArray(new String[newItems.size()]));
            this.fireListChange(Diffs.computeListDiff(oldItems, newItems));
        }
        return retainedAll;
    }

    protected abstract void setItem(int var1, String var2);

    protected abstract void setItems(String[] var1);
}

