/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.xmind.ui.internal.spelling.ISpellCheckerVisitor;
import org.xmind.ui.internal.spelling.SpellCheckerAgent;
import org.xmind.ui.texteditor.IControlContentAdapter2;

public class SpellingHelper
implements Listener,
SpellCheckListener {
    private static final int DEFAULT_CHECK_DELAY = 500;
    private Control control;
    private IControlContentAdapter2 contentAdapter;
    private Map<Integer, SpellCheckEvent> ranges = new HashMap<Integer, SpellCheckEvent>();
    private List<SpellData> cache = new ArrayList<SpellData>();
    private Menu menu = null;
    private Runnable checkJob;
    private SpellChecker spellChecker;
    private int start = 0;
    private int offset = 0;
    private String input = null;
    private String replaced = null;
    private ITextViewer textViewer;

    public SpellingHelper(ITextViewer textViewer, IControlContentAdapter2 contentAdapter) {
        this.textViewer = textViewer;
        this.control = textViewer.getTextWidget();
        this.contentAdapter = contentAdapter;
        this.init();
    }

    private void init() {
        this.control.addListener(9, (Listener)this);
        this.control.addListener(12, (Listener)this);
        SpellCheckerAgent.visitSpellChecker(new ISpellCheckerVisitor(){

            public void handleWith(SpellChecker spellChecker) {
                if (SpellingHelper.this.control.isDisposed()) {
                    return;
                }
                SpellingHelper.this.spellChecker = spellChecker;
                spellChecker.addSpellCheckListener((SpellCheckListener)SpellingHelper.this);
                SpellingHelper.this.check();
            }
        });
        TextListener textListener = new TextListener();
        this.textViewer.addTextListener((ITextListener)textListener);
    }

    private void paintSpellError(GC gc) {
        int lineStyle = gc.getLineStyle();
        int lineWidth = gc.getLineWidth();
        Color lineColor = gc.getForeground();
        gc.setLineWidth(2);
        gc.setLineStyle(3);
        gc.setForeground(Display.getCurrent().getSystemColor(3));
        String contents = this.contentAdapter.getControlContents(this.control);
        int charCount = contents.length();
        for (SpellData spell : this.cache) {
            int start = spell.start;
            if (start < 0 || start >= charCount) continue;
            int length = Math.min(spell.content.length(), charCount - start);
            int i = 0;
            while (i < length) {
                Point p2 = this.contentAdapter.getLocationAtOffset(this.control, start + i + 1);
                int h2 = this.contentAdapter.getLineHeightAtOffset(this.control, start + i + 1);
                p2.y += h2 - 1;
                Point p1 = this.contentAdapter.getLocationAtOffset(this.control, start + i);
                int h1 = this.contentAdapter.getLineHeightAtOffset(this.control, start + i);
                p1.y += h1 - 1;
                if (p1.y != p2.y) {
                    Point size = gc.stringExtent(this.contentAdapter.getControlContents(this.control, start + i, 1));
                    p1.x = p2.x - size.x;
                    p1.y = p2.y;
                }
                gc.drawLine(p1.x, p1.y, p2.x, p2.y);
                ++i;
            }
        }
        gc.setLineWidth(lineWidth);
        gc.setLineStyle(lineStyle);
        gc.setForeground(lineColor);
    }

    private void check() {
        this.checkJob = new Runnable(){

            public void run() {
                if (SpellingHelper.this.checkJob != this) {
                    return;
                }
                if (!SpellingHelper.this.control.isDisposed()) {
                    SpellingHelper.this.doCheck();
                    SpellingHelper.this.control.redraw();
                }
                SpellingHelper.this.checkJob = null;
            }
        };
        Display.getCurrent().timerExec(this.getCheckDelay(), this.checkJob);
    }

    protected int getCheckDelay() {
        return 500;
    }

    private void doCheck() {
        if (this.spellChecker != null) {
            String content = this.contentAdapter.getControlContents(this.control);
            this.reSort();
            this.start = this.getPrevWordStart(this.offset);
            this.refreshCache(this.offset);
            content = content.substring(this.start);
            this.spellChecker.checkSpelling((WordTokenizer)new StringWordTokenizer(content));
        }
    }

    private void refreshCache(int offset) {
        int changed = this.input.length();
        if (this.replaced != null) {
            changed -= this.replaced.length();
        }
        if (this.cache.size() < 1) {
            return;
        }
        int i = this.cache.size() - 1;
        while (i >= 0) {
            SpellData sd = this.cache.get(i);
            if (sd.start < offset) break;
            sd.start += changed;
            --i;
        }
    }

    private int getPrevWordStart(int offset) {
        int ret = 0;
        if (this.cache.isEmpty()) {
            return ret;
        }
        for (SpellData sd : this.cache) {
            if (sd.start > offset) break;
            ret = sd.start;
        }
        return ret;
    }

    protected void handleDispose() {
        this.ranges.clear();
        this.cache.clear();
        this.checkJob = null;
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        if (this.spellChecker != null) {
            this.spellChecker.removeSpellCheckListener((SpellCheckListener)this);
            this.spellChecker = null;
        }
    }

    public void handleEvent(Event event) {
        if (this.control.isDisposed()) {
            return;
        }
        int type = event.type;
        switch (type) {
            case 9: {
                this.paintSpellError(event.gc);
                break;
            }
            case 12: {
                this.handleDispose();
            }
        }
    }

    public void spellingError(SpellCheckEvent event) {
        if (this.control.isDisposed()) {
            return;
        }
        int start = event.getWordContextPosition();
        String word = event.getInvalidWord();
        this.comparatorTo(start += this.start);
        this.cache.add(new SpellData(start, word));
        this.ranges.put(start, event);
    }

    private void comparatorTo(int start) {
        this.reSort();
        int num = -1;
        int i = 0;
        while (i < this.cache.size()) {
            SpellData data = this.cache.get(i);
            if (start == data.start) {
                num = i;
            }
            ++i;
        }
        if (num > -1) {
            this.cache.remove(num);
        }
    }

    private void reSort() {
        Collections.sort(this.cache, new Comparator<SpellData>(){

            @Override
            public int compare(SpellData o1, SpellData o2) {
                int start1 = o1.start;
                int start2 = o2.start;
                int ret = start1 - start2;
                if (ret == 0) {
                    int length1 = o1.content.length();
                    int length2 = o2.content.length();
                    return length1 - length2;
                }
                return ret;
            }
        });
    }

    private class SpellData {
        int start;
        int length;
        String content;

        public SpellData(int start, String content) {
            this.start = start;
            this.content = content;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SpellData)) {
                return false;
            }
            SpellData sd = (SpellData)obj;
            return this.start == sd.start && sd.content.equals(this.content);
        }
    }

    private class TextListener
    implements ITextListener {
        private TextListener() {
        }

        public void textChanged(TextEvent event) {
            SpellingHelper.this.offset = event.getOffset();
            SpellingHelper.this.input = event.getText();
            SpellingHelper.this.replaced = event.getReplacedText();
            SpellingHelper.this.check();
        }
    }
}

