/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.internal.spelling.Messages;
import org.xmind.ui.internal.spelling.SpellCheckerAgent;
import org.xmind.ui.internal.spelling.SpellingPlugin;

public class SpellingCheckPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private List<FieldEditor> settingFields = new ArrayList<FieldEditor>();
    private Composite settingsParent;

    public SpellingCheckPrefPage() {
        super(Messages.SpellingPrefPage_title, 0);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(SpellingPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("SPELLING_CHECK_ENABLED", Messages.enableSpellCheck, this.getFieldEditorParent()));
        this.addSpellingSettings();
        this.updateOptions(SpellingPlugin.isSpellingCheckEnabled());
    }

    private void addSpellingSettings() {
        this.settingsParent = this.createSettingsParent();
        this.addSettingField("SPELL_IGNOREUPPERCASE", Messages.ignoreAllCapital);
        this.addSettingField("SPELL_IGNOREMIXEDCASE", Messages.ignoreMultiCapital);
        this.addSettingField("SPELL_IGNOREINTERNETADDRESS", Messages.ignoreWebAddress);
        this.addSettingField("SPELL_IGNOREDIGITWORDS", Messages.ignoreNumberousAppendix);
        this.addSettingField("SPELL_IGNORESENTENCECAPTILIZATION", Messages.ignoreFirstLowercaseSentences);
    }

    private void addSettingField(String name, String label) {
        BooleanFieldEditor field = new BooleanFieldEditor(name, label, this.settingsParent);
        this.addField((FieldEditor)field);
        this.settingFields.add((FieldEditor)field);
    }

    private Composite createSettingsParent() {
        Composite parent = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        Label blank = new Label(parent, 0);
        blank.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Group group = new Group(parent, 0);
        group.setText(Messages.options);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 5;
        gridLayout2.marginHeight = 5;
        gridLayout2.verticalSpacing = 0;
        gridLayout2.horizontalSpacing = 0;
        group.setLayout((Layout)gridLayout2);
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void updateOptions(boolean enabled) {
        this.settingsParent.setEnabled(enabled);
        for (FieldEditor field : this.settingFields) {
            field.setEnabled(enabled, this.settingsParent);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        FieldEditor field = (FieldEditor)event.getSource();
        if ("SPELLING_CHECK_ENABLED".equals(field.getPreferenceName())) {
            this.updateOptions(((BooleanFieldEditor)field).getBooleanValue());
        }
        super.propertyChange(event);
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        if (ok) {
            SpellCheckerAgent.setConfigurations(this.getPreferenceStore());
        }
        return ok;
    }
}

