/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.SpellChecker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jazzy.Activator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.Core;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.spelling.ISpellCheckerVisitor;
import org.xmind.ui.internal.spelling.Messages;
import org.xmind.ui.internal.spelling.SpellingPlugin;

public class SpellCheckerAgent {
    private static final SpellCheckerAgent instance = new SpellCheckerAgent();
    private SpellChecker spellChecker;
    private Configuration configuration;
    private List<ISpellCheckerVisitor> visitors;

    public static void visitSpellChecker(ISpellCheckerVisitor visitor) {
        SpellCheckerAgent.getInstance().doVisitSpellChecker(visitor);
    }

    public static void setConfigurations(IPreferenceStore prefStore) {
        SpellCheckerAgent.getInstance().doSetConfigurations(prefStore);
    }

    private synchronized void doVisitSpellChecker(ISpellCheckerVisitor visitor) {
        if (this.spellChecker != null) {
            visitor.handleWith(this.spellChecker);
            return;
        }
        if (this.visitors != null) {
            this.visitors.add(visitor);
            return;
        }
        this.visitors = new ArrayList<ISpellCheckerVisitor>();
        this.visitors.add(visitor);
        final Display preservedDisplay = Display.getCurrent();
        new Job(Messages.loadingSpellChecker){

            protected IStatus run(IProgressMonitor monitor) {
                return SpellCheckerAgent.this.loadSpellChecker(monitor, preservedDisplay);
            }
        }.schedule();
    }

    private IStatus loadSpellChecker(IProgressMonitor monitor, Display display) {
        monitor.beginTask(null, 5);
        monitor.subTask(Messages.creatingSpellCheckerInstance);
        SpellChecker spellChecker = Activator.createSpellChecker();
        monitor.worked(1);
        monitor.subTask(Messages.addingSystemDictionary);
        this.addSystemDictionary(spellChecker);
        monitor.worked(1);
        monitor.subTask(Messages.addingUserDictionary);
        this.addUserDictionary(spellChecker);
        monitor.worked(1);
        monitor.subTask(Messages.initializingSpellingSettings);
        this.setConfigurations(spellChecker);
        monitor.worked(1);
        this.spellChecker = spellChecker;
        monitor.subTask(Messages.notifyingSpellingVisitors);
        this.notifyVisitors(display);
        monitor.done();
        return new Status(0, "org.xmind.ui.spelling", "Finish loading spell checker");
    }

    private void notifyVisitors(Display display) {
        if (this.visitors == null) {
            return;
        }
        int i = 0;
        while (i < this.visitors.size()) {
            final ISpellCheckerVisitor visitor = this.visitors.get(i);
            if (visitor != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        visitor.handleWith(SpellCheckerAgent.this.spellChecker);
                    }
                });
            }
            ++i;
        }
        this.visitors = null;
    }

    private void setConfigurations(SpellChecker spellChecker) {
        this.configuration = spellChecker.getConfiguration();
        this.doSetConfigurations(SpellingPlugin.getDefault().getPreferenceStore());
    }

    private void addUserDictionary(SpellChecker spellChecker) {
        File userDict = FileUtils.ensureFileParent((File)new File(Core.getWorkspace().getAbsolutePath("spelling/user.dict")));
        if (!userDict.exists()) {
            try {
                new FileOutputStream(userDict).close();
            }
            catch (IOException iOException) {}
        }
        try {
            spellChecker.setUserDictionary((SpellDictionary)new SpellDictionaryHashMap(userDict));
        }
        catch (IOException e) {
            SpellingPlugin.log(e);
        }
    }

    private void addSystemDictionary(SpellChecker spellChecker) {
        try {
            spellChecker.addDictionary((SpellDictionary)new SpellDictionaryHashMap((Reader)new InputStreamReader(SpellCheckerAgent.class.getResourceAsStream("xmind.dict"))));
        }
        catch (IOException e) {
            SpellingPlugin.log(e);
        }
    }

    private void doSetConfigurations(IPreferenceStore ps) {
        if (this.configuration == null) {
            return;
        }
        this.configuration.setBoolean("SPELL_IGNOREDIGITWORDS", ps.getBoolean("SPELL_IGNOREDIGITWORDS"));
        this.configuration.setBoolean("SPELL_IGNOREINTERNETADDRESS", ps.getBoolean("SPELL_IGNOREINTERNETADDRESS"));
        this.configuration.setBoolean("SPELL_IGNOREMIXEDCASE", ps.getBoolean("SPELL_IGNOREMIXEDCASE"));
        this.configuration.setBoolean("SPELL_IGNORESENTENCECAPTILIZATION", ps.getBoolean("SPELL_IGNORESENTENCECAPTILIZATION"));
        this.configuration.setBoolean("SPELL_IGNOREUPPERCASE", ps.getBoolean("SPELL_IGNOREUPPERCASE"));
    }

    private static SpellCheckerAgent getInstance() {
        return instance;
    }
}

