/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    TableItem scrollItem;
    long scrollBeginTime;
    DataBrowserCallbacks callbacks = null;
    static Callback AcceptDragProc;
    static /* synthetic */ Class class$0;

    static {
        int acceptDragProc;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.TableDropTargetEffect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((acceptDragProc = (AcceptDragProc = new Callback(clazz, "AcceptDragProc", 5)).getAddress()) == 0) {
            SWT.error(3);
        }
    }

    static int AcceptDragProc(int theControl, int itemID, int property, int theRect, int theDrag) {
        DropTarget target = TableDropTargetEffect.FindDropTarget(theControl, theDrag);
        if (target == null) {
            return 0;
        }
        return (target.feedback & 1) != 0 ? 1 : 0;
    }

    static DropTarget FindDropTarget(int theControl, int theDrag) {
        if (theControl == 0) {
            return null;
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(theControl);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    public TableDropTargetEffect(Table table) {
        super(table);
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    public void dragEnter(DropTargetEvent event) {
        if (this.callbacks == null) {
            Table table = (Table)this.control;
            DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
            OS.GetDataBrowserCallbacks(table.handle, callbacks);
            callbacks.v1_acceptDragCallback = AcceptDragProc.getAddress();
            OS.SetDataBrowserCallbacks(table.handle, callbacks);
        }
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragLeave(DropTargetEvent event) {
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragOver(DropTargetEvent event) {
        Table table = (Table)this.control;
        int effect = this.checkEffect(event.feedback);
        TableItem item = (TableItem)this.getItem(table, event.x, event.y);
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (item != null && item.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int index;
                Rectangle area = table.getClientArea();
                int headerHeight = table.getHeaderHeight();
                int itemHeight = table.getItemHeight();
                Point pt = new Point(event.x, event.y);
                pt = table.getDisplay().map(null, (Control)table, pt);
                TableItem nextItem = null;
                if (pt.y < area.y + headerHeight + 2 * itemHeight) {
                    index = Math.max(0, table.indexOf(item) - 1);
                    nextItem = table.getItem(index);
                }
                if (pt.y > area.y + area.height - 2 * itemHeight) {
                    index = Math.min(table.getItemCount() - 1, table.indexOf(item) + 1);
                    nextItem = table.getItem(index);
                }
                if (nextItem != null) {
                    table.showItem(nextItem);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = item;
        }
        ((DropTarget)event.widget).feedback = effect;
    }
}

