/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.xmind.ui.animation.AnimationViewer;
import org.xmind.ui.animation.IAnimationContentProvider;
import org.xmind.ui.browser.IBrowserViewer;
import org.xmind.ui.browser.IBrowserViewerContainer;
import org.xmind.ui.browser.IBrowserViewerContribution;
import org.xmind.ui.browser.IBrowserViewerContribution2;
import org.xmind.ui.browser.IPropertyChangingListener;
import org.xmind.ui.browser.PropertyChangingEvent;
import org.xmind.ui.internal.browser.BrowserContributionManager;
import org.xmind.ui.internal.browser.BrowserErrorText;
import org.xmind.ui.internal.browser.BrowserImages;
import org.xmind.ui.internal.browser.BrowserMessages;
import org.xmind.ui.internal.browser.BrowserPref;
import org.xmind.ui.internal.browser.MozillaPref;
import org.xmind.ui.viewers.ImageCachedLabelProvider;

public class BrowserViewer
implements IBrowserViewer {
    private static Object DEFAULT_BUSY_PICTURES = null;
    private static final int MAX_HISTORY = 50;
    private static final String URL_HOME = "http://www.xmind.net";
    private static List<String> URL_HISTORY;
    private Composite composite;
    private boolean mozilla;
    private Clipboard clipboard;
    private Combo location;
    private AnimationViewer homeBusy;
    private boolean loading;
    private Composite browserContainer;
    private Browser browser;
    private BrowserListener browserListener;
    private BrowserErrorText errorText;
    private IBrowserViewerContainer container;
    private int progressWorked = 0;
    private List<PropertyChangeListener> propertyListeners;
    private BackAction backAction;
    private ForwardAction forwardAction;
    private StopRefreshAction stopRefreshAction;

    public BrowserViewer(Composite parent, int style) {
        this(parent, style, null);
    }

    public BrowserViewer(Composite parent, int style, IBrowserViewerContainer container) {
        this.container = container;
        this.composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContents(this.composite);
        this.hookControl((Control)this.composite);
    }

    protected void hookControl(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BrowserViewer.this.handleDispose();
            }
        });
        for (IBrowserViewerContribution contribution : BrowserContributionManager.getInstance().getContributions()) {
            if (!(contribution instanceof IBrowserViewerContribution2)) continue;
            ((IBrowserViewerContribution2)((Object)contribution)).installBrowserListeners(this);
        }
    }

    protected void createContents(Composite parent) {
        this.clipboard = new Clipboard(parent.getDisplay());
        this.createToolBar(parent);
        this.createBrowser(parent);
        this.updateHistory();
        this.updateBackNextBusy();
    }

    protected void createToolBar(Composite parent) {
        Composite toolbarContainer = new Composite(parent, 0);
        GridLayout toolbarLayout = new GridLayout();
        toolbarLayout.marginHeight = 2;
        toolbarLayout.marginWidth = 2;
        toolbarLayout.horizontalSpacing = 5;
        toolbarLayout.verticalSpacing = 0;
        toolbarContainer.setLayout((Layout)toolbarLayout);
        toolbarContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.createToolbarContents(toolbarContainer);
        this.createLocationBar(toolbarContainer);
        this.createExtraContributions(toolbarContainer);
        this.createHomeBusyIndicator(toolbarContainer);
        toolbarLayout.numColumns = toolbarContainer.getChildren().length;
    }

    private void createExtraContributions(final Composite toolbarContainer) {
        ContributionManager toolbar = new ContributionManager(){

            public void update(boolean force) {
                IContributionItem[] iContributionItemArray = this.getItems();
                int n = iContributionItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem item = iContributionItemArray[n2];
                    item.fill(toolbarContainer);
                    ++n2;
                }
            }
        };
        for (IBrowserViewerContribution contribution : BrowserContributionManager.getInstance().getContributions()) {
            contribution.fillToolBar(this, (IContributionManager)toolbar);
        }
        toolbar.update(true);
    }

    private void createToolbarContents(Composite parent) {
        ToolBarManager toolbar = new ToolBarManager(0x800000);
        this.backAction = new BackAction();
        toolbar.add((IAction)this.backAction);
        this.forwardAction = new ForwardAction();
        toolbar.add((IAction)this.forwardAction);
        this.stopRefreshAction = new StopRefreshAction();
        toolbar.add((IAction)this.stopRefreshAction);
        toolbar.createControl(parent);
        toolbar.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    private void createLocationBar(Composite parent) {
        this.location = new Combo(parent, 2052);
        this.location.setLayoutData((Object)new GridData(4, 4, true, false));
        this.updateHistory();
        this.location.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                int end = BrowserViewer.this.location.getText().length();
                BrowserViewer.this.location.setSelection(new Point(0, end));
            }
        });
        this.location.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                BrowserViewer.this.setURL(BrowserViewer.this.location.getText());
            }
        });
    }

    protected void createHomeBusyIndicator(Composite parenet) {
        this.homeBusy = new AnimationViewer(parenet, 0);
        this.homeBusy.setContentProvider((IContentProvider)new BusyIndicatorContentProvider());
        this.homeBusy.setLabelProvider((IBaseLabelProvider)new BusyIndicatorLabelProvider());
        this.homeBusy.setInput(BrowserViewer.getDefaultBusyPictures());
        this.homeBusy.getControl().setLayoutData((Object)new GridData(128));
        this.homeBusy.getControl().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                BrowserViewer.this.setURL(BrowserViewer.URL_HOME);
            }
        });
    }

    public AnimationViewer getBusyIndicator() {
        return this.homeBusy;
    }

    protected void createBrowser(Composite parent) {
        this.browserContainer = new Composite(parent, 0);
        this.browserContainer.setLayout((Layout)new StackLayout());
        this.browserContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Browser b = null;
        try {
            b = this.createBrowser(this.browserContainer, 34816);
            this.mozilla = true;
        }
        catch (SWTError sWTError) {
            this.mozilla = false;
            try {
                b = this.createBrowser(this.browserContainer, 0);
            }
            catch (SWTError e2) {
                if (e2.code != 2) {
                    return;
                }
                this.errorText = new BrowserErrorText(this.browserContainer, this, e2);
            }
        }
        if (b != null) {
            this.browser = b;
        }
        if (this.mozilla) {
            new MozillaPref(this);
        }
        this.browserListener = new BrowserListener();
        if (this.browser != null) {
            this.browserListener.hook(this.browser);
            this.show((Control)this.browser);
        } else {
            this.show(this.errorText.getControl());
        }
    }

    private void show(Control control) {
        ((StackLayout)this.browserContainer.getLayout()).topControl = control;
        Control[] controlArray = this.browserContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c;
            c.setVisible((c = controlArray[n2]) == control);
            ++n2;
        }
        this.browserContainer.layout();
    }

    private Browser createBrowser(Composite parent, int style) {
        return new Browser(parent, style);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Control getControl() {
        return this.composite;
    }

    private void home() {
        this.browser.setText("");
    }

    public boolean setURL(String url) {
        return this.setURL(url, true);
    }

    private boolean setURL(String url, boolean browse) {
        if (url == null) {
            this.home();
            return true;
        }
        if ("xmind".equalsIgnoreCase(url)) {
            url = URL_HOME;
        }
        if (browse) {
            this.navigate(url);
        }
        this.addToHistory(url);
        this.updateHistory();
        return true;
    }

    protected void updateBackNextBusy() {
        this.backAction.setEnabled(this.isBackEnabled());
        this.forwardAction.setEnabled(this.isForwardEnabled());
        if (this.loading) {
            this.homeBusy.start();
        } else {
            this.homeBusy.stop();
        }
    }

    public Combo getLocationBar() {
        return this.location;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public void copy() {
        if (this.location == null || this.location.isDisposed() || !this.location.isFocusControl()) {
            return;
        }
        this.location.copy();
    }

    public void cut() {
        if (this.location == null || this.location.isDisposed() || !this.location.isFocusControl()) {
            return;
        }
        this.location.cut();
    }

    public void delete() {
        if (this.location == null || this.location.isDisposed() || !this.location.isFocusControl()) {
            return;
        }
        String text = this.location.getText();
        Point selection = this.location.getSelection();
        if (selection.y > selection.x) {
            text = String.valueOf(text.substring(0, selection.x)) + text.substring(selection.y);
            this.location.setText(text);
            this.location.setSelection(new Point(selection.x, selection.x));
        }
    }

    public void paste() {
        if (this.location == null || this.location.isDisposed() || !this.location.isFocusControl()) {
            return;
        }
        this.location.paste();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList<PropertyChangeListener>();
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        Object[] objectArray = this.propertyListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object pcl = objectArray[n2];
            try {
                ((PropertyChangeListener)pcl).propertyChange(event);
            }
            catch (Throwable throwable) {}
            ++n2;
        }
    }

    protected boolean firePropertyChangingEvent(String propertyName, Object oldValue, Object newValue, boolean doit) {
        if (this.propertyListeners == null) {
            return doit;
        }
        PropertyChangingEvent event = new PropertyChangingEvent(this, propertyName, oldValue, newValue, doit);
        Object[] objectArray = this.propertyListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object pcl = objectArray[n2];
            if (pcl instanceof IPropertyChangingListener) {
                try {
                    ((IPropertyChangingListener)pcl).propertyChanging(event);
                }
                catch (Throwable throwable) {}
            }
            ++n2;
        }
        return event.doit;
    }

    public boolean forward() {
        if (this.browser == null) {
            return false;
        }
        boolean forward = this.browser.forward();
        return forward;
    }

    public boolean back() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.back();
    }

    public boolean isBackEnabled() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.isBackEnabled();
    }

    public boolean isForwardEnabled() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.isForwardEnabled();
    }

    public void stop() {
        if (this.browser != null) {
            this.browser.stop();
        }
        this.setLoading(false);
    }

    public boolean setText(String html) {
        return false;
    }

    private boolean navigate(String url) {
        if (url != null && url.equals(this.getURL())) {
            this.refresh();
            return true;
        }
        if (this.browser != null) {
            return this.browser.setUrl(url);
        }
        return this.errorText.setUrl(url);
    }

    public void refresh() {
        if (this.browser != null) {
            this.browser.refresh();
        } else {
            this.errorText.refresh();
        }
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {}
    }

    protected void addToHistory(String url) {
        if (URL_HISTORY == null) {
            URL_HISTORY = BrowserPref.getInternalWebBrowserHistory();
        }
        int found = -1;
        int size = URL_HISTORY.size();
        int i = 0;
        while (i < size) {
            String s = URL_HISTORY.get(i);
            if (s.equals(url)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found == -1) {
            if (size >= 50) {
                URL_HISTORY.remove(size - 1);
            }
            URL_HISTORY.add(0, url);
            BrowserPref.setInternalWebBrowserHistory(URL_HISTORY);
        } else if (found != 0) {
            URL_HISTORY.remove(found);
            URL_HISTORY.add(0, url);
            BrowserPref.setInternalWebBrowserHistory(URL_HISTORY);
        }
    }

    protected void handleDispose() {
        IStatusLineManager manager;
        for (IBrowserViewerContribution contribution : BrowserContributionManager.getInstance().getContributions()) {
            if (!(contribution instanceof IBrowserViewerContribution2)) continue;
            ((IBrowserViewerContribution2)((Object)contribution)).uninstallBrowserListeners(this);
        }
        if (this.container != null && (manager = this.container.getActionBars().getStatusLineManager()) != null) {
            manager.getProgressMonitor().done();
        }
        this.homeBusy = null;
        this.browser = null;
        this.errorText = null;
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = null;
    }

    private void setLoading(boolean loading) {
        this.loading = loading;
        if (loading) {
            if (this.stopRefreshAction != null) {
                this.stopRefreshAction.setStop();
            }
        } else {
            if (this.stopRefreshAction != null) {
                this.stopRefreshAction.setRefresh();
            }
            if (this.homeBusy != null) {
                this.homeBusy.stop();
            }
            if (this.container != null) {
                IProgressMonitor monitor = this.container.getActionBars().getStatusLineManager().getProgressMonitor();
                monitor.done();
            }
        }
    }

    public String getURL() {
        if (this.browser != null) {
            return this.browser.getUrl();
        }
        return this.errorText.getUrl();
    }

    protected void updateHistory() {
        if (this.location == null) {
            return;
        }
        String temp = this.location.getText();
        if (URL_HISTORY == null) {
            URL_HISTORY = BrowserPref.getInternalWebBrowserHistory();
        }
        String[] historyList = new String[URL_HISTORY.size()];
        URL_HISTORY.toArray(historyList);
        this.location.setItems(historyList);
        this.location.setText(temp);
    }

    public IBrowserViewerContainer getContainer() {
        return this.container;
    }

    public void setFocus() {
        if (this.browser != null) {
            if (this.browser.setFocus()) {
                this.updateHistory();
            } else if (this.location != null) {
                this.location.setFocus();
            }
        }
    }

    public boolean isMozilla() {
        return this.mozilla;
    }

    private static Object getDefaultBusyPictures() {
        if (DEFAULT_BUSY_PICTURES == null) {
            ArrayList<ImageDescriptor> list = new ArrayList<ImageDescriptor>(13);
            list.add(BrowserImages.getImageDescriptor("icons/xmind.16.gif"));
            list.addAll((Collection)Arrays.asList(BrowserImages.getBusyImages()));
            DEFAULT_BUSY_PICTURES = list.toArray();
        }
        return DEFAULT_BUSY_PICTURES;
    }

    private class BackAction
    extends Action {
        public BackAction() {
            super(BrowserMessages.BrowserViewer_PrevPage_toolTip, BrowserImages.getImageDescriptor("backward_nav.gif", true));
            this.setToolTipText(BrowserMessages.BrowserViewer_PrevPage_toolTip);
            this.setDisabledImageDescriptor(BrowserImages.getImageDescriptor("backward_nav.gif", false));
        }

        public void run() {
            BrowserViewer.this.back();
        }
    }

    private class BrowserListener
    implements LocationListener,
    OpenWindowListener,
    VisibilityWindowListener,
    CloseWindowListener,
    ProgressListener,
    TitleListener,
    StatusTextListener {
        private String locationText;
        private String titleText;

        private BrowserListener() {
        }

        public void hook(Browser browser) {
            browser.addLocationListener((LocationListener)this);
            browser.addOpenWindowListener((OpenWindowListener)this);
            browser.addVisibilityWindowListener((VisibilityWindowListener)this);
            browser.addCloseWindowListener((CloseWindowListener)this);
            browser.addProgressListener((ProgressListener)this);
            browser.addTitleListener((TitleListener)this);
            browser.addStatusTextListener((StatusTextListener)this);
        }

        public void unhook(Browser browser) {
            browser.removeLocationListener((LocationListener)this);
            browser.removeOpenWindowListener((OpenWindowListener)this);
            browser.removeVisibilityWindowListener((VisibilityWindowListener)this);
            browser.removeCloseWindowListener((CloseWindowListener)this);
            browser.removeProgressListener((ProgressListener)this);
            browser.removeTitleListener((TitleListener)this);
            browser.removeStatusTextListener((StatusTextListener)this);
        }

        public void changed(LocationEvent event) {
            if (!event.top) {
                return;
            }
            if (!"about:blank".equals(event.location)) {
                String oldLocation = this.locationText;
                this.locationText = event.location;
                if (BrowserViewer.this.location != null) {
                    BrowserViewer.this.location.setText(event.location);
                }
                BrowserViewer.this.addToHistory(event.location);
                BrowserViewer.this.updateHistory();
                BrowserViewer.this.firePropertyChangeEvent("location", event.location, oldLocation);
            }
        }

        public void changing(LocationEvent event) {
            if (!"about:blank".equals(event.location)) {
                event.doit = BrowserViewer.this.firePropertyChangingEvent("location", this.locationText, event.location, event.doit);
            }
        }

        public void open(WindowEvent event) {
            if (BrowserViewer.this.container != null) {
                event.browser = BrowserViewer.this.container.openNewBrowser();
            }
        }

        public void hide(WindowEvent event) {
        }

        public void show(WindowEvent event) {
        }

        public void close(WindowEvent event) {
            if (BrowserViewer.this.container != null) {
                BrowserViewer.this.container.close();
            }
        }

        public void changed(ProgressEvent event) {
            if (event.total == 0) {
                return;
            }
            boolean done = event.current == event.total;
            int percentProgress = event.current * 100 / event.total;
            if (BrowserViewer.this.container != null) {
                IProgressMonitor monitor = BrowserViewer.this.container.getActionBars().getStatusLineManager().getProgressMonitor();
                if (done) {
                    monitor.done();
                    BrowserViewer.this.progressWorked = 0;
                } else if (BrowserViewer.this.progressWorked == 0) {
                    monitor.beginTask("", event.total);
                    BrowserViewer.this.progressWorked = percentProgress;
                } else {
                    monitor.worked(event.current - BrowserViewer.this.progressWorked);
                    BrowserViewer.this.progressWorked = event.current;
                }
            }
            if (!BrowserViewer.this.homeBusy.isAnimating() && !done) {
                BrowserViewer.this.setLoading(true);
            } else if (BrowserViewer.this.homeBusy.isAnimating() && done) {
                BrowserViewer.this.setLoading(false);
            }
            BrowserViewer.this.updateBackNextBusy();
            BrowserViewer.this.updateHistory();
        }

        public void completed(ProgressEvent event) {
            if (BrowserViewer.this.container != null) {
                IProgressMonitor monitor = BrowserViewer.this.container.getActionBars().getStatusLineManager().getProgressMonitor();
                monitor.done();
            }
            BrowserViewer.this.setLoading(false);
            BrowserViewer.this.updateBackNextBusy();
            BrowserViewer.this.updateHistory();
        }

        public void changed(TitleEvent event) {
            String oldTitle = this.titleText;
            this.titleText = event.title;
            BrowserViewer.this.firePropertyChangeEvent("title", oldTitle, this.titleText);
        }

        public void changed(StatusTextEvent event) {
            if (BrowserViewer.this.container != null) {
                IStatusLineManager status = BrowserViewer.this.container.getActionBars().getStatusLineManager();
                status.setMessage(event.text);
            }
        }
    }

    private static class BusyIndicatorContentProvider
    extends ArrayContentProvider
    implements IAnimationContentProvider {
        private BusyIndicatorContentProvider() {
        }

        public long getDuration(Object element) {
            return -1L;
        }

        public Object getStaticElement(Object inputElement, Object[] elements) {
            return elements[0];
        }
    }

    private static class BusyIndicatorLabelProvider
    extends ImageCachedLabelProvider {
        private BusyIndicatorLabelProvider() {
        }

        protected Image createImage(Object element) {
            if (element instanceof ImageDescriptor) {
                ImageDescriptor desc = (ImageDescriptor)element;
                return desc.createImage(false);
            }
            return null;
        }
    }

    private class ForwardAction
    extends Action {
        public ForwardAction() {
            super(BrowserMessages.BrowserViewer_NextPage_toolTip, BrowserImages.getImageDescriptor("forward_nav.gif", true));
            this.setToolTipText(BrowserMessages.BrowserViewer_NextPage_toolTip);
            this.setDisabledImageDescriptor(BrowserImages.getImageDescriptor("forward_nav.gif", false));
        }

        public void run() {
            BrowserViewer.this.forward();
        }
    }

    private class StopRefreshAction
    extends Action {
        private boolean stop = false;

        public StopRefreshAction() {
            this.setRefresh();
        }

        public void setStop() {
            this.stop = true;
            this.setText(BrowserMessages.BrowserViewer_Stop_toolTip);
            this.setToolTipText(BrowserMessages.BrowserViewer_Stop_toolTip);
            this.setImageDescriptor(BrowserImages.getImageDescriptor("nav_stop.gif", true));
            this.setDisabledImageDescriptor(BrowserImages.getImageDescriptor("nav_stop.gif", false));
        }

        public void setRefresh() {
            this.stop = false;
            this.setText(BrowserMessages.BrowserViewer_Refresh_toolTip);
            this.setToolTipText(BrowserMessages.BrowserViewer_Refresh_toolTip);
            this.setImageDescriptor(BrowserImages.getImageDescriptor("refresh_nav.gif", true));
            this.setDisabledImageDescriptor(BrowserImages.getImageDescriptor("refresh_nav.gif", false));
        }

        public void run() {
            if (this.stop) {
                BrowserViewer.this.stop();
            } else {
                BrowserViewer.this.refresh();
            }
        }
    }
}

