/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.browser;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.xmind.ui.browser.BrowserSupport;

public abstract class BrowserDialog
extends Dialog {
    protected static final String COMMAND_PROTOCOL = "xmind://";
    protected static final String COMMAND_CANCEL = "cancel";
    protected static final String COMMAND_SKIP = "skip";
    protected static final String COMMAND_OPEN = "open";
    private Browser browser;
    private BrowserListener browserListener = new BrowserListener();

    public BrowserDialog(Shell parent) {
        super(parent);
    }

    protected Control createContents(Composite parent) {
        try {
            this.browser = new Browser(parent, 32768);
        }
        catch (SWTError sWTError) {
            this.browser = new Browser(parent, 0);
        }
        this.browser.setLayoutData((Object)new GridData(1808));
        this.browser.addStatusTextListener((StatusTextListener)this.browserListener);
        this.browser.addTitleListener((TitleListener)this.browserListener);
        this.browser.addLocationListener((LocationListener)this.browserListener);
        String text = this.getInitialText();
        if (text != null) {
            this.browser.setText(text);
        } else {
            String url = this.getInitialURL();
            if (url != null) {
                this.browser.setUrl(url);
            }
        }
        if ("carbon".equals(SWT.getPlatform())) {
            this.browser.refresh();
        }
        return this.browser;
    }

    protected Browser getBrowser() {
        return this.browser;
    }

    protected Point getInitialSize() {
        return new Point(500, 325);
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle r = Display.getCurrent().getClientArea();
        return new Point((r.width - initialSize.x) / 2, (r.height - initialSize.y) / 2);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected String getInitialText() {
        return null;
    }

    protected String getInitialURL() {
        return null;
    }

    protected boolean execCommandLine(String commandLine) {
        String[] commands = commandLine.split("/");
        if (commands.length > 1) {
            String commandName = commands[0];
            String[] params = new String[commands.length - 1];
            System.arraycopy(commands, 1, params, 0, commands.length - 1);
            return this.execCommand(commandName, params);
        }
        return false;
    }

    protected boolean execCommand(String commandName, String[] params) {
        if (COMMAND_CANCEL.equals(commandName)) {
            return this.performCancel();
        }
        if (COMMAND_SKIP.equals(commandName)) {
            return this.performSkip();
        }
        if (COMMAND_OPEN.equals(commandName)) {
            return this.performOpen(params);
        }
        return false;
    }

    protected boolean performOpen(String[] params) {
        if (params.length > 0) {
            String url = params[0];
            try {
                url = URLDecoder.decode(url, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            try {
                BrowserSupport.getInstance().createBrowser().openURL(url);
                return true;
            }
            catch (PartInitException partInitException) {}
        }
        return false;
    }

    protected boolean performSkip() {
        this.setReturnCode(12);
        return super.close();
    }

    protected boolean performCancel() {
        this.setReturnCode(1);
        return super.close();
    }

    private class BrowserListener
    implements StatusTextListener,
    TitleListener,
    LocationListener {
        private BrowserListener() {
        }

        public void changed(StatusTextEvent event) {
            this.checkCommand(event.text);
        }

        public void changed(TitleEvent event) {
            String t = event.title;
            if (t != null && t.startsWith("xmind:")) {
                BrowserDialog.this.browser.getShell().setText(t.substring(6));
            }
        }

        public void changed(LocationEvent event) {
        }

        public void changing(LocationEvent event) {
            if (this.checkCommand(event.location)) {
                event.doit = false;
            }
        }

        private boolean checkCommand(String href) {
            if (href.startsWith(BrowserDialog.COMMAND_PROTOCOL)) {
                String commandLine = href.substring(BrowserDialog.COMMAND_PROTOCOL.length());
                return BrowserDialog.this.execCommandLine(commandLine);
            }
            return false;
        }
    }
}

