/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.xmind.ui.browser.BrowserSupport;
import org.xmind.ui.browser.IBrowser;
import org.xmind.ui.browser.IBrowserViewer;
import org.xmind.ui.browser.IBrowserViewerContainer;
import org.xmind.ui.internal.browser.BrowserImages;
import org.xmind.ui.internal.browser.BrowserMessages;
import org.xmind.ui.internal.browser.BrowserPlugin;
import org.xmind.ui.internal.browser.BrowserUtil;
import org.xmind.ui.internal.browser.BrowserViewer;
import org.xmind.ui.internal.browser.InternalBrowser;
import org.xmind.ui.internal.browser.InternalBrowserEditor;

public class InternalBrowserView
extends ViewPart
implements IBrowserViewerContainer {
    public static final String BROWSER_VIEW_ID = "org.xmind.ui.BrowserView";
    private BrowserViewer viewer;
    private String clientId;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void createPartControl(Composite parent) {
        this.initActions();
        this.viewer = new BrowserViewer(parent, 0, this);
    }

    private void initActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        OpenInExternalAction openInExternalAction = new OpenInExternalAction();
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)openInExternalAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)openInExternalAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public void openURL(String url) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setURL(url);
        }
    }

    public BrowserViewer getViewer() {
        return this.viewer;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IBrowserViewer.class) {
            return this.viewer;
        }
        if (adapter == IBrowserViewerContainer.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public boolean close() {
        try {
            this.getSite().getPage().hideView((IViewPart)this);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public IActionBars getActionBars() {
        return this.getViewSite().getActionBars();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void openInExternalBrowser(String url) {
        BrowserUtil.gotoUrl(url);
    }

    public Browser openNewBrowser() {
        final Browser[] ret = new Browser[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                IWorkbenchPart part;
                IBrowser browser = BrowserSupport.getInstance().createBrowser(4, InternalBrowserView.this.getClientId());
                browser.openURL("");
                if (browser instanceof InternalBrowser && (part = ((InternalBrowser)browser).getPart()) instanceof InternalBrowserEditor) {
                    ret[0] = ((InternalBrowserEditor)part).getViewer().getBrowser();
                }
            }
        });
        return ret[0];
    }

    private class OpenInExternalAction
    extends Action {
        public OpenInExternalAction() {
            super(BrowserMessages.BrowserView_OpenInExternalBrowser_text, BrowserImages.getImageDescriptor("icons/browser.gif"));
            this.setToolTipText(BrowserMessages.BrowserView_OpenInExternalBrowser_toolTip);
        }

        public void run() {
            if (InternalBrowserView.this.viewer == null || InternalBrowserView.this.viewer.getControl() == null || InternalBrowserView.this.viewer.getControl().isDisposed()) {
                return;
            }
            IBrowser browser = BrowserSupport.getInstance().createBrowser(1);
            try {
                browser.openURL(InternalBrowserView.this.viewer.getURL());
            }
            catch (PartInitException e) {
                BrowserPlugin.log(e);
            }
        }
    }
}

