/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.xmind.ui.browser.IBrowserViewerContainer;
import org.xmind.ui.internal.browser.BrowserEditorInput;
import org.xmind.ui.internal.browser.BrowserMessages;
import org.xmind.ui.internal.browser.BrowserPlugin;
import org.xmind.ui.internal.browser.BrowserUtil;
import org.xmind.ui.internal.browser.BrowserViewer;
import org.xmind.ui.internal.browser.actions.CopyAction;
import org.xmind.ui.internal.browser.actions.CutAction;
import org.xmind.ui.internal.browser.actions.DeleteAction;
import org.xmind.ui.internal.browser.actions.PasteAction;

public class InternalBrowserEditor
extends EditorPart
implements IBrowserViewerContainer {
    public static final String BROWSER_EDITOR_ID = "org.xmind.ui.browser.editor";
    private BrowserViewer viewer;
    private String initialURL;
    private Image image;
    private Map<String, IAction> actions;
    private boolean disposed;
    private boolean lockName;
    private static Map<String, Integer> numbers = new HashMap<String, Integer>();

    public String getClientId() {
        return this.getBrowserEditorInput().getClientId();
    }

    public IAction getAction(String id) {
        return this.actions == null ? null : this.actions.get(id);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof BrowserEditorInput) {
            BrowserEditorInput bei = (BrowserEditorInput)input;
            this.initialURL = null;
            if (bei.getURL() != null) {
                this.initialURL = bei.getURL();
            }
            if (this.viewer != null) {
                this.viewer.setURL(this.initialURL);
                site.getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
            }
            this.setPartName(bei.getName());
            this.setTitleToolTip(bei.getToolTipText());
            this.lockName = bei.isNameLocked();
            Image oldImage = this.image;
            ImageDescriptor id = bei.getImageDescriptor();
            this.image = id.createImage();
            this.setTitleImage(this.image);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
        } else {
            throw new PartInitException(NLS.bind((String)BrowserMessages.BrowserEditor_ErrorInvalidEditorInput_message, (Object)input.getName()));
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = null;
        super.dispose();
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new BrowserViewer(parent, 0, this);
        this.viewer.setURL(this.initialURL);
        this.addAction((IAction)new CopyAction(this.viewer));
        this.addAction((IAction)new CutAction(this.viewer));
        this.addAction((IAction)new PasteAction(this.viewer));
        this.addAction((IAction)new DeleteAction(this.viewer));
        if (!this.lockName) {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("title".equals(event.getPropertyName())) {
                        InternalBrowserEditor.this.setPartName((String)event.getNewValue());
                    }
                }
            };
            this.viewer.addPropertyChangeListener(propertyChangeListener);
        }
    }

    private void addAction(IAction action) {
        String actionId = action.getId();
        if (actionId == null) {
            return;
        }
        if (this.actions == null) {
            this.actions = new HashMap<String, IAction>();
        }
        this.actions.put(actionId, action);
    }

    protected BrowserEditorInput getBrowserEditorInput() {
        return (BrowserEditorInput)this.getEditorInput();
    }

    public static void open(BrowserEditorInput input) {
        IWorkbenchWindow workbenchWindow = BrowserPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            IEditorReference[] editors = page.getEditorReferences();
            int size = editors.length;
            int i = 0;
            while (i < size) {
                InternalBrowserEditor editor2;
                BrowserEditorInput input2;
                IEditorPart editor;
                if (BROWSER_EDITOR_ID.equals(editors[i].getId()) && (editor = editors[i].getEditor(true)) != null && editor instanceof InternalBrowserEditor && ((input2 = (editor2 = (InternalBrowserEditor)editor).getBrowserEditorInput()) == null || input.canReplaceInput(input2))) {
                    editor.init(editor.getEditorSite(), (IEditorInput)input);
                    return;
                }
                ++i;
            }
            page.openEditor((IEditorInput)input, BROWSER_EDITOR_ID);
        }
        catch (Exception exception) {}
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    public BrowserViewer getViewer() {
        return this.viewer;
    }

    public boolean close() {
        final boolean[] result = new boolean[1];
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                result[0] = InternalBrowserEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)InternalBrowserEditor.this, false);
            }
        });
        return result[0];
    }

    public IActionBars getActionBars() {
        return this.getEditorSite().getActionBars();
    }

    public void openInExternalBrowser(String url) {
        BrowserUtil.gotoUrl(url);
    }

    public void setText(String html) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setText(html);
        }
    }

    public Browser openNewBrowser() {
        final Browser[] ret = new Browser[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                BrowserEditorInput input = new BrowserEditorInput("", InternalBrowserEditor.this.getNewSecondaryId());
                IEditorPart editor = InternalBrowserEditor.this.getSite().getPage().openEditor((IEditorInput)input, InternalBrowserEditor.BROWSER_EDITOR_ID);
                if (editor instanceof InternalBrowserEditor) {
                    ret[0] = ((InternalBrowserEditor)editor).getViewer().getBrowser();
                }
            }
        });
        return ret[0];
    }

    private String getNewSecondaryId() {
        Integer num = numbers.get(this.getClientId());
        num = num == null ? Integer.valueOf(1) : Integer.valueOf(num + 1);
        numbers.put(this.getClientId(), num);
        return String.valueOf(this.getClientId()) + "-" + num.toString();
    }
}

