/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.service.AbstractFeedback;
import org.xmind.gef.service.IFeedback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFeedback
extends AbstractFeedback {
    private List<IFeedback> innerFeedbacks;

    public CompositeFeedback(List<IFeedback> feedbacks) {
        this.innerFeedbacks = new ArrayList<IFeedback>(feedbacks);
    }

    public CompositeFeedback(IFeedback ... feedbacks) {
        this.innerFeedbacks = new ArrayList<IFeedback>((Collection)Arrays.asList(feedbacks));
    }

    public CompositeFeedback() {
        this.innerFeedbacks = new ArrayList<IFeedback>();
    }

    public void addFeedback(IFeedback feedback) {
        this.innerFeedbacks.add(feedback);
    }

    public void removeFeedback(IFeedback feedback) {
        this.innerFeedbacks.remove(feedback);
    }

    public IFeedback getFeedback(int index) {
        return this.innerFeedbacks.get(index);
    }

    public List<IFeedback> getFeedbackParts() {
        return this.innerFeedbacks;
    }

    @Override
    public void setZoomManager(ZoomManager zoomManager) {
        super.setZoomManager(zoomManager);
        for (IFeedback p : this.innerFeedbacks) {
            p.setZoomManager(zoomManager);
        }
    }

    @Override
    public void addToLayer(IFigure layer) {
        for (IFeedback p : this.innerFeedbacks) {
            p.addToLayer(layer);
        }
    }

    @Override
    public boolean containsPoint(Point point) {
        int i = this.innerFeedbacks.size() - 1;
        while (i >= 0) {
            if (this.innerFeedbacks.get(i).containsPoint(point)) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public void removeFromLayer(IFigure layer) {
        int i = this.innerFeedbacks.size() - 1;
        while (i >= 0) {
            this.innerFeedbacks.get(i).removeFromLayer(layer);
            --i;
        }
    }

    @Override
    public void update() {
        for (IFeedback p : this.innerFeedbacks) {
            p.update();
        }
    }
}

