/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.policy;

import java.util.ArrayList;
import java.util.List;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.AbstractEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TraversablePolicy
extends AbstractEditPolicy {
    @Override
    public boolean understands(String requestType) {
        return super.understands(requestType) || "get traversables".equals(requestType);
    }

    @Override
    public void handle(Request request) {
        String requestType = request.getType();
        if ("get traversables".equals(requestType)) {
            this.getTraversables(request);
        }
    }

    protected void getTraversables(Request request) {
        IPart source = this.getTraverseSource(request);
        if (source == null) {
            return;
        }
        ArrayList<IPart> result = new ArrayList<IPart>();
        this.findTraversables(request, source, result);
        this.setTraverseResult(request, result);
    }

    protected IPart getTraverseSource(Request request) {
        IPart source = request.getPrimaryTarget();
        if (source != null && source.hasRole("traversable role")) {
            return source;
        }
        return null;
    }

    protected void setTraverseResult(Request request, List<IPart> result) {
        if (!result.isEmpty()) {
            request.setResult("traverseResult", result.toArray(new IPart[result.size()]));
        }
    }

    protected abstract void findTraversables(Request var1, IPart var2, List<IPart> var3);

    protected void addTraversableResults(List<? extends IPart> parts, List<IPart> result) {
        for (IPart iPart : parts) {
            this.addTraversableResult(iPart, result);
        }
    }

    protected void addTraversableResult(IPart part, List<IPart> result) {
        if (part != null && part.getStatus().isActive() && part.hasRole("traversable role")) {
            result.add(part);
        }
    }
}

