/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;

public class PrecisionRectangle {
    public double height;
    public double width;
    public double x;
    public double y;

    public PrecisionRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public PrecisionRectangle(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public PrecisionRectangle(PrecisionRectangle rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public PrecisionRectangle(Rectangle rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public PrecisionRectangle(PrecisionPoint loc, PrecisionDimension size) {
        this(loc.x, loc.y, size.width, size.height);
    }

    public PrecisionRectangle(PrecisionPoint p1, PrecisionPoint p2) {
        this.x = Math.min(p1.x, p2.x);
        this.y = Math.min(p1.y, p2.y);
        this.width = Math.abs(p1.x - p2.x);
        this.height = Math.abs(p1.y - p2.y);
    }

    public boolean contains(PrecisionPoint p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(PrecisionRectangle r) {
        return this.x <= r.x && this.y <= r.y && this.right() >= r.right() && this.bottom() >= r.bottom();
    }

    public boolean contains(double x, double y) {
        return y >= this.y && y < this.y + this.height && x >= this.x && x < this.x + this.width;
    }

    public boolean intersects(Rectangle rect) {
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean intersects(PrecisionRectangle rect) {
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean intersects(double x, double y, double width, double height) {
        return x < this.x + this.width && y < this.y + this.height && x + width > this.x && y + height > this.y;
    }

    public PrecisionRectangle crop(PrecisionInsets insets) {
        this.x += insets.left;
        this.y += insets.top;
        this.width -= insets.getWidth();
        this.height -= insets.getHeight();
        return this;
    }

    public PrecisionRectangle expand(double h, double v) {
        return this.shrink(-h, -v);
    }

    public PrecisionRectangle expand(PrecisionInsets insets) {
        this.x -= insets.left;
        this.y -= insets.top;
        this.height += insets.getHeight();
        this.width += insets.getWidth();
        return this;
    }

    public PrecisionRectangle getExpanded(double h, double v) {
        return new PrecisionRectangle(this).expand(h, v);
    }

    public PrecisionRectangle getExpanded(PrecisionInsets insets) {
        return new PrecisionRectangle(this).expand(insets);
    }

    public PrecisionRectangle shrink(double h, double v) {
        this.x += h;
        this.width -= h + h;
        this.y += v;
        this.height -= v + v;
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof PrecisionRectangle) {
            PrecisionRectangle pr = (PrecisionRectangle)o;
            return super.equals(o) && Math.abs(pr.x - this.x) < 1.0E-9 && Math.abs(pr.y - this.y) < 1.0E-9 && Math.abs(pr.width - this.width) < 1.0E-9 && Math.abs(pr.height - this.height) < 1.0E-8;
        }
        return super.equals(o);
    }

    public PrecisionRectangle scale(double factor) {
        this.x *= factor;
        this.y *= factor;
        this.width *= factor;
        this.height *= factor;
        return this;
    }

    public PrecisionRectangle translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public PrecisionRectangle translate(PrecisionDimension d) {
        return this.translate(d.width, d.height);
    }

    public PrecisionRectangle translate(PrecisionPoint p) {
        return this.translate(p.x, p.y);
    }

    public double right() {
        return this.x + this.width;
    }

    public double bottom() {
        return this.y + this.height;
    }

    public PrecisionPoint getLocation() {
        return new PrecisionPoint(this.x, this.y);
    }

    public PrecisionPoint getTopLeft() {
        return new PrecisionPoint(this.x, this.y);
    }

    public PrecisionPoint getTopRight() {
        return new PrecisionPoint(this.x + this.width, this.y);
    }

    public PrecisionPoint getBottomLeft() {
        return new PrecisionPoint(this.x, this.y + this.height);
    }

    public PrecisionPoint getBottomRight() {
        return new PrecisionPoint(this.x + this.width, this.y + this.height);
    }

    public PrecisionDimension getSize() {
        return new PrecisionDimension(this.width, this.height);
    }

    public PrecisionPoint getCenter() {
        return new PrecisionPoint(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    public Rectangle toDraw2DRectangle() {
        return PrecisionRectangle.toDraw2DRectangle(this.x, this.y, this.width, this.height);
    }

    public static Rectangle toDraw2DRectangle(double x, double y, double width, double height) {
        int intX = (int)Math.floor(x + 1.0E-9);
        int intY = (int)Math.floor(y + 1.0E-9);
        int intWidth = (int)Math.floor(width + x + 1.0E-9) - intX;
        int intHeight = (int)Math.floor(height + y + 1.0E-9) - intY;
        return new Rectangle(intX, intY, intWidth, intHeight);
    }

    public Rectangle getInnerBounds() {
        return PrecisionRectangle.getInnerBounds(this.x, this.y, this.width, this.height);
    }

    public Rectangle getOuterBounds() {
        return PrecisionRectangle.getOuterBounds(this.x, this.y, this.width, this.height);
    }

    public static Rectangle getInnerBounds(double x, double y, double width, double height) {
        int intX = (int)Math.ceil(x);
        int intY = (int)Math.ceil(y);
        int intWidth = (int)Math.floor(width + x) - intX;
        int intHeight = (int)Math.floor(height + y) - intY;
        return new Rectangle(intX, intY, intWidth, intHeight);
    }

    public static Rectangle getOuterBounds(double x, double y, double width, double height) {
        int intX = (int)Math.floor(x);
        int intY = (int)Math.floor(y);
        int intWidth = (int)Math.ceil(width + x) - intX;
        int intHeight = (int)Math.ceil(height + y) - intY;
        return new Rectangle(intX, intY, intWidth, intHeight);
    }

    public PrecisionRectangle setSize(PrecisionDimension d) {
        return this.setSize(d.width, d.height);
    }

    public PrecisionRectangle setSize(double w, double h) {
        this.width = w;
        this.height = h;
        return this;
    }

    public PrecisionRectangle setLocation(PrecisionPoint p) {
        return this.setLocation(p.x, p.y);
    }

    public PrecisionRectangle setLocation(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public PrecisionRectangle setBounds(PrecisionRectangle r) {
        return this.setBounds(r.x, r.y, r.width, r.height);
    }

    public PrecisionRectangle setBounds(Rectangle r) {
        return this.setBounds(r.x, r.y, r.width, r.height);
    }

    public PrecisionRectangle setBounds(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        return this;
    }

    public PrecisionInsets getInsets(double x, double y) {
        return new PrecisionInsets(y - this.y, x - this.x, this.bottom() - y, this.right() - x);
    }

    public PrecisionInsets getInsets(PrecisionPoint p) {
        return this.getInsets(p.x, p.y);
    }

    public PrecisionRectangle union(PrecisionPoint p) {
        if (p == null) {
            return this;
        }
        return this.union(p.x, p.y);
    }

    public PrecisionRectangle union(double x1, double y1) {
        if (x1 < this.x) {
            this.width += this.x - x1;
            this.x = x1;
        } else {
            double right = this.x + this.width;
            if (x1 >= right) {
                right = x1;
                this.width = right - this.x;
            }
        }
        if (y1 < this.y) {
            this.height += this.y - y1;
            this.y = y1;
        } else {
            double bottom = this.y + this.height;
            if (y1 >= bottom) {
                bottom = y1;
                this.height = bottom - this.y;
            }
        }
        return this;
    }

    public PrecisionRectangle union(PrecisionRectangle r) {
        if (r == null) {
            return this;
        }
        return this.union(r.x, r.y, r.width, r.height);
    }

    public PrecisionRectangle union(double x, double y, double w, double h) {
        double right = Math.max(this.x + this.width, x + w);
        double bottom = Math.max(this.y + this.height, y + h);
        this.x = Math.min(this.x, x);
        this.y = Math.min(this.y, y);
        this.width = right - this.x;
        this.height = bottom - this.y;
        return this;
    }

    public PrecisionRectangle resize(double w, double h) {
        this.width += w;
        this.height += h;
        return this;
    }

    public PrecisionRectangle getCopy() {
        return new PrecisionRectangle(this.x, this.y, this.width, this.height);
    }

    public PrecisionRectangle getResize(double w, double h) {
        return this.getCopy().resize(w, h);
    }

    public String toString() {
        return "PrecisionRectangle(" + this.x + "," + this.y + "," + this.width + "," + this.height + ")";
    }
}

