/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionLine;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionPointPair;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Geometry {
    public static final double MIN_DISTANCE = 1.0E-8;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double NEG_HALF_PI = -1.5707963267948966;

    protected Geometry() {
    }

    public static double getAngle(double x, double y) {
        if (x == 0.0) {
            if (y > 0.0) {
                return 1.5707963267948966;
            }
            if (y < 0.0) {
                return -1.5707963267948966;
            }
            return 0.0;
        }
        double a = Math.atan(y / x);
        if (x > 0.0) {
            return a;
        }
        if (y < 0.0) {
            return a - Math.PI;
        }
        return a + Math.PI;
    }

    public static double getAngle(Dimension d) {
        return Geometry.getAngle(d.width, d.height);
    }

    public static double getAngle(PrecisionDimension d) {
        return Geometry.getAngle(d.width, d.height);
    }

    public static double getAngle(Point p) {
        return Geometry.getAngle(p.x, p.y);
    }

    public static double getAngle(PrecisionPoint p) {
        return Geometry.getAngle(p.x, p.y);
    }

    public static double getAngle(Point p, Point origin) {
        return Geometry.getAngle(p.x - origin.x, p.y - origin.y);
    }

    public static double getAngle(PrecisionPoint p, PrecisionPoint origin) {
        return Geometry.getAngle(p.x - origin.x, p.y - origin.y);
    }

    public static PrecisionPoint getPoint(double x1, double y1, double x2, double y2, double deltaAngle, double amount, double minDistance, PrecisionPoint result) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double d = Math.max(Math.hypot(dx, dy), minDistance);
        double angle = Geometry.getAngle(dx, dy);
        return result.setLocation(x1, y1).move(angle + deltaAngle, d * amount);
    }

    public static PrecisionPoint getPoint(double x1, double y1, double x2, double y2, double deltaAngle, double amount, PrecisionPoint result) {
        return Geometry.getPoint(x1, y1, x2, y2, deltaAngle, amount, 1.0E-8, result);
    }

    public static PrecisionPoint getPoint2(double x1, double y1, double x2, double y2, double deltaAngle, double dist, PrecisionPoint result) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Geometry.getAngle(dx, dy);
        return result.setLocation(x1, y1).move(angle + deltaAngle, dist);
    }

    public static double getAmount(double x, double y, double x1, double y1, double x2, double y2, double minDistance) {
        if (minDistance <= 0.0) {
            throw new IllegalArgumentException();
        }
        double d = Math.hypot(x - x1, y - y1);
        double d2 = Math.max(Math.hypot(x2 - x1, y2 - y1), minDistance);
        return d / d2;
    }

    public static double getAmount(double x, double y, double x1, double y1, double x2, double y2) {
        return Geometry.getAmount(x, y, x1, y1, x2, y2, 1.0E-8);
    }

    public static double getDeltaAngle(double x, double y, double x1, double y1, double x2, double y2) {
        double angle = Geometry.getAngle(x - x1, y - y1);
        double angle2 = Geometry.getAngle(x2 - x1, y2 - y1);
        return Geometry.constrainAngleRadian(angle - angle2);
    }

    public static Point getPoint(double angle, double distance) {
        double x = distance * Math.cos(angle);
        double y = distance * Math.sin(angle);
        return new Point((int)x, (int)y);
    }

    public static Point getPoint(Point p, double angle, double distance) {
        return p.getTranslated(Geometry.getPoint(angle, distance));
    }

    public static boolean isSameAngleDegree(double angle1, double angle2, double tolerance) {
        return Math.abs(Geometry.constrainAngleDegree(angle1) - Geometry.constrainAngleDegree(angle2)) < tolerance;
    }

    public static double constrainAngleDegree(double angle) {
        if ((angle -= (double)((int)(angle / 360.0) * 360)) < -180.0) {
            angle += 360.0;
        } else if (angle > 180.0) {
            angle -= 360.0;
        }
        return angle;
    }

    public static boolean isSameAngleRadian(double angle1, double angle2, double tolerance) {
        return Math.abs(Geometry.constrainAngleRadian(angle1) - Geometry.constrainAngleRadian(angle2)) < tolerance;
    }

    public static double constrainAngleRadian(double angle) {
        if ((angle -= (double)((int)(angle / (Math.PI * 2))) * (Math.PI * 2)) < -1.5707963267948966) {
            angle += Math.PI * 2;
        } else if (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public static Insets expand(Insets ins, int exp) {
        return ins.add(new Insets(exp, exp, exp, exp));
    }

    public static Insets expand(Insets ins, int width, int height) {
        return ins.add(new Insets(height, width, height, width));
    }

    public static Insets getExpanded(Insets ins, int exp) {
        return Geometry.expand(new Insets(ins), exp);
    }

    public static Insets getExpanded(Insets ins, int width, int height) {
        return Geometry.expand(new Insets(ins), width, height);
    }

    public static Insets union(Insets ins, Insets other) {
        if (other == null) {
            return ins;
        }
        return Geometry.union(ins, other.top, other.left, other.bottom, other.right);
    }

    public static Insets union(Insets ins, int top, int left, int bottom, int right) {
        if (ins == null) {
            return new Insets(top, left, bottom, right);
        }
        ins.top = Math.max(ins.top, top);
        ins.left = Math.max(ins.left, left);
        ins.bottom = Math.max(ins.bottom, bottom);
        ins.right = Math.max(ins.right, right);
        return ins;
    }

    public static Insets add(Insets ins, Insets other) {
        if (other == null) {
            return ins;
        }
        if (ins == null) {
            return new Insets(other);
        }
        return ins.add(other);
    }

    public static Insets add(Insets ins, int margin) {
        return Geometry.add(ins, margin, margin, margin, margin);
    }

    public static Insets add(Insets ins, int top, int left, int bottom, int right) {
        if (ins == null) {
            return new Insets(top, left, bottom, right);
        }
        ins.top += top;
        ins.left += left;
        ins.bottom += bottom;
        ins.right += right;
        return ins;
    }

    public static Insets getUnioned(Insets ins, Insets other) {
        if (other == null) {
            return ins == null ? null : new Insets(ins);
        }
        if (ins == null) {
            return new Insets(other);
        }
        return Geometry.union(new Insets(ins), other);
    }

    public static Insets remove(Insets from, Insets toRemove) {
        from.top = Math.max(0, from.top - toRemove.top);
        from.bottom = Math.max(0, from.bottom - toRemove.bottom);
        from.left = Math.max(0, from.left - toRemove.left);
        from.right = Math.max(0, from.right - toRemove.right);
        return from;
    }

    public static Insets getRemoved(Insets from, Insets toRemove) {
        return Geometry.remove(new Insets(from), toRemove);
    }

    public static Insets scale(Insets ins, double scale) {
        ins.top = (int)Math.floor((double)ins.top * scale);
        ins.left = (int)Math.floor((double)ins.left * scale);
        ins.bottom = (int)Math.floor((double)ins.bottom * scale);
        ins.right = (int)Math.floor((double)ins.right * scale);
        return ins;
    }

    public static Insets getScaled(Insets ins, double scale) {
        return Geometry.scale(new Insets(ins), scale);
    }

    public static Rectangle shrink(Rectangle r, Insets i) {
        r.x += i.left;
        r.y += i.top;
        r.width -= i.getWidth();
        r.height -= i.getHeight();
        return r;
    }

    public static Rectangle getShrinked(Rectangle r, Insets i) {
        return Geometry.shrink(r.getCopy(), i);
    }

    public static Insets getCropped(Rectangle box, Rectangle clip) {
        Insets ins = new Insets();
        ins.top = clip.y - box.y;
        ins.left = clip.x - box.x;
        ins.bottom = box.bottom() - clip.bottom();
        ins.right = box.right() - clip.right();
        return ins;
    }

    public static Insets getInsets(Point p, Rectangle box) {
        return new Insets(p.y - box.y, p.x - box.x, box.bottom() - p.y, box.right() - p.x);
    }

    public static Rectangle getExpanded(Point p, Insets ins) {
        return Geometry.getExpanded(p.x, p.y, ins);
    }

    public static Rectangle getExpanded(int x, int y, Insets ins) {
        return new Rectangle(x - ins.left, y - ins.top, ins.getWidth(), ins.getHeight());
    }

    public static Rectangle getBounds(Rectangle box, boolean outline, int lineWidth, int expansion) {
        if (outline) {
            box = box.getResized(-lineWidth, -lineWidth);
        }
        if (expansion != 0) {
            box = box.getExpanded(expansion, expansion);
        }
        return box;
    }

    public static Point getLocation(int orientation, Rectangle box, boolean outline, int lineWidth, int expansion) {
        box = Geometry.getBounds(box, outline, lineWidth, expansion);
        switch (orientation) {
            case 16: {
                return box.getRight();
            }
            case 8: {
                return box.getLeft();
            }
            case 4: {
                return box.getBottom();
            }
            case 1: {
                return box.getTop();
            }
            case 17: {
                return box.getTopRight();
            }
            case 9: {
                return box.getTopLeft();
            }
            case 20: {
                return box.getBottomRight();
            }
            case 12: {
                return box.getBottomLeft();
            }
        }
        return box.getCenter();
    }

    public static Dimension getScaledConstrainedSize(Dimension originSize, Dimension constrainedSize) {
        return Geometry.getScaledConstrainedSize(originSize.width, originSize.height, constrainedSize.width, constrainedSize.height);
    }

    public static Dimension getScaledConstrainedSize(int w, int h, int maxWidth, int maxHeight) {
        if (w == 0 || h == 0) {
            return new Dimension();
        }
        if (maxWidth < 0 && maxHeight < 0) {
            return new Dimension(w, h);
        }
        if (w <= maxWidth && h <= maxHeight) {
            return new Dimension(w, h);
        }
        int nw = w * maxHeight / h;
        int nh = h * maxWidth / w;
        if (maxWidth < 0) {
            return new Dimension(nw, maxHeight);
        }
        if (maxHeight < 0) {
            return new Dimension(maxWidth, nh);
        }
        if (nw < maxWidth) {
            maxWidth = nw;
        }
        if (nh < maxHeight) {
            maxHeight = nh;
        }
        return new Dimension(Math.max(1, maxWidth), Math.max(1, maxHeight));
    }

    public static Point getPopupLocation(Dimension size, Rectangle host, Rectangle display) {
        Point p = host.getBottomLeft();
        if (p.y + size.height > display.bottom()) {
            p.y = host.y - size.height;
            if (p.y < 0) {
                p.y = display.y - size.height;
            }
        }
        if (p.y < display.y) {
            p.y = display.y;
        }
        if (p.x + size.width > display.right()) {
            p.x = display.right() - size.width;
        }
        if (p.x < display.x) {
            p.x = display.x;
        }
        return p;
    }

    public static int getOrientation(Point p) {
        return Geometry.getOrientation(p.x, p.y, 0, 0);
    }

    public static int getOrientation(Point p, Point origin) {
        if (p == null) {
            return 0;
        }
        return Geometry.getOrientation(p.x, p.y, origin.x, origin.y);
    }

    public static int getOrientation(int x1, int y1, int x2, int y2) {
        if (x1 == x2 && y1 < y2) {
            return 1;
        }
        if (x1 > x2 && y1 < y2) {
            return 17;
        }
        if (x1 > x2 && y1 == y2) {
            return 16;
        }
        if (x1 > x2 && y1 > y2) {
            return 20;
        }
        if (x1 == x2 && y1 > y2) {
            return 4;
        }
        if (x1 < x2 && y1 > y2) {
            return 12;
        }
        if (x1 < x2 && y1 == y2) {
            return 8;
        }
        if (x1 < x2 && y1 < y2) {
            return 9;
        }
        return 0;
    }

    public static int getOppositePosition(int position) {
        if (position == 16) {
            return 8;
        }
        if (position == 8) {
            return 16;
        }
        if (position == 4) {
            return 1;
        }
        if (position == 1) {
            return 4;
        }
        if (position == 17) {
            return 12;
        }
        if (position == 9) {
            return 20;
        }
        if (position == 20) {
            return 9;
        }
        if (position == 12) {
            return 17;
        }
        if (position == 5) {
            return 24;
        }
        if (position == 24) {
            return 5;
        }
        return position;
    }

    public static Point getPositionWithin(int alignment, Rectangle boundingBox, Dimension toPlace) {
        int x = (alignment & 1) != 0 ? boundingBox.x : ((alignment & 4) != 0 ? boundingBox.right() - toPlace.width : boundingBox.x + (boundingBox.width - toPlace.width) / 2);
        int y = (alignment & 8) != 0 ? boundingBox.y : ((alignment & 0x20) != 0 ? boundingBox.bottom() - toPlace.height : boundingBox.y + (boundingBox.height - toPlace.height) / 2);
        return new Point(x, y);
    }

    public static Point getRotatedPoint(Point p, double angle) {
        double distance = p.getDistance(new Point());
        return Geometry.getPoint(angle += Geometry.getAngle(p), distance);
    }

    public static PointList getRotatedRectangle(Rectangle r, double theta) {
        PointList pl = new PointList(4);
        pl.addPoint(Geometry.getRotatedPoint(r.getTopLeft(), theta));
        pl.addPoint(Geometry.getRotatedPoint(r.getTopRight(), theta));
        pl.addPoint(Geometry.getRotatedPoint(r.getBottomLeft(), theta));
        pl.addPoint(Geometry.getRotatedPoint(r.getBottomRight(), theta));
        return pl;
    }

    public static Dimension getConstrainedSize(Dimension size, Dimension minSize, Dimension maxSize) {
        return new Dimension(Geometry.constrain(size.width, minSize.width, maxSize.width), Geometry.constrain(size.height, minSize.height, maxSize.height));
    }

    public static int constrain(int i, int min, int max) {
        return Math.max(Math.min(i, max), min);
    }

    public static double constrain(double d, double min, double max) {
        return Math.max(Math.min(d, max), min);
    }

    public static Dimension getScaledConstrainedSize2(Dimension size, Dimension origin, Dimension minSize, Dimension maxSize) {
        return Geometry.getScaledConstrainedSize2(size.width, size.height, Geometry.slope(origin), minSize.width, minSize.height, maxSize.width, maxSize.height);
    }

    public static Dimension getScaledConstrainedSize2(double width, double height, Dimension origin, Dimension minSize, Dimension maxSize) {
        return Geometry.getScaledConstrainedSize2(width, height, Geometry.slope(origin), minSize.width, minSize.height, maxSize.width, maxSize.height);
    }

    public static Dimension getScaledConstrainedSize2(double width, double height, double originWidth, double originHeight, double minWidth, double minHeight, double maxWidth, double maxHeight) {
        return Geometry.getScaledConstrainedSize2(width, height, Geometry.slope(originWidth, originHeight), minWidth, minHeight, maxWidth, maxHeight);
    }

    public static Dimension getScaledConstrainedSize2(double width, double height, double slope, double minWidth, double minHeight, double maxWidth, double maxHeight) {
        double prefH = Geometry.constrain(width * slope, minHeight, maxHeight);
        if (height < prefH) {
            if (height >= 0.0) {
                height = prefH;
            } else {
                width = Geometry.constrain(width, minWidth, maxWidth);
            }
        } else if (height >= 0.0) {
            width = Geometry.constrain(height / slope, minWidth, maxWidth);
        }
        height = Geometry.constrain(width * slope, minHeight, maxHeight);
        width = Geometry.constrain(height / slope, minWidth, maxWidth);
        return new Dimension((int)Math.floor(width), (int)Math.floor(height));
    }

    public static double slope(Dimension size) {
        return Geometry.slope(size.width, size.height);
    }

    public static double slope(double width, double height) {
        return height / width;
    }

    public static List<PrecisionLine> getLineSegments(List<PrecisionPoint> points) {
        if (points.size() <= 1) {
            return new ArrayList<PrecisionLine>(0);
        }
        ArrayList<PrecisionLine> lines = new ArrayList<PrecisionLine>(points.size() - 1);
        int i = 0;
        while (i < points.size() - 1) {
            lines.add(new PrecisionLine(points.get(i), points.get(i + 1), PrecisionLine.LineType.LineSegment));
            ++i;
        }
        return lines;
    }

    public static List<PrecisionLine> getLineSegments(PrecisionPoint ... points) {
        return Geometry.getLineSegments(Arrays.asList(points));
    }

    public static List<PrecisionLine> getLineSegments(PrecisionPoint origin, List<PrecisionPoint> points) {
        if (points.size() <= 1) {
            return new ArrayList<PrecisionLine>(0);
        }
        ArrayList<PrecisionLine> lines = new ArrayList<PrecisionLine>(points.size() - 1);
        int i = 0;
        while (i < points.size() - 1) {
            lines.add(new PrecisionLine(new PrecisionPoint(origin).translate(points.get(i)), new PrecisionPoint(origin).translate(points.get(i + 1)), PrecisionLine.LineType.LineSegment));
            ++i;
        }
        return lines;
    }

    public static PrecisionPoint getRayXLine(PrecisionLine ray, PrecisionLine line, int tolerance) {
        List<PrecisionPoint> intersections = ray.getLinesIntersections(line);
        int i = 0;
        while (i < intersections.size()) {
            PrecisionPoint p = intersections.get(i);
            if (Geometry.rayContainsPoint(ray, p, tolerance)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public static PrecisionPoint getRayXLineSeg(PrecisionLine ray, PrecisionLine lineSeg, int tolerance) {
        List<PrecisionPoint> intersections = ray.getLinesIntersections(lineSeg);
        int i = 0;
        while (i < intersections.size()) {
            PrecisionPoint p = intersections.get(i);
            if (lineSeg.contains(p, tolerance) && Geometry.rayContainsPoint(ray, p, tolerance)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public static PrecisionPoint getRayXRect(PrecisionLine ray, PrecisionRectangle r, int tolerance) {
        List<PrecisionLine> lines = Geometry.getLineSegments(r.getTopLeft(), r.getTopRight(), r.getBottomRight(), r.getBottomLeft(), r.getTopLeft());
        for (PrecisionLine line : lines) {
            PrecisionPoint p = Geometry.getRayXLineSeg(ray, line, tolerance);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static PrecisionPoint getRayXRectFarther(PrecisionLine ray, PrecisionRectangle r, int tolerance) {
        PrecisionPoint ret = null;
        double dist = -1.0;
        List<PrecisionLine> lines = Geometry.getLineSegments(r.getTopLeft(), r.getTopRight(), r.getBottomRight(), r.getBottomLeft(), r.getTopLeft());
        for (PrecisionLine line : lines) {
            PrecisionPoint p = Geometry.getRayXLineSeg(ray, line, tolerance);
            if (p == null) continue;
            if (ret == null) {
                ret = p;
                dist = ret.getDistance(ray.getOrigin());
                continue;
            }
            double d = p.getDistance(ray.getOrigin());
            if (!(d > dist)) continue;
            ret = p;
            dist = d;
        }
        return ret;
    }

    public static boolean rayContainsPoint(PrecisionLine ray, PrecisionPoint p, int tolerance) {
        return ray.contains(p, tolerance) || new PrecisionLine(ray.getOrigin(), p).contains(ray.getTerminus(), tolerance);
    }

    public static Rectangle union(Rectangle r1, Rectangle r2) {
        if (r2 == null) {
            return r1;
        }
        if (r1 == null) {
            return r2.getCopy();
        }
        return r1.union(r2);
    }

    public static PrecisionRectangle union(PrecisionRectangle r1, PrecisionRectangle r2) {
        if (r2 == null) {
            return r1;
        }
        if (r1 == null) {
            return r2.getCopy();
        }
        return r1.union(r2);
    }

    public static PrecisionPoint[] intersectQuadBezier(PrecisionLine line, double x1, double y1, double x2, double y2, double x3, double y3) {
        double c;
        double a;
        double u1 = x1 - 2.0 * x2 + x3;
        double v1 = y1 - 2.0 * y2 + y3;
        double u2 = 2.0 * x2 - 2.0 * x3;
        double v2 = 2.0 * y2 - 2.0 * y3;
        double u3 = x3;
        double v3 = y3;
        double[] eq = line.getEquation();
        double b = eq[0] * u2 + eq[1] * v2;
        double delta = b * b - 4.0 * (a = eq[0] * u1 + eq[1] * v1) * (c = eq[0] * u3 + eq[1] * v3 - eq[2]);
        if (Math.abs(delta) < 1.0E-9) {
            double y;
            double x;
            PrecisionPoint p;
            double t = -b / (2.0 * a);
            if (t >= 0.0 && t <= 1.0 && line.contains(p = new PrecisionPoint(x = u1 * t * t + u2 * t + u3, y = v1 * t * t + v2 * t + v3))) {
                return new PrecisionPoint[]{p};
            }
        } else if (delta > 0.0) {
            double y;
            double x;
            PrecisionPoint p;
            double t2;
            double y4;
            double x4;
            PrecisionPoint p2;
            double d = Math.sqrt(delta);
            ArrayList<PrecisionPoint> list = new ArrayList<PrecisionPoint>();
            double t1 = (-b + d) / (2.0 * a);
            if (t1 >= 0.0 && t1 <= 1.0 && line.contains(p2 = new PrecisionPoint(x4 = u1 * t1 * t1 + u2 * t1 + u3, y4 = v1 * t1 * t1 + v2 * t1 + v3))) {
                list.add(p2);
            }
            if ((t2 = (-b - d) / (2.0 * a)) >= 0.0 && t2 <= 1.0 && line.contains(p = new PrecisionPoint(x = u1 * t2 * t2 + u2 * t2 + u3, y = v1 * t2 * t2 + v2 * t2 + v3))) {
                list.add(p);
            }
            return list.toArray(new PrecisionPoint[0]);
        }
        return new PrecisionPoint[0];
    }

    public static PrecisionPoint getChopBoxLocation(double refX, double refY, Rectangle r, double expansion) {
        double scale;
        double d;
        double centerX = (double)r.x + 0.5 * (double)r.width;
        double centerY = (double)r.y + 0.5 * (double)r.height;
        double dx = refX - centerX;
        double dy = refY - centerY;
        if (dx == 0.0) {
            return new PrecisionPoint(refX, dy > 0.0 ? (double)r.bottom() + expansion : (double)r.y - expansion);
        }
        if (dy == 0.0) {
            return new PrecisionPoint(dx > 0.0 ? (double)r.right() + expansion : (double)r.x - expansion, refY);
        }
        if ((d = Math.hypot(dx *= (scale = 0.5 / Math.max(Math.abs(dx) / (double)r.width, Math.abs(dy) / (double)r.height)), dy *= scale)) != 0.0) {
            double s = expansion / d;
            dx += dx * s;
            dy += dy * s;
        }
        return new PrecisionPoint(centerX += dx, centerY += dy);
    }

    public static Point getChopBoxLocation(int x, int y, Rectangle box) {
        float centerX = (float)box.x + 0.5f * (float)box.width;
        float centerY = (float)box.y + 0.5f * (float)box.height;
        float dx = (float)x - centerX;
        float dy = (float)y - centerY;
        if (dx == 0.0f) {
            return new Point(x, dy > 0.0f ? box.bottom() : box.y);
        }
        if (dy == 0.0f) {
            return new Point(dx > 0.0f ? box.right() : box.x, y);
        }
        float scale = 0.5f / Math.max(Math.abs(dx) / (float)box.width, Math.abs(dy) / (float)box.height);
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }

    public static Point getChopBoxLocation(Point reference, Rectangle box) {
        return Geometry.getChopBoxLocation(reference.x, reference.y, box);
    }

    public static PrecisionPoint getChopOvalLocation(double refX, double refY, Rectangle r, double expansion) {
        double dy;
        double dx;
        double d;
        double cx = (double)r.x + (double)r.width * 0.5;
        double cy = (double)r.y + (double)r.height * 0.5;
        double rx = refX - cx;
        double ry = refY - cy;
        if (rx == 0.0) {
            return new PrecisionPoint(refX, ry > 0.0 ? (double)r.bottom() + expansion : (double)r.y - expansion);
        }
        if (ry == 0.0) {
            return new PrecisionPoint(rx > 0.0 ? (double)r.right() + expansion : (double)r.x - expansion, refY);
        }
        double scaleX = rx > 0.0 ? 0.5 : -0.5;
        double scaleY = ry > 0.0 ? 0.5 : -0.5;
        double k = ry * (double)r.width / (rx * (double)r.height);
        if ((d = Math.hypot(dx = (double)r.width * scaleX / Math.sqrt(1.0 + (k *= k)), dy = (double)r.height * scaleY / Math.sqrt(1.0 + 1.0 / k))) != 0.0) {
            double s = expansion / d;
            dx += dx * s;
            dy += dy * s;
        }
        return new PrecisionPoint(cx + dx, cy + dy);
    }

    public static Point getChopOvalLocation(int x, int y, Rectangle r) {
        Point ref = r.getCenter().negate().translate(x, y);
        if (ref.x == 0) {
            return new Point(x, ref.y > 0 ? r.bottom() : r.y);
        }
        if (ref.y == 0) {
            return new Point(ref.x > 0 ? r.right() : r.x, y);
        }
        float dx = ref.x > 0 ? 0.5f : -0.5f;
        float dy = ref.y > 0 ? 0.5f : -0.5f;
        float k = (float)(ref.y * r.width) / (float)(ref.x * r.height);
        k *= k;
        return r.getCenter().translate((int)((double)((float)r.width * dx) / Math.sqrt(1.0f + k)), (int)((double)((float)r.height * dy) / Math.sqrt(1.0f + 1.0f / k)));
    }

    public static Point getChopOvalLocation(Point reference, Rectangle r) {
        return Geometry.getChopOvalLocation(reference.x, reference.y, r);
    }

    public static PrecisionPointPair calculatePositionPair(PrecisionPoint from, PrecisionPoint to, double w) {
        PrecisionPointPair result = new PrecisionPointPair(from.getCopy(), from.getCopy());
        if (from.equals(to)) {
            return result;
        }
        PrecisionDimension d = from.getDifference(to);
        double wScale = d.width == 0.0 ? 1.0 : Math.abs(w / d.width);
        double hScale = d.height == 0.0 ? 1.0 : Math.abs(w / d.height);
        d.scale(wScale, hScale);
        result.translate(d);
        d.width = -d.width;
        result.translateFirstPoint(d.transpose());
        result.translateSecondPoint(d.negate());
        return result;
    }

    public static double getDistance(PrecisionPoint p, PrecisionLine line) {
        PrecisionPoint p1 = line.getOrigin();
        PrecisionPoint p2 = line.getTerminus();
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        if (dx == 0.0 && dy == 0.0) {
            return 0.0;
        }
        if (dy == 0.0) {
            return Math.abs(p.y - p1.y);
        }
        if (dx == 0.0) {
            return Math.abs(p.x - p1.x);
        }
        double k = dx / dy;
        double m = dy / dx;
        double y = (p1.y * k - p1.x + p.y * m + p.x) / (k + m);
        double x = (y - p1.y) * k + p1.x;
        return Math.hypot(p.x - x, p.y - y);
    }
}

