/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.xmind.gef.draw2d.IHasImage;
import org.xmind.gef.draw2d.ReferencedFigure;

public class SizeableImageFigure
extends ReferencedFigure
implements IHasImage {
    private static final Rectangle IMAGE_CLIENT_AREA = new Rectangle();
    private static final int FLAG_STRETCHED = MAX_FLAG << 1;
    private static final int FLAG_CONSTRAINED;
    private Image img = null;
    private Dimension imgSize = null;
    private int alpha = -1;

    static {
        MAX_FLAG = FLAG_CONSTRAINED = MAX_FLAG << 2;
    }

    public SizeableImageFigure() {
        this(null);
    }

    public SizeableImageFigure(Image image) {
        this.setImage(image);
    }

    public void setImage(Image image) {
        if (this.img == image) {
            return;
        }
        this.img = image;
        this.imgSize = null;
        this.setMinimumSize(new Dimension(1, 1));
        this.revalidate();
        this.repaint();
    }

    public Dimension getImageSize() {
        if (this.imgSize == null) {
            this.imgSize = this.img != null ? new Dimension(this.img) : new Dimension();
        }
        return this.imgSize;
    }

    public boolean isConstrained() {
        return this.getFlag(FLAG_CONSTRAINED);
    }

    public void setConstrained(boolean constrained) {
        if (constrained == this.isConstrained()) {
            return;
        }
        this.setFlag(FLAG_CONSTRAINED, constrained);
        this.repaint();
    }

    public boolean isStretched() {
        return this.getFlag(FLAG_STRETCHED);
    }

    public void setStretched(boolean stretched) {
        if (stretched == this.isStretched()) {
            return;
        }
        this.setFlag(FLAG_STRETCHED, stretched);
        this.repaint();
    }

    public Image getImage() {
        return this.img;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        if (this.alpha == alpha) {
            return;
        }
        this.alpha = alpha;
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        Image image = this.getImage();
        if (image != null) {
            graphics.setAntialias(1);
            if (this.getAlpha() != -1) {
                graphics.setAlpha(this.getAlpha());
            }
            this.paintImage(graphics, image);
        }
    }

    protected void paintImage(Graphics graphics, Image image) {
        if (image != null) {
            Dimension imageSize = image == this.img ? this.getImageSize() : new Dimension(image);
            this.paintImage(graphics, image, imageSize, this.getImageClientArea(imageSize));
        }
    }

    protected Rectangle getImageClientArea(Dimension imageSize) {
        Rectangle area = this.getClientArea(IMAGE_CLIENT_AREA);
        boolean constrained = this.isConstrained();
        boolean stretched = this.isStretched();
        if (constrained && (stretched || imageSize.width > area.width || imageSize.height > area.height)) {
            this.adaptAreaToRatio(area, imageSize);
        } else if (!stretched) {
            this.adaptAreaToSize(area, imageSize);
        }
        return area;
    }

    protected void adaptAreaToSize(Rectangle area, Dimension size) {
        area.x += (area.width - size.width) / 2;
        area.width = size.width;
        area.y += (area.height - size.height) / 2;
        area.height = size.height;
    }

    protected void adaptAreaToRatio(Rectangle area, Dimension ratio) {
        int a = ratio.width * area.height;
        int b = ratio.height * area.width;
        if (a > b) {
            int h = area.width == 0 ? 0 : b / ratio.width;
            area.y += (area.height - h) / 2;
            area.height = h;
        } else if (a < b) {
            int w = area.height == 0 ? 0 : a / ratio.height;
            area.x += (area.width - w) / 2;
            area.width = w;
        }
    }

    protected void paintImage(Graphics graphics, Image image, Dimension imageSize, Rectangle clientArea) {
        if (clientArea.width == imageSize.width && clientArea.height == imageSize.height) {
            graphics.drawImage(image, clientArea.x, clientArea.y);
        } else {
            graphics.drawImage(image, 0, 0, imageSize.width, imageSize.height, clientArea.x, clientArea.y, clientArea.width, clientArea.height);
        }
    }
}

