/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.xmind.gef.draw2d.IRotatableFigure;
import org.xmind.gef.draw2d.SizeableImageFigure;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;

public class RotatableSizeableImageFigure
extends SizeableImageFigure
implements IRotatableFigure {
    private PrecisionRotator rotator = new PrecisionRotator();
    private PrecisionDimension normalPrefSize = null;
    private Dimension rotatedPrefSize = null;

    public RotatableSizeableImageFigure() {
    }

    public RotatableSizeableImageFigure(Image image) {
        super(image);
    }

    public PrecisionDimension getNormalPreferredSize(int wHint, int hHint) {
        if (this.normalPrefSize == null) {
            this.normalPrefSize = new PrecisionDimension(super.getPreferredSize(wHint, hHint));
        }
        return this.normalPrefSize;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.rotatedPrefSize == null) {
            this.rotatedPrefSize = this.rotator.td(this.getNormalPreferredSize(wHint, hHint)).toDraw2DDimension();
        }
        return this.rotatedPrefSize;
    }

    public void invalidate() {
        super.invalidate();
        this.normalPrefSize = null;
        this.rotatedPrefSize = null;
    }

    public double getRotationDegrees() {
        return this.rotator.getAngle();
    }

    public void setRotationDegrees(double angle) {
        double oldAngle = this.getRotationDegrees();
        if (Math.abs(oldAngle - angle) < 1.0E-8) {
            return;
        }
        this.rotator.setAngle(angle);
        this.revalidate();
        this.repaint();
    }

    private boolean isRotated() {
        return !Geometry.isSameAngleDegree(this.getRotationDegrees(), 0.0, 1.0E-7);
    }

    protected void paintImage(Graphics graphics, Image image, Dimension imageSize, Rectangle clientArea) {
        if (!this.isRotated()) {
            super.paintImage(graphics, image, imageSize, clientArea);
            return;
        }
        Point center = clientArea.getCenter();
        this.rotator.setOrigin(center.x, center.y);
        PrecisionRectangle r = this.rotator.r(new PrecisionRectangle(clientArea), (double)imageSize.width, -1.0);
        graphics.pushState();
        try {
            graphics.translate(center.x, center.y);
            graphics.rotate((float)this.getRotationDegrees());
            super.paintImage(graphics, image, imageSize, r.toDraw2DRectangle());
            graphics.translate(-center.x, -center.y);
        }
        finally {
            graphics.popState();
            graphics.restoreState();
        }
    }
}

