/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;

public class PathFigure
extends Shape {
    private static final float[] _bounds = new float[4];
    private Path path = null;
    private boolean outline = true;
    private boolean fill = true;
    private int tolerance = 0;

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        if (this.path == path || this.path != null && this.path.equals(path)) {
            return;
        }
        this.path = path;
        this.revalidate();
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    protected void fillShape(Graphics graphics) {
        if (this.path != null) {
            graphics.fillPath(this.path);
        }
    }

    protected void outlineShape(Graphics graphics) {
        if (this.path != null) {
            graphics.drawPath(this.path);
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.path != null) {
            this.path.getBounds(_bounds);
            PrecisionDimension pSize = new PrecisionDimension(_bounds[2], _bounds[3]);
            double halfLine = (double)this.getLineWidth() * 0.5 + 1.0;
            pSize.expand(halfLine, halfLine);
            return pSize.toDraw2DDimension();
        }
        return super.getPreferredSize(wHint, hHint);
    }

    public Rectangle getPreferredBounds() {
        if (this.path == null) {
            return new Rectangle();
        }
        this.path.getBounds(_bounds);
        PrecisionRectangle pRect = new PrecisionRectangle(_bounds[0], _bounds[1], _bounds[2], _bounds[3]);
        double halfLine = (double)this.getLineWidth() * 0.5;
        pRect.expand(halfLine, halfLine).resize(1.0, 1.0);
        return pRect.toDraw2DRectangle();
    }

    public boolean containsPoint(int x, int y) {
        if (!super.containsPoint(x, y) || this.path == null || !this.hasOutline() && !this.hasFill()) {
            return false;
        }
        GC gc = new GC((Drawable)Display.getCurrent());
        gc.setLineWidth(this.getLineWidth() + this.tolerance);
        gc.setLineStyle(this.getLineStyle());
        boolean b = this.path.contains((float)x, (float)y, gc, !this.hasFill());
        gc.dispose();
        return b;
    }

    public void setOutline(boolean b) {
        super.setOutline(b);
        this.outline = b;
    }

    public void setFill(boolean b) {
        super.setFill(b);
        this.fill = b;
    }

    public boolean hasOutline() {
        return this.outline;
    }

    public boolean hasFill() {
        return this.fill;
    }
}

