/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef;

import java.util.List;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.xmind.gef.AbstractViewer;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ILayerManager;
import org.xmind.gef.ISelectionSupport;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.dnd.IDndSupport;
import org.xmind.gef.event.PartsEventDispatcher;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IGraphicalRootPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.tool.SelectTool;

public class GraphicalViewer
extends AbstractViewer
implements IGraphicalViewer {
    private static final Point POINT = new Point();
    private ILayerManager layerManager = null;
    private Point centerPoint = new Point();
    private Display display = null;
    private UserMotionDetector userMotionDetector = null;
    private PartsEventDispatcher eventDispatcher = null;
    private ZoomManager zoomManager = null;

    public Object getAdapter(Class adapter) {
        if (adapter == ILayerManager.class) {
            return this.getLayerManager();
        }
        if (adapter == FigureCanvas.class) {
            return this.getCanvas();
        }
        if (adapter == ZoomManager.class) {
            return this.getZoomManager();
        }
        if (adapter == IGraphicalPart.class) {
            return this.getRootPart() instanceof IGraphicalPart ? (IGraphicalPart)((Object)this.getRootPart()) : null;
        }
        if (adapter == IFigure.class) {
            return this.getRootFigure();
        }
        return super.getAdapter(adapter);
    }

    public IGraphicalPart findGraphicalPart(Object model) {
        IPart part = this.findPart(model);
        if (part instanceof IGraphicalPart) {
            return (IGraphicalPart)part;
        }
        return null;
    }

    public IPart findPart(int x, int y) {
        Point p = this.convertPoint(x, y);
        return this.findPart(p);
    }

    protected Point convertPoint(int controlX, int controlY) {
        Point p = new Point(controlX, controlY);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            p = this.computeToLayer(p, true);
        }
        return p;
    }

    protected IPart findPart(Point position) {
        return this.findPart(this.getRootPart(), position);
    }

    protected IPart findPart(IPart parent, Point position) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)parent).findAt(position);
        }
        for (IPart p : parent.getChildren()) {
            IPart ret = this.findPart(p, position);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public Control createControl(Composite parent) {
        return this.createControl(parent, 0x20000000);
    }

    protected Control internalCreateControl(Composite parent, int style) {
        IFigure rootFigure;
        FigureCanvas fc = new FigureCanvas(parent, style);
        this.eventDispatcher = this.createEventDispatcher();
        this.eventDispatcher.setDndSupport(this.getDndSupport());
        fc.getLightweightSystem().setEventDispatcher((EventDispatcher)this.eventDispatcher);
        if (this.getEditDomain() != null) {
            this.eventDispatcher.activate();
        }
        if ((rootFigure = this.getRootFigure()) instanceof Viewport) {
            fc.setViewport((Viewport)rootFigure);
        } else {
            fc.setContents(rootFigure);
        }
        return fc;
    }

    protected void hookControl(Control control) {
        ScrollBar vBar;
        super.hookControl(control);
        ControlEventListener eventHandler = new ControlEventListener();
        control.addListener(11, (Listener)eventHandler);
        control.addListener(15, (Listener)eventHandler);
        control.addListener(16, (Listener)eventHandler);
        control.addListener(9, (Listener)eventHandler);
        ScrollBar hBar = ((FigureCanvas)control).getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, (Listener)eventHandler);
        }
        if ((vBar = ((FigureCanvas)control).getVerticalBar()) != null) {
            vBar.addListener(13, (Listener)eventHandler);
        }
        this.display = control.getDisplay();
        if (this.display != null) {
            this.userMotionDetector = new UserMotionDetector();
            this.display.addFilter(3, (Listener)this.userMotionDetector);
            this.display.addFilter(4, (Listener)this.userMotionDetector);
            this.display.addFilter(1, (Listener)this.userMotionDetector);
            this.display.addFilter(2, (Listener)this.userMotionDetector);
        }
    }

    public void setRootPart(IRootPart rootPart) {
        if (this.getCanvas() != null && !this.getCanvas().isDisposed()) {
            IFigure oldRootFigure = this.getRootFigure();
            if (oldRootFigure instanceof Viewport) {
                this.getCanvas().setViewport(null);
            } else {
                this.getCanvas().setContents(null);
            }
        }
        super.setRootPart(rootPart);
        if (this.getCanvas() != null && !this.getCanvas().isDisposed()) {
            IFigure newRootFigure = this.getRootFigure();
            if (newRootFigure instanceof Viewport) {
                this.getCanvas().setViewport((Viewport)newRootFigure);
            } else {
                this.getCanvas().setContents(newRootFigure);
            }
        }
    }

    protected IFigure getRootFigure() {
        if (this.getRootPart() instanceof IGraphicalPart) {
            return ((IGraphicalPart)((Object)this.getRootPart())).getFigure();
        }
        return null;
    }

    protected void revalidateContents() {
        IPart contents = this.getRootPart().getContents();
        if (contents != null && contents instanceof IGraphicalPart && contents.getStatus().isActive()) {
            ((IGraphicalPart)contents).getFigure().revalidate();
        }
        this.getCanvas().layout(true);
    }

    protected PartsEventDispatcher createEventDispatcher() {
        return new PartsEventDispatcher(this);
    }

    public PartsEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void setEditDomain(EditDomain domain) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.deactivate();
        }
        super.setEditDomain(domain);
        if (this.getEditDomain() != null && this.eventDispatcher != null) {
            this.eventDispatcher.activate();
        }
    }

    public Layer getLayer(Object key) {
        return this.layerManager == null ? null : this.layerManager.getLayer(key);
    }

    public ILayerManager getLayerManager() {
        return this.layerManager;
    }

    public void setLayerManager(ILayerManager layerManager) {
        this.layerManager = layerManager;
    }

    public void updateToolTip() {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.updateToolTip();
        }
    }

    public void hideToolTip() {
        if (this.getControl() != null) {
            this.getControl().setToolTipText(null);
        }
    }

    public FigureCanvas getCanvas() {
        return (FigureCanvas)super.getControl();
    }

    public Dimension getSize() {
        return new Dimension(this.getCanvas().getSize());
    }

    public Rectangle getClientArea() {
        Rectangle area = new Rectangle(this.getCanvas().getClientArea());
        area.setLocation(this.getScrollPosition());
        return area;
    }

    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public void center(Rectangle area) {
        this.center(area.getCenter());
    }

    public void center(Point center) {
        if (center != null && !center.equals((Object)this.centerPoint)) {
            this.centerPoint.setLocation(center);
        }
        this.performCenterJob();
    }

    private void performCenterJob() {
        if (!this.getCanvas().isDisposed()) {
            org.eclipse.swt.graphics.Rectangle clientArea = this.getCanvas().getClientArea();
            int x = this.centerPoint.x - clientArea.width / 2;
            int y = this.centerPoint.y - clientArea.height / 2;
            if (this.usesSmoothScroll()) {
                this.getCanvas().getViewport().setViewLocation(x, y);
            } else {
                this.getCanvas().scrollTo(x, y);
            }
        }
    }

    public void scrollToX(int x) {
        if (this.usesSmoothScroll()) {
            this.getCanvas().getViewport().setHorizontalLocation(x);
        } else {
            this.getCanvas().scrollToX(x);
        }
        this.updateCenterPoint();
    }

    public void scrollToY(int y) {
        if (this.usesSmoothScroll()) {
            this.getCanvas().getViewport().setVerticalLocation(y);
        } else {
            this.getCanvas().scrollToY(y);
        }
        this.updateCenterPoint();
    }

    public void scrollTo(Point p) {
        this.scrollTo(p.x, p.y);
    }

    public void scrollTo(int x, int y) {
        if (this.usesSmoothScroll()) {
            this.getCanvas().getViewport().setViewLocation(x, y);
        } else {
            this.getCanvas().scrollTo(x, y);
        }
        this.updateCenterPoint();
    }

    protected boolean usesSmoothScroll() {
        return Boolean.TRUE.equals(this.getProperties().get("scrollSmooth"));
    }

    public void scrollDelta(Dimension d) {
        this.scrollTo(this.getScrollPosition().translate(d));
    }

    public void scrollDelta(int dx, int dy) {
        this.scrollTo(this.getScrollPosition().translate(dx, dy));
    }

    public Point getScrollPosition() {
        return this.getCanvas().getViewport().getViewLocation();
    }

    protected void updateCenterPoint() {
        Point p = this.getScrollPosition();
        Dimension s = this.getClientArea().getSize();
        this.centerPoint.setLocation(p.x + s.width / 2, p.y + s.height / 2);
    }

    public Point computeToLayer(Point controlPoint, boolean zoomed) {
        Point p = this.getScrollPosition();
        p.translate(controlPoint);
        if (zoomed) {
            return p.scale(1.0 / this.getZoomManager().getScale());
        }
        return p;
    }

    public Point computeToControl(Point layerPoint, boolean zoomed) {
        POINT.setLocation(layerPoint);
        if (zoomed) {
            POINT.scale(this.getZoomManager().getScale());
        }
        return this.getScrollPosition().negate().translate(POINT);
    }

    public Point computeToDisplay(Point layerPoint, boolean zoomed) {
        Point p = this.computeToControl(layerPoint, zoomed);
        org.eclipse.swt.graphics.Point loc = this.getControl().toDisplay(p.x, p.y);
        return p.setLocation(loc.x, loc.y);
    }

    public void ensureVisible(Rectangle box) {
        box = this.getZoomManager().getScaled(box);
        Rectangle clientArea = this.getClientArea();
        if (clientArea.contains(box) || box.contains(clientArea)) {
            return;
        }
        this.ensureVisible(box, clientArea, 0);
    }

    public void ensureControlVisible(Rectangle box) {
        Rectangle clientArea = new Rectangle(this.getCanvas().getClientArea());
        if (clientArea.contains(box) || box.contains(clientArea)) {
            return;
        }
        this.ensureVisible(box, clientArea, 0);
    }

    protected void ensureVisible(Rectangle box, Rectangle clientArea, int margin) {
        int dx = 0;
        int dy = 0;
        if (box.width > clientArea.width) {
            dx = box.getCenter().x - clientArea.getCenter().x;
        } else if (box.x < clientArea.x) {
            dx = box.x - clientArea.x - margin;
        } else if (box.right() > clientArea.right()) {
            dx = box.right() - clientArea.right() + margin;
        }
        if (box.height > clientArea.height) {
            dy = box.getCenter().y - clientArea.getCenter().y;
        } else if (box.y < clientArea.y) {
            dy = box.y - clientArea.y - margin;
        } else if (box.bottom() > clientArea.bottom()) {
            dy = box.bottom() - clientArea.bottom() + margin;
        }
        this.smoothScrollDelta(dx, dy);
    }

    protected void smoothScrollDelta(int dx, int dy) {
        this.scrollDelta(dx, dy);
    }

    protected void handleDispose(DisposeEvent e) {
        if (this.display != null) {
            if (this.userMotionDetector != null) {
                this.display.removeFilter(3, (Listener)this.userMotionDetector);
                this.display.removeFilter(4, (Listener)this.userMotionDetector);
                this.display.removeFilter(1, (Listener)this.userMotionDetector);
                this.display.removeFilter(2, (Listener)this.userMotionDetector);
                this.userMotionDetector = null;
            }
            this.display = null;
        }
        super.handleDispose(e);
    }

    protected IGraphicalRootPart getGraphicalRootEditPart() {
        IRootPart rootPart = this.getRootPart();
        if (rootPart instanceof IGraphicalRootPart) {
            return (IGraphicalRootPart)rootPart;
        }
        return null;
    }

    protected ISelectionSupport createSelectionSupport() {
        return new GraphicalSelectionSupport();
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setRedraw(false);
        }
        ISelection oldSelection = this.getSelection();
        this.setSelectionOnInputChanged((ISelection)StructuredSelection.EMPTY);
        double oldScale = this.getZoomManager().getScale();
        if (this.eventDispatcher != null) {
            this.eventDispatcher.deactivate();
        }
        this.internalInputChanged(input, oldInput);
        if (this.eventDispatcher != null) {
            this.eventDispatcher.activate();
        }
        this.setSelectionOnInputChanged(oldSelection);
        if (oldScale >= 0.0) {
            this.getZoomManager().setScale(oldScale);
        }
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setRedraw(true);
        }
    }

    protected void setSelectionOnInputChanged(ISelection selection) {
        this.setSelection(selection);
    }

    protected void internalInputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
    }

    protected void alternativeScrollTo(int x, int y) {
        org.eclipse.swt.graphics.Rectangle bounds;
        int hOffset = this.verifyScrollBarOffset(this.getCanvas().getViewport().getHorizontalRangeModel(), x);
        int vOffset = this.verifyScrollBarOffset(this.getCanvas().getViewport().getVerticalRangeModel(), y);
        int hOffsetOld = this.getCanvas().getViewport().getViewLocation().x;
        if (hOffset == hOffsetOld) {
            this.scrollToY(y);
            return;
        }
        int dx = -hOffset + hOffsetOld;
        int vOffsetOld = this.getCanvas().getViewport().getViewLocation().y;
        if (vOffset == vOffsetOld) {
            this.scrollToX(x);
            return;
        }
        int dy = -vOffset + vOffsetOld;
        Rectangle clientArea = this.getCanvas().getViewport().getBounds().getCropped(this.getCanvas().getViewport().getInsets());
        Rectangle blit = clientArea.getResized(-Math.abs(dx), -Math.abs(dy));
        Rectangle expose = clientArea.getCopy();
        Rectangle expose2 = clientArea.getCopy();
        Point dest = clientArea.getTopLeft();
        expose.width = Math.abs(dx);
        if (dx < 0) {
            blit.translate(-dx, 0);
            expose.x = dest.x + blit.width;
        } else {
            dest.x += dx;
        }
        expose2.height = Math.abs(dy);
        if (dy < 0) {
            blit.translate(0, -dy);
            expose2.y = dest.y + blit.height;
        } else {
            dest.y += dy;
        }
        Control[] children = this.getCanvas().getChildren();
        boolean[] manualMove = new boolean[children.length];
        int i = 0;
        while (i < children.length) {
            bounds = children[i].getBounds();
            manualMove[i] = blit.width <= 0 || blit.height < 0 || bounds.x > blit.x + blit.width || bounds.y > blit.y + blit.height || bounds.x + bounds.width < blit.x || bounds.y + bounds.height < blit.y;
            ++i;
        }
        this.getCanvas().scroll(dest.x, dest.y, blit.x, blit.y, blit.width, blit.height, true);
        i = 0;
        while (i < children.length) {
            bounds = children[i].getBounds();
            if (manualMove[i]) {
                children[i].setBounds(bounds.x + dx, bounds.y, bounds.width, bounds.height);
            }
            ++i;
        }
        this.getCanvas().getViewport().setIgnoreScroll(true);
        this.getCanvas().getViewport().setHorizontalLocation(hOffset);
        this.getCanvas().getViewport().setVerticalLocation(vOffset);
        this.getCanvas().getViewport().setIgnoreScroll(false);
        this.getCanvas().redraw(expose.x, expose.y, expose.width, expose.height, true);
        this.getCanvas().redraw(expose2.x, expose2.y, expose2.width, expose2.height, true);
    }

    private int verifyScrollBarOffset(RangeModel model, int value) {
        value = Math.max(model.getMinimum(), value);
        return Math.min(model.getMaximum() - model.getExtent(), value);
    }

    protected void onScrolling() {
        this.updateCenterPoint();
    }

    public ZoomManager getZoomManager() {
        if (this.zoomManager == null) {
            this.zoomManager = new ZoomManager();
        }
        return this.zoomManager;
    }

    public void setZoomManager(ZoomManager zoomManager) {
        this.zoomManager = zoomManager;
    }

    public void setDndSupport(IDndSupport dndSupport) {
        super.setDndSupport(dndSupport);
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setDndSupport(dndSupport);
        }
    }

    private final class ControlEventListener
    implements Listener {
        private ControlEventListener() {
        }

        public void handleEvent(Event event) {
            if (event.type == 11) {
                if (GraphicalViewer.this.userMotionDetector == null || GraphicalViewer.this.userMotionDetector.needsCenterWhenResizing()) {
                    GraphicalViewer.this.performCenterJob();
                } else {
                    event.display.asyncExec(new Runnable(){

                        public void run() {
                            GraphicalViewer.this.performCenterJob();
                        }
                    });
                }
                GraphicalViewer.this.revalidateContents();
            } else if (event.type == 13) {
                GraphicalViewer.this.onScrolling();
            } else if (event.type == 16) {
                GraphicalViewer.this.hideToolTip();
            } else if (event.type == 15 || event.type == 9) {
                FigureCanvas fc = GraphicalViewer.this.getCanvas();
                org.eclipse.swt.graphics.Rectangle clientArea = fc.getClientArea();
                if (clientArea.width > 0 || clientArea.height > 0) {
                    GraphicalViewer.this.performCenterJob();
                    fc.removeListener(event.type, (Listener)this);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class GraphicalSelectionSupport
    extends AbstractViewer.SelectionSupport {
        protected GraphicalSelectionSupport() {
        }

        @Override
        public boolean isSelectable(IPart p) {
            IFigure fig;
            boolean selectable = super.isSelectable(p);
            if (selectable && p instanceof IGraphicalPart && ((fig = ((IGraphicalPart)p).getFigure()) == null || !fig.isShowing())) {
                return false;
            }
            return selectable;
        }

        @Override
        protected void partSelectionChanged(List<? extends IPart> parts, boolean reveal) {
            super.partSelectionChanged(parts, reveal);
            if (GraphicalViewer.this.getEditDomain() != null) {
                IPart focused;
                ITool tool = GraphicalViewer.this.getEditDomain().getTool("select tool");
                if (tool != null && tool instanceof SelectTool) {
                    ((SelectTool)tool).resetSeqSelectStart();
                }
                if ((focused = this.findSelectablePart(GraphicalViewer.this.getFocused())) == null || !focused.getStatus().isActive() || !focused.getStatus().isSelected()) {
                    GraphicalViewer.this.setFocused(this.findSelectedPart(parts));
                }
            }
        }

        protected IPart findSelectedPart(List<? extends IPart> parts) {
            for (IPart iPart : parts) {
                if (!iPart.getStatus().isActive() || !iPart.getStatus().isSelected()) continue;
                return iPart;
            }
            return null;
        }
    }

    private final class UserMotionDetector
    implements Listener {
        boolean mousePressing = false;
        boolean keyPressing = false;
        boolean resizedDuringMousePress = false;
        boolean resizedDuringKeyPress = false;

        private UserMotionDetector() {
        }

        public void handleEvent(Event event) {
            if (event.type == 3) {
                this.mousePressing = true;
            } else if (event.type == 1) {
                this.keyPressing = true;
            } else if (event.type == 4) {
                this.mousePressing = false;
                if (this.resizedDuringMousePress) {
                    this.resizedDuringMousePress = false;
                    GraphicalViewer.this.performCenterJob();
                }
            } else if (event.type == 2) {
                this.keyPressing = false;
                if (this.resizedDuringKeyPress) {
                    this.resizedDuringKeyPress = false;
                    GraphicalViewer.this.performCenterJob();
                }
            }
        }

        public boolean needsCenterWhenResizing() {
            if (!this.mousePressing && !this.keyPressing) {
                return true;
            }
            if (this.mousePressing) {
                this.resizedDuringMousePress = true;
            }
            if (this.keyPressing) {
                this.resizedDuringKeyPress = true;
            }
            return false;
        }
    }
}

