/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmind.gef.Disposable;
import org.xmind.gef.IEditDomainListener;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.part.PartRoles;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.tool.ITool;

public class EditDomain
extends Disposable {
    private IViewer viewer = null;
    private ITool activeTool = null;
    private String defaultTool = "default tool";
    private Map<String, ITool> tools = null;
    private PartRoles partRoles = null;
    private Map<String, IEditPolicy> policies = null;
    private ICommandStack commandStack = null;
    private List<IEditDomainListener> listeners = null;

    public void dispose() {
        if (this.activeTool != null) {
            this.activeTool.deactivate(null);
            this.activeTool = null;
        }
        super.dispose();
    }

    public void installEditPolicy(String policyId, IEditPolicy policy) {
        if (this.policies == null) {
            this.policies = new HashMap<String, IEditPolicy>();
        }
        this.policies.put(policyId, policy);
    }

    public void uninstallEditPolicy(String policyId) {
        if (this.policies == null) {
            return;
        }
        this.policies.remove(policyId);
    }

    public IEditPolicy getEditPolicy(String role, String policyId) {
        IEditPolicy policy;
        if (this.policies != null && (policy = this.policies.get(policyId)) != null) {
            return policy;
        }
        return NullEditPolicy.getInstance();
    }

    public PartRoles getPartRoles() {
        if (this.partRoles == null) {
            this.partRoles = new PartRoles();
        }
        return this.partRoles;
    }

    public ICommandStack getCommandStack() {
        return this.commandStack;
    }

    public void setCommandStack(ICommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public IViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(IViewer viewer) {
        if (this.viewer != null) {
            this.viewer.setEditDomain(null);
        }
        this.viewer = viewer;
        if (viewer != null) {
            viewer.setEditDomain(this);
        }
    }

    public ITool getDefaultTool() {
        return this.tools == null ? null : this.tools.get(this.defaultTool);
    }

    public String getDefaultToolType() {
        return this.defaultTool;
    }

    public void setDefaultTool(String id) {
        this.defaultTool = id;
    }

    public ITool getActiveTool() {
        if (this.activeTool == null) {
            this.setActiveTool("default tool");
        }
        return this.activeTool;
    }

    public ITool setActiveTool(String id) {
        ITool ret = this.getTool(id);
        if (ret != null) {
            this.setActiveTool(ret);
        }
        return ret;
    }

    private void setActiveTool(ITool activeTool) {
        if (activeTool == this.activeTool) {
            return;
        }
        ITool oldTool = this.activeTool;
        if (oldTool != null) {
            oldTool.deactivate(activeTool);
        }
        this.activeTool = activeTool;
        if (activeTool != null) {
            activeTool.activate(oldTool);
        }
        this.fireActiveToolChanged(oldTool);
    }

    public void installTool(String id, ITool tool) {
        if (id == null || tool == null) {
            return;
        }
        if (this.tools == null) {
            this.tools = new HashMap<String, ITool>();
        }
        this.tools.put(id, tool);
        tool.setDomain(this);
        if (this.defaultTool == null || "default tool".equals(this.defaultTool)) {
            this.defaultTool = id;
        }
    }

    public ITool getTool(String id) {
        if ("default tool".equals(id)) {
            return this.getDefaultTool();
        }
        return this.tools == null ? null : this.tools.get(id);
    }

    public boolean hasTool(String id) {
        if ("default tool".equals(id)) {
            return this.hadDefaultTool();
        }
        return this.tools != null && id != null && this.tools.containsKey(id);
    }

    private boolean hadDefaultTool() {
        return this.tools != null && this.defaultTool != null && this.tools.containsKey(this.defaultTool);
    }

    public void addEditDomainListener(IEditDomainListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IEditDomainListener>();
        }
        this.listeners.add(listener);
    }

    public void removeEditDomainListener(IEditDomainListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    protected void fireActiveToolChanged(ITool oldTool) {
        if (this.listeners == null) {
            return;
        }
        ITool newTool = this.getActiveTool();
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IEditDomainListener)listener).activeToolChanged(oldTool, newTool);
            ++n2;
        }
    }

    public void handleRequest(Request request) {
        ITool tool = this.getActiveTool();
        if (tool != null) {
            tool.handleRequest(request);
        }
    }

    public void handleRequest(String requestType, IViewer targetViewer) {
        ITool tool = this.getActiveTool();
        if (tool != null) {
            tool.handleRequest(requestType, targetViewer);
        }
    }
}

