/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.net.www.protocol.http.InMemoryCookieStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieManager
extends CookieHandler {
    private CookiePolicy policyCallback;
    private CookieStore cookieJar = null;

    public CookieManager() {
        this(null, null);
    }

    public CookieManager(CookieStore cookieStore, CookiePolicy cookiePolicy) {
        this.policyCallback = cookiePolicy == null ? CookiePolicy.ACCEPT_ORIGINAL_SERVER : cookiePolicy;
        this.cookieJar = cookieStore == null ? new InMemoryCookieStore() : cookieStore;
    }

    public void setCookiePolicy(CookiePolicy cookiePolicy) {
        if (cookiePolicy != null) {
            this.policyCallback = cookiePolicy;
        }
    }

    public CookieStore getCookieStore() {
        return this.cookieJar;
    }

    @Override
    public Map<String, List<String>> get(URI uRI, Map<String, List<String>> map) throws IOException {
        if (uRI == null || map == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.cookieJar == null) {
            return Collections.unmodifiableMap(hashMap);
        }
        ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        for (HttpCookie httpCookie : this.cookieJar.get(uRI)) {
            if (!this.pathMatches(uRI.getPath(), httpCookie.getPath())) continue;
            arrayList.add(httpCookie);
        }
        List<String> list = this.sortByPath(arrayList);
        hashMap.put("Cookie", list);
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public void put(URI uRI, Map<String, List<String>> map) throws IOException {
        if (uRI == null || map == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (this.cookieJar == null) {
            return;
        }
        for (String string : map.keySet()) {
            if (string == null || !string.equalsIgnoreCase("Set-Cookie2") && !string.equalsIgnoreCase("Set-Cookie")) continue;
            for (String string2 : map.get(string)) {
                try {
                    List<HttpCookie> list = HttpCookie.parse(string2);
                    for (HttpCookie httpCookie : list) {
                        if (!this.shouldAcceptInternal(uRI, httpCookie)) continue;
                        this.cookieJar.add(uRI, httpCookie);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
    }

    private boolean shouldAcceptInternal(URI uRI, HttpCookie httpCookie) {
        try {
            return this.policyCallback.shouldAccept(uRI, httpCookie);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean pathMatches(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.startsWith(string2);
    }

    private List<String> sortByPath(List<HttpCookie> list) {
        Collections.sort(list, new CookiePathComparator());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HttpCookie httpCookie : list) {
            if (list.indexOf(httpCookie) == 0 && httpCookie.getVersion() > 0) {
                arrayList.add("$Version=\"1\"");
            }
            arrayList.add(httpCookie.toString());
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CookiePathComparator
    implements Comparator<HttpCookie> {
        CookiePathComparator() {
        }

        @Override
        public int compare(HttpCookie httpCookie, HttpCookie httpCookie2) {
            if (httpCookie == httpCookie2) {
                return 0;
            }
            if (httpCookie == null) {
                return -1;
            }
            if (httpCookie2 == null) {
                return 1;
            }
            if (!httpCookie.getName().equals(httpCookie2.getName())) {
                return 0;
            }
            if (httpCookie.getPath().startsWith(httpCookie2.getPath())) {
                return -1;
            }
            if (httpCookie2.getPath().startsWith(httpCookie.getPath())) {
                return 1;
            }
            return 0;
        }
    }
}

