/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.tool.SelectTool;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryViewer;

public class GallerySelectTool
extends SelectTool {
    private FramePart sourceFrame = null;

    protected boolean isFrameAsButton() {
        return !this.getTargetViewer().getProperties().getBoolean("org.xmind.ui.gallery.solidFrames", false);
    }

    protected boolean isSingleClickToOpen() {
        return this.getTargetViewer().getProperties().getBoolean("org.xmind.ui.gallery.singleClickToOpen", false);
    }

    public boolean isTitleEditable(IPart p) {
        return p instanceof FramePart && ((FramePart)p).getFigure().getTitle().containsPoint(this.getCursorPosition());
    }

    protected boolean handleMouseDown(MouseEvent me) {
        FramePart frame;
        if (this.isFrameAsButton() && me.target instanceof FramePart && (frame = (FramePart)me.target).getContentPane().containsPoint(me.cursorLocation)) {
            this.sourceFrame = frame;
            this.sourceFrame.getFigure().press();
        }
        boolean ret = this.handleSelectionOnMouseDown(me);
        if (this.isTitleEditable(me.target)) {
            Request request = new Request("edit");
            request.setDomain(this.getDomain());
            request.setViewer((IViewer)this.getTargetViewer());
            this.startEditing(me.target, request);
            ITool et = this.getTool("edit tool");
            if (et != null && et == this.getDomain().getActiveTool()) {
                me.consume();
            }
        } else if (this.isSingleClickToOpen()) {
            this.performOpen();
            me.consume();
        }
        return ret;
    }

    protected boolean handleSelectionOnMouseDown(MouseEvent me) {
        return super.handleMouseDown(me);
    }

    public boolean handleMouseUp(MouseEvent me) {
        if (this.sourceFrame != null) {
            this.sourceFrame.getFigure().unpress();
            this.sourceFrame = null;
        }
        return super.handleMouseUp(me);
    }

    protected boolean handleMouseDoubleClick(MouseEvent me) {
        if (me.target instanceof FramePart && !this.isSingleClickToOpen() && !this.isTitleEditable(me.target)) {
            this.performOpen();
            me.consume();
            return true;
        }
        return super.handleMouseDoubleClick(me);
    }

    protected void performOpen() {
        GalleryViewer viewer = (GalleryViewer)this.getTargetViewer();
        viewer.fireOpen();
    }
}

