/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.AdvancedToolbarLayout;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.graphics.GradientPattern;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.gallery.FrameBorderLayout;
import org.xmind.ui.gallery.ShadowedLayer;
import org.xmind.ui.resources.ColorUtils;

public class FrameFigure
extends Figure {
    private static final int FLAG_SELECTED = MAX_FLAG << 1;
    private static final int FLAG_PRESELECTED = MAX_FLAG << 2;
    private static final int FLAG_HIDE_TITLE = MAX_FLAG << 3;
    private static final int FLAG_FLAT;
    protected static final Color ColorSelected;
    protected static final Color ColorSelectedPreselected;
    protected static final Color ColorInactive;
    private RotatableWrapLabel title;
    private IFigure titleContainer;
    private ShadowedLayer contentLayer;
    private int titlePlacement = 8;

    static {
        MAX_FLAG = FLAG_FLAT = MAX_FLAG << 4;
        ColorSelected = ColorUtils.getColor((String)"#0070d8");
        ColorSelectedPreselected = ColorUtils.getColor((String)"#2088e0");
        ColorInactive = ColorUtils.gray((Color)ColorSelected);
    }

    public FrameFigure() {
        this.setBorder((Border)new FocusBorder());
        FrameBorderLayout layout = new FrameBorderLayout();
        layout.setVerticalSpacing(2);
        layout.setHorizontalSpacing(2);
        super.setLayoutManager((LayoutManager)layout);
        this.titleContainer = new Layer();
        AdvancedToolbarLayout titleContainerLayout = new AdvancedToolbarLayout();
        titleContainerLayout.setStretchMinorAxis(true);
        this.titleContainer.setLayoutManager((LayoutManager)titleContainerLayout);
        this.add(this.titleContainer, FrameBorderLayout.TOP);
        this.title = new RotatableWrapLabel(0){

            protected void paintFigure(Graphics graphics) {
                if (FrameFigure.this.isSelected()) {
                    graphics.setForegroundColor(ColorConstants.white);
                }
                super.paintFigure(graphics);
            }
        };
        this.title.setTextAlignment(2);
        this.title.setAbbreviated(true);
        this.titleContainer.add((IFigure)this.title, (Object)FrameBorderLayout.TOP);
        this.contentLayer = new ShadowedLayer();
        this.contentLayer.setBorderColor(ColorConstants.gray);
        this.add((IFigure)this.contentLayer, FrameBorderLayout.CENTER);
    }

    public void setLayoutManager(LayoutManager manager) {
    }

    public void paint(Graphics graphics) {
        GraphicsUtils.fixGradientBugForCarbon((Graphics)graphics, (IFigure)this);
        super.paint(graphics);
    }

    protected void paintFigure(Graphics graphics) {
        boolean preselected = this.isPreselected();
        boolean selected = this.isSelected();
        if (preselected && selected) {
            this.paintBackground(graphics, ColorSelectedPreselected, 240);
        } else if (preselected) {
            this.paintBackground(graphics, ColorSelected, 128);
        } else if (selected) {
            this.paintBackground(graphics, ColorSelected, 240);
        }
        super.paintFigure(graphics);
    }

    private void paintBackground(Graphics graphics, Color color, int alpha) {
        Rectangle b = new Rectangle(this.getBounds()).shrink(1, 1);
        graphics.setAntialias(1);
        graphics.setAlpha(alpha);
        graphics.pushState();
        try {
            switch (this.getTitlePlacement()) {
                case 1: {
                    this.paintHorizontalBackground(graphics, 0, b, color, alpha, ColorUtils.gradientLighter((Color)color), alpha);
                    break;
                }
                case 4: {
                    this.paintHorizontalBackground(graphics, 0, b, ColorUtils.gradientLighter((Color)color), alpha, color, alpha);
                    break;
                }
                case 32: {
                    this.paintVerticalBackground(graphics, 0, b, ColorUtils.gradientLighter((Color)color), alpha, color, alpha);
                    break;
                }
                case 8: {
                    this.paintVerticalBackground(graphics, 0, b, color, alpha, ColorUtils.gradientLighter((Color)color), alpha);
                }
            }
        }
        finally {
            graphics.popState();
        }
    }

    private void paintVerticalBackground(Graphics graphics, int start, Rectangle r, Color color1, int alpha1, Color color2, int alpha2) {
        int length = r.height;
        GradientPattern p = new GradientPattern((Device)Display.getCurrent(), (float)r.x, (float)(start += r.y), (float)r.x, (float)(start + length), color1, alpha1, color2, alpha2);
        graphics.setBackgroundPattern((Pattern)p);
        org.xmind.gef.draw2d.graphics.Path s = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        s.addRoundedRectangle((float)r.x, (float)start, (float)r.width, (float)length, 3.0f);
        graphics.fillPath((Path)s);
        s.dispose();
        p.dispose();
    }

    private void paintHorizontalBackground(Graphics graphics, int start, Rectangle r, Color color, int alpha1, Color color2, int alpha2) {
        int length = r.width;
        GradientPattern p = new GradientPattern((Device)Display.getCurrent(), (float)(start += r.x), (float)r.y, (float)(start + length), (float)r.y, color, alpha1, color2, alpha2);
        graphics.setBackgroundPattern((Pattern)p);
        org.xmind.gef.draw2d.graphics.Path s = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
        s.addRoundedRectangle((float)start, (float)r.y, (float)length, (float)r.height, 3.0f);
        graphics.fillPath((Path)s);
        s.dispose();
        p.dispose();
    }

    public ShadowedLayer getContentPane() {
        return this.contentLayer;
    }

    public ITextFigure getTitle() {
        return this.title;
    }

    public int getTitlePlacement() {
        return this.titlePlacement;
    }

    public void setTitlePlacement(int textPlacement) {
        if (textPlacement == this.getTitlePlacement()) {
            return;
        }
        this.titlePlacement = textPlacement;
        this.updateTitlePlacement(textPlacement);
    }

    private void updateTitlePlacement(int textPlacement) {
        Integer constraint = null;
        switch (textPlacement) {
            case 1: {
                constraint = FrameBorderLayout.LEFT;
                this.title.setTextAlignment(4);
                break;
            }
            case 4: {
                constraint = FrameBorderLayout.RIGHT;
                this.title.setTextAlignment(1);
                break;
            }
            case 8: {
                constraint = FrameBorderLayout.TOP;
                this.title.setTextAlignment(2);
                break;
            }
            case 32: {
                constraint = FrameBorderLayout.BOTTOM;
                this.title.setTextAlignment(2);
            }
        }
        if (constraint != null && this.titleContainer.getParent() == this) {
            this.setConstraint(this.titleContainer, constraint);
        }
    }

    public boolean isSelected() {
        return this.getFlag(FLAG_SELECTED);
    }

    public void setSelected(boolean selected) {
        if (selected == this.isSelected()) {
            return;
        }
        this.setFlag(FLAG_SELECTED, selected);
        this.repaint();
    }

    public void setPreselected(boolean preselected) {
        if (preselected == this.isPreselected()) {
            return;
        }
        this.setFlag(FLAG_PRESELECTED, preselected);
        this.repaint();
    }

    public boolean isPreselected() {
        return this.getFlag(FLAG_PRESELECTED);
    }

    public boolean isPressed() {
        return this.contentLayer.isPressed();
    }

    public void setPressed(boolean pressed) {
        if (this.isFlat()) {
            return;
        }
        this.contentLayer.setPressed(pressed);
    }

    public void press() {
        if (this.isFlat()) {
            return;
        }
        this.contentLayer.press();
    }

    public void unpress() {
        if (this.isFlat()) {
            return;
        }
        this.contentLayer.unpress();
    }

    public void togglePressed() {
        if (this.isFlat()) {
            return;
        }
        this.contentLayer.togglePressed();
    }

    public boolean isHideTitle() {
        return this.getFlag(FLAG_HIDE_TITLE);
    }

    public boolean isFlat() {
        return this.getFlag(FLAG_FLAT);
    }

    public void setFlat(boolean flat) {
        if (flat == this.isFlat()) {
            return;
        }
        this.setFlag(FLAG_FLAT, flat);
        if (flat) {
            this.contentLayer.setDepths(0);
        } else {
            this.contentLayer.setDepths(3);
        }
    }

    public void setHideTitle(boolean hideTitle) {
        boolean oldHideTitle = this.isHideTitle();
        if (hideTitle == oldHideTitle) {
            return;
        }
        this.setFlag(FLAG_HIDE_TITLE, hideTitle);
        if (hideTitle) {
            this.remove(this.titleContainer);
        } else {
            this.add(this.titleContainer);
            this.updateTitlePlacement(this.getTitlePlacement());
        }
    }

    private class FocusBorder
    extends AbstractBorder {
        private Insets insets = new Insets(6);

        private FocusBorder() {
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            boolean selected = FrameFigure.this.isSelected();
            boolean preselected = FrameFigure.this.isPreselected();
            if (!preselected && !selected) {
                return;
            }
            boolean selectedPreselected = preselected && selected;
            boolean lighter = preselected && !selected;
            graphics.setAntialias(1);
            graphics.setLineWidth(1);
            graphics.setLineStyle(1);
            tempRect.setBounds(FocusBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
            tempRect.shrink(1, 1);
            graphics.setForegroundColor(selectedPreselected ? ColorSelectedPreselected : ColorSelected);
            graphics.setAlpha(lighter ? 128 : 240);
            org.xmind.gef.draw2d.graphics.Path p = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            p.addRoundedRectangle((float)FocusBorder.tempRect.x, (float)FocusBorder.tempRect.y, (float)FocusBorder.tempRect.width, (float)FocusBorder.tempRect.height, 3.0f);
            graphics.drawPath((Path)p);
            p.dispose();
        }

        public Insets getInsets(IFigure figure) {
            return this.insets;
        }
    }
}

