/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.xmind.gef.EditDomain;
import org.xmind.gef.command.CommandStack;
import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ICommandStackListener;
import org.xmind.gef.ui.actions.ActionRegistry;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.actions.ICommandStackAction;
import org.xmind.gef.ui.editor.GraphicalEditorActionBarContributor;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.editor.IMiniBar;
import org.xmind.gef.ui.editor.IMiniBarContributor;
import org.xmind.gef.ui.editor.IPageContainerPresentation;
import org.xmind.gef.ui.editor.MiniBar;
import org.xmind.gef.ui.editor.MultiGraphicalPageSelectionProvider;
import org.xmind.gef.ui.editor.TabFolderContainerPresentation;

public abstract class GraphicalEditor
extends EditorPart
implements IGraphicalEditor,
ICommandStackListener {
    private IPageContainerPresentation containerPresentation = null;
    private IPageChangedListener presentationHooker = null;
    private Composite container = null;
    private List<IGraphicalEditorPage> pages = new ArrayList<IGraphicalEditorPage>();
    private List<IPageChangedListener> pageChangedListeners = null;
    private ICommandStack commandStack = null;
    private IMiniBarContributor miniBarContributor = null;
    private IActionRegistry actionRegistry = null;
    private List<ICommandStackAction> csActions = null;
    private int activePageIndex = -1;
    private PageSelectionProvider pageSelectionProvider = null;
    private MenuManager pagePopupMenu = null;

    protected Composite getContainer() {
        return this.container;
    }

    protected IPageContainerPresentation getContainerPresentation() {
        return this.containerPresentation;
    }

    protected void hookContainerPresentation() {
        if (this.presentationHooker == null) {
            this.presentationHooker = new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    GraphicalEditor.this.handlePageChange(GraphicalEditor.this.getActivePage());
                }
            };
        }
        this.getContainerPresentation().addPageChangedListener(this.presentationHooker);
    }

    public void createPartControl(Composite parent) {
        if (this.containerPresentation == null) {
            this.containerPresentation = this.createContainerPresentation();
            this.hookContainerPresentation();
        }
        Composite pageContainer = this.createPageContainer(parent);
        this.container = this.containerPresentation.createContainer(pageContainer);
        this.createEditorContents();
        this.createInitialPages();
    }

    protected void createEditorContents() {
        this.createMiniBar();
        this.createPageContextMenu(this.getContainer());
    }

    protected void createInitialPages() {
        this.createPages();
        if (this.getActivePage() == -1 && this.getPageCount() > 0) {
            this.setActivePage(0);
        }
    }

    protected IPageContainerPresentation createContainerPresentation() {
        return new TabFolderContainerPresentation();
    }

    protected Composite createPageContainer(Composite parent) {
        return parent;
    }

    public void addPage(IGraphicalEditorPage page) {
        page.setEditDomain(this.createEditDomain(page));
        this.createPageControl(page);
        this.pages.add(page);
    }

    protected EditDomain createEditDomain(IGraphicalEditorPage page) {
        return new EditDomain();
    }

    private void createPageControl(IGraphicalEditorPage page) {
        page.createPageControl(this.getContainer());
        Assert.isNotNull((Object)page.getControl());
        Assert.isNotNull((Object)page.getViewer());
        Assert.isNotNull((Object)page.getViewer().getControl());
        this.addPage(page.getControl());
    }

    protected void createPageContextMenu(final Composite container) {
        Menu menu;
        if (this.pagePopupMenu == null) {
            this.pagePopupMenu = this.createPagePopupMenu();
            String menuId = String.valueOf(this.getSite().getId()) + ".page";
            this.initPagePopupMenu(this.pagePopupMenu);
            this.registerPagePopupMenu(menuId, this.pagePopupMenu);
        }
        if ((menu = this.pagePopupMenu.getMenu()) == null || menu.isDisposed()) {
            menu = this.pagePopupMenu.createContextMenu((Control)container);
            container.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    GraphicalEditor.this.handleMouseDownOnContainer(container, event.x, event.y);
                }
            });
        }
        container.setMenu(menu);
    }

    protected void handleMouseDownOnContainer(Composite container, int x, int y) {
        if (this.containerPresentation == null || this.pageSelectionProvider == null) {
            return;
        }
        int selectedPage = this.containerPresentation.findPage(container, x, y);
        if (this.pageSelectionProvider != null) {
            this.pageSelectionProvider.setSelectedPage(selectedPage);
        }
    }

    protected void registerPagePopupMenu(String menuId, MenuManager menu) {
        this.getSite().registerContextMenu(menuId, menu, this.getPageSelectionProvider());
    }

    protected void initPagePopupMenu(MenuManager menu) {
        if (this.isPagePopupMenuDynamic()) {
            menu.setRemoveAllWhenShown(true);
            menu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    GraphicalEditor.this.contributeToPagePopupMenu(manager);
                }
            });
        } else {
            this.contributeToPagePopupMenu((IMenuManager)menu);
        }
    }

    protected void contributeToPagePopupMenu(IMenuManager menu) {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof GraphicalEditorActionBarContributor) {
            ((GraphicalEditorActionBarContributor)contributor).contributeToPagePopupMenu(menu);
        }
    }

    protected boolean isPagePopupMenuDynamic() {
        return true;
    }

    protected MenuManager createPagePopupMenu() {
        return new MenuManager();
    }

    protected void addPage(Control pageControl) {
        int index = this.containerPresentation.getPageCount(this.getContainer());
        this.containerPresentation.addPage(this.getContainer(), index, pageControl);
    }

    public void removePage(IGraphicalEditorPage page) {
        this.removePage(this.findPage(page));
    }

    protected void removePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        boolean wasActivePage = pageIndex == this.getActivePage();
        IGraphicalEditorPage page = this.getPage(pageIndex);
        this.containerPresentation.disposePage(this.getContainer(), pageIndex);
        this.pages.remove(page);
        if (page != null) {
            page.dispose();
        }
        if (wasActivePage) {
            if (pageIndex == this.getPageCount()) {
                --pageIndex;
            }
            this.setActivePage(pageIndex);
        }
    }

    public IGraphicalEditorPage getPage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return null;
        }
        return this.pages.get(pageIndex);
    }

    public int findPage(IGraphicalEditorPage page) {
        return this.pages.indexOf(page);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getCommandStack() != null) {
            this.getCommandStack().markSaved();
        }
        this.fireDirty();
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public boolean isDirty() {
        return this.getCommandStack() != null && this.getCommandStack().isDirty();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.init();
    }

    protected void init() {
        this.getSite().setSelectionProvider(this.createSelectionProvider());
        this.initCommandStack();
        this.installModelListener();
        this.initEditorActions(this.getActionRegistry());
    }

    protected ISelectionProvider createSelectionProvider() {
        return new MultiGraphicalPageSelectionProvider();
    }

    protected void initCommandStack() {
        this.setCommandStack(this.createCommandStack());
    }

    protected void initEditorActions(IActionRegistry actionRegistry) {
    }

    protected abstract void createPages();

    protected final void createMiniBar() {
        if (!(this.getContainer() instanceof CTabFolder)) {
            return;
        }
        MiniBar miniBar = new MiniBar(){

            public void updateBar() {
                super.updateBar();
                ToolBar control = ((ToolBarManager)this.getToolBarManager()).getControl();
                if (control != null && !control.isDisposed()) {
                    CTabFolder tabFolder = (CTabFolder)GraphicalEditor.this.getContainer();
                    GraphicalEditor.this.updateMiniBarControl(tabFolder, (Control)control);
                }
            }
        };
        this.initializeMiniBar(miniBar);
        if (!miniBar.isEmpty()) {
            this.createMiniBarControl(miniBar, (CTabFolder)this.getContainer());
        }
    }

    private void initializeMiniBar(IMiniBar miniBar) {
        if (this.getMiniBarContributor() != null) {
            this.getMiniBarContributor().init(miniBar, this);
        }
    }

    private void createMiniBarControl(IMiniBar miniBar, CTabFolder tabFolder) {
        ToolBar control = ((ToolBarManager)miniBar.getToolBarManager()).createControl((Composite)tabFolder);
        this.updateMiniBarControl(tabFolder, (Control)control);
    }

    private void updateMiniBarControl(CTabFolder tabFolder, Control barControl) {
        int tabHeight = barControl.computeSize((int)-1, (int)-1).y;
        tabHeight = Math.max(tabHeight, tabFolder.getTabHeight());
        tabFolder.setTabHeight(tabHeight);
        tabFolder.setTopRight(barControl, 131072);
    }

    public IMiniBarContributor getMiniBarContributor() {
        return this.miniBarContributor;
    }

    public void setMiniBarContributor(IMiniBarContributor miniBarContributor) {
        this.miniBarContributor = miniBarContributor;
    }

    protected ICommandStack createCommandStack() {
        return new CommandStack();
    }

    public void handleCommandStackEvent(CommandStackEvent event) {
        if ((event.getStatus() & 0x38) != 0) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    GraphicalEditor.this.fireDirty();
                }
            });
        }
    }

    public void setCommandStack(ICommandStack commandStack) {
        ICommandStack oldCS = this.commandStack;
        if (commandStack == oldCS) {
            return;
        }
        this.commandStack = commandStack;
        this.commandStackChanged(oldCS, commandStack);
    }

    protected void commandStackChanged(ICommandStack oldCS, ICommandStack newCS) {
        if (oldCS != null) {
            this.unhookCommandStack(oldCS);
        }
        if (newCS != null) {
            this.hookCommandStack(newCS);
        }
        IGraphicalEditorPage[] iGraphicalEditorPageArray = this.getPages();
        int n = iGraphicalEditorPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGraphicalEditorPage page = iGraphicalEditorPageArray[n2];
            EditDomain domain = page.getEditDomain();
            if (domain != null) {
                domain.setCommandStack(newCS);
            }
            ++n2;
        }
        if (this.csActions != null) {
            for (ICommandStackAction action : this.csActions) {
                action.setCommandStack(newCS);
            }
        }
        this.fireDirty();
    }

    protected void hookCommandStack(ICommandStack cs) {
        cs.addCSListener((ICommandStackListener)this);
    }

    protected void unhookCommandStack(ICommandStack cs) {
        cs.removeCSListener((ICommandStackListener)this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ICommandStack.class) {
            return this.getCommandStack();
        }
        if (adapter == IActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == IMiniBarContributor.class) {
            return this.getMiniBarContributor();
        }
        return super.getAdapter(adapter);
    }

    protected void installModelListener() {
    }

    protected void uninstallModelListener() {
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        if (this.pageChangedListeners == null) {
            this.pageChangedListeners = new ArrayList<IPageChangedListener>();
        }
        this.pageChangedListeners.add(listener);
    }

    public Object getSelectedPage() {
        return this.getActivePageInstance();
    }

    public IGraphicalEditorPage getActivePageInstance() {
        return this.getPage(this.getActivePage());
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        if (this.pageChangedListeners == null) {
            return;
        }
        this.pageChangedListeners.remove(listener);
    }

    protected void firePageChanged(Object newPage) {
        if (this.pageChangedListeners == null) {
            return;
        }
        final PageChangedEvent event = new PageChangedEvent((IPageChangeProvider)this, newPage);
        Object[] objectArray = this.pageChangedListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IPageChangedListener)l).pageChanged(event);
                }
            });
            ++n2;
        }
    }

    protected void fireDirty() {
        this.firePropertyChange(257);
    }

    protected void handlePageChange(int newPageIndex) {
        ISelectionProvider selectionProvider;
        IEditorActionBarContributor contributor;
        this.setFocus();
        IGraphicalEditorPage oldActivePage = this.getPage(this.activePageIndex);
        if (oldActivePage != null && oldActivePage.isActive()) {
            oldActivePage.setActive(false);
        }
        this.activePageIndex = newPageIndex;
        IGraphicalEditorPage activePage = this.getPage(newPageIndex);
        if (activePage != null && !activePage.isActive()) {
            activePage.setActive(true);
        }
        if ((contributor = this.getEditorSite().getActionBarContributor()) != null && contributor instanceof GraphicalEditorActionBarContributor) {
            ((GraphicalEditorActionBarContributor)contributor).setActivePage(activePage);
        }
        if ((selectionProvider = this.getSite().getSelectionProvider()) instanceof MultiGraphicalPageSelectionProvider) {
            ((MultiGraphicalPageSelectionProvider)selectionProvider).setActivePage(activePage);
        }
        if (this.getMiniBarContributor() != null) {
            this.getMiniBarContributor().setActivePage(activePage);
        }
        this.firePageChanged(activePage);
    }

    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    protected void setFocus(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            this.container.setFocus();
        } else {
            IGraphicalEditorPage page = this.getPage(pageIndex);
            if (page != null) {
                page.setFocus();
            } else {
                Control control = this.containerPresentation.getPageControl(this.getContainer(), pageIndex);
                if (control != null && !control.isDisposed()) {
                    control.setFocus();
                }
            }
        }
    }

    public void movePageTo(int oldIndex, int newIndex) {
        boolean wasActive = oldIndex == this.getActivePage();
        this.pages.add(newIndex, this.pages.remove(oldIndex));
        int i = 0;
        while (i < this.pages.size()) {
            IGraphicalEditorPage page = this.pages.get(i);
            this.containerPresentation.setPageControl(this.getContainer(), i, page.getControl());
            page.updatePageTitle();
            ++i;
        }
        if (wasActive) {
            this.pages.get(newIndex).getControl().setVisible(true);
            this.setActivePage(newIndex);
        }
    }

    public String getPageText(int pageIndex) {
        return this.containerPresentation.getPageText(this.getContainer(), pageIndex);
    }

    public void setPageText(int pageIndex, String text) {
        if (text == null) {
            text = "";
        }
        this.containerPresentation.setPageText(this.getContainer(), pageIndex, text);
    }

    public int getActivePage() {
        return this.containerPresentation.getActivePage(this.getContainer());
    }

    public void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex < this.getPageCount() ? 1 : 0) != 0);
        if (pageIndex >= 0) {
            this.containerPresentation.setActivePage(this.getContainer(), pageIndex);
        } else {
            this.containerPresentation.setActivePage(this.getContainer(), this.containerPresentation.getPageCount(this.getContainer()) - 1);
        }
        this.handlePageChange(pageIndex);
    }

    public IGraphicalEditorPage[] getPages() {
        return this.pages.toArray(new IGraphicalEditorPage[this.pages.size()]);
    }

    protected ISelectionProvider getPageSelectionProvider() {
        if (this.pageSelectionProvider == null) {
            this.pageSelectionProvider = new PageSelectionProvider();
        }
        return this.pageSelectionProvider;
    }

    public ICommandStack getCommandStack() {
        return this.commandStack;
    }

    protected IActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public void dispose() {
        if (this.csActions != null) {
            for (ICommandStackAction action : this.csActions) {
                action.setCommandStack(null);
            }
            this.csActions = null;
        }
        if (this.actionRegistry != null) {
            this.actionRegistry.dispose();
            this.actionRegistry = null;
        }
        if (this.pagePopupMenu != null) {
            this.pagePopupMenu.dispose();
            this.pagePopupMenu = null;
        }
        this.uninstallModelListener();
        if (this.commandStack != null && !this.commandStack.isDisposed()) {
            this.disposeCommandStack(this.commandStack);
            this.commandStack = null;
        }
        this.disposePages();
        super.dispose();
    }

    protected void disposeCommandStack(ICommandStack commandStack) {
        commandStack.dispose();
    }

    private void disposePages() {
        if (this.pages.isEmpty()) {
            return;
        }
        Object[] objectArray = this.pages.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object page = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IGraphicalEditorPage)page).dispose();
                }
            });
            ++n2;
        }
        this.pages.clear();
    }

    public IGraphicalEditorPage findPage(Object input) {
        IGraphicalEditorPage[] iGraphicalEditorPageArray = this.getPages();
        int n = iGraphicalEditorPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IGraphicalEditorPage page = iGraphicalEditorPageArray[n2];
            Object pageInput = page.getInput();
            if (pageInput == input || input != null && input.equals(pageInput)) {
                return page;
            }
            ++n2;
        }
        return null;
    }

    public IGraphicalEditorPage ensurePageVisible(Object input) {
        IGraphicalEditorPage page = this.findPage(input);
        if (page != null && page != this.getActivePageInstance()) {
            this.setActivePage(page.getIndex());
            page = this.getActivePageInstance();
        }
        return page;
    }

    public boolean navigateTo(Object input, Object ... elements) {
        IGraphicalEditorPage page = this.ensurePageVisible(input);
        if (page != null) {
            if (elements == null) {
                return true;
            }
            ISelectionProvider viewer = page.getSelectionProvider();
            if (viewer != null) {
                viewer.setSelection((ISelection)new StructuredSelection(elements));
                return true;
            }
        }
        return false;
    }

    protected void addCommandStackAction(ICommandStackAction action) {
        if (this.csActions == null) {
            this.csActions = new ArrayList<ICommandStackAction>();
        }
        this.csActions.add(action);
    }

    protected class PageSelectionProvider
    implements ISelectionProvider {
        private int selectedPage = -1;
        private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

        protected PageSelectionProvider() {
        }

        public int getSelectedPage() {
            return this.selectedPage;
        }

        public IGraphicalEditorPage getSelectedPageInstance() {
            return GraphicalEditor.this.getPage(this.selectedPage);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add(listener);
        }

        public ISelection getSelection() {
            Object pageInput;
            IGraphicalEditorPage page = this.getSelectedPageInstance();
            if (page != null && (pageInput = page.getInput()) != null) {
                return new StructuredSelection(pageInput);
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            Object pageInput;
            if (selection instanceof IStructuredSelection && (pageInput = ((IStructuredSelection)selection).getFirstElement()) != null) {
                GraphicalEditor.this.ensurePageVisible(pageInput);
            }
        }

        public void setSelectedPage(int index) {
            if (index == this.selectedPage) {
                return;
            }
            this.selectedPage = index;
            this.firePageChanged();
        }

        protected void firePageChanged() {
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }

        private void fireSelectionChanged(final SelectionChangedEvent event) {
            Object[] objectArray = this.listeners.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Object o = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((ISelectionChangedListener)o).selectionChanged(event);
                    }
                });
                ++n2;
            }
        }
    }
}

