/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.actions;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.actions.CommandStackAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.internal.ActionMessages;

public class RedoAction
extends CommandStackAction {
    public RedoAction(IGraphicalEditor editor) {
        super(editor);
        this.setId(ActionFactory.REDO.getId());
    }

    public void run() {
        if (this.getCommandStack() == null || this.isDisposed()) {
            return;
        }
        this.getCommandStack().redo();
    }

    protected void update() {
        ICommandStack cs = this.getCommandStack();
        boolean canRedo = cs != null && cs.canRedo();
        this.setEnabled(canRedo);
        String label = null;
        if (canRedo && cs != null) {
            label = cs.getRedoLabel();
        }
        if (label == null) {
            this.setText(ActionMessages.RedoText);
            this.setToolTipText(ActionMessages.RedoTooltip);
        } else {
            this.setText(NLS.bind((String)ActionMessages.RedoTextFormat, (Object)label));
            this.setToolTipText(NLS.bind((String)ActionMessages.RedoTooltipFormat, (Object)label));
        }
    }
}

