/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteComponentRaster;

public class ByteInterleavedRaster
extends ByteComponentRaster {
    boolean inOrder;
    int dbOffset;
    int dbOffsetPacked;
    boolean packed = false;
    int[] bitMasks;
    int[] bitOffsets;
    private int maxX = this.minX + this.width;
    private int maxY = this.minY + this.height;

    public ByteInterleavedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ByteInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    private boolean isInterleaved(ComponentSampleModel componentSampleModel) {
        int n;
        int n2 = this.sampleModel.getNumBands();
        if (n2 == 1) {
            return true;
        }
        int[] nArray = componentSampleModel.getBankIndices();
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == 0) continue;
            return false;
        }
        int[] nArray2 = componentSampleModel.getBandOffsets();
        int n3 = n = nArray2[0];
        for (int i = 1; i < n2; ++i) {
            int n4 = nArray2[i];
            if (n4 < n) {
                n = n4;
            }
            if (n4 <= n3) continue;
            n3 = n4;
        }
        return n3 - n < componentSampleModel.getPixelStride();
    }

    public ByteInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ByteInterleavedRaster byteInterleavedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, byteInterleavedRaster);
        SampleModel sampleModel2;
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("ByteInterleavedRasters must have byte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = dataBufferByte.getData();
        int n = rectangle.x - point.x;
        int n2 = rectangle.y - point.y;
        if (sampleModel instanceof PixelInterleavedSampleModel || sampleModel instanceof ComponentSampleModel && this.isInterleaved((ComponentSampleModel)sampleModel)) {
            sampleModel2 = (ComponentSampleModel)sampleModel;
            this.scanlineStride = ((ComponentSampleModel)sampleModel2).getScanlineStride();
            this.pixelStride = ((ComponentSampleModel)sampleModel2).getPixelStride();
            this.dataOffsets = ((ComponentSampleModel)sampleModel2).getBandOffsets();
            int n3 = 0;
            while (n3 < this.getNumDataElements()) {
                int n4 = n3++;
                this.dataOffsets[n4] = this.dataOffsets[n4] + (n * this.pixelStride + n2 * this.scanlineStride);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            sampleModel2 = (SinglePixelPackedSampleModel)sampleModel;
            this.packed = true;
            this.bitMasks = ((SinglePixelPackedSampleModel)sampleModel2).getBitMasks();
            this.bitOffsets = ((SinglePixelPackedSampleModel)sampleModel2).getBitOffsets();
            this.scanlineStride = ((SinglePixelPackedSampleModel)sampleModel2).getScanlineStride();
            this.pixelStride = 1;
            this.dataOffsets = new int[1];
            this.dataOffsets[0] = dataBufferByte.getOffset();
            this.dataOffsets[0] = this.dataOffsets[0] + (n * this.pixelStride + n2 * this.scanlineStride);
        } else {
            throw new RasterFormatException("ByteInterleavedRasters must have PixelInterleavedSampleModel, SinglePixelPackedSampleModel or interleaved ComponentSampleModel.  Sample model is " + sampleModel);
        }
        this.bandOffset = this.dataOffsets[0];
        this.dbOffsetPacked = dataBuffer.getOffset() - this.sampleModelTranslateY * this.scanlineStride - this.sampleModelTranslateX * this.pixelStride;
        this.dbOffset = this.dbOffsetPacked - (n * this.pixelStride + n2 * this.scanlineStride);
        this.inOrder = false;
        if (this.numDataElements == this.pixelStride) {
            this.inOrder = true;
            for (int i = 1; i < this.numDataElements; ++i) {
                if (this.dataOffsets[i] - this.dataOffsets[0] == i) continue;
                this.inOrder = false;
                break;
            }
        }
        this.verify(false);
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    public Object getDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        for (int i = 0; i < this.numDataElements; ++i) {
            byArray[i] = this.data[this.dataOffsets[i] + n3];
        }
        return byArray;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        return this.getByteData(n, n2, n3, n4, (byte[])object);
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[n3 * n4];
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride + this.dataOffsets[n5];
        int n7 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n3) {
                System.arraycopy(this.data, n6, byArray, 0, n3 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(this.data, n6, byArray, n7, n3);
                    n7 += n3;
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    byArray[n7++] = this.data[n10];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n6 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[this.numDataElements * n3 * n4];
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        if (this.inOrder) {
            n5 += this.dataOffsets[0];
            int n7 = n3 * this.pixelStride;
            if (this.scanlineStride == n7) {
                System.arraycopy(this.data, n5, byArray, n6, n7 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(this.data, n5, byArray, n6, n7);
                    n6 += n7;
                    ++n8;
                    n5 += this.scanlineStride;
                }
            }
        } else if (this.numDataElements == 1) {
            n5 += this.dataOffsets[0];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n5;
                int n11 = 0;
                while (n11 < n3) {
                    byArray[n6++] = this.data[n10];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 2) {
            n5 += this.dataOffsets[0];
            int n12 = this.dataOffsets[1] - this.dataOffsets[0];
            int n13 = 0;
            while (n13 < n4) {
                int n14 = n5;
                int n15 = 0;
                while (n15 < n3) {
                    byArray[n6++] = this.data[n14];
                    byArray[n6++] = this.data[n14 + n12];
                    ++n15;
                    n14 += this.pixelStride;
                }
                ++n13;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 3) {
            n5 += this.dataOffsets[0];
            int n16 = this.dataOffsets[1] - this.dataOffsets[0];
            int n17 = this.dataOffsets[2] - this.dataOffsets[0];
            int n18 = 0;
            while (n18 < n4) {
                int n19 = n5;
                int n20 = 0;
                while (n20 < n3) {
                    byArray[n6++] = this.data[n19];
                    byArray[n6++] = this.data[n19 + n16];
                    byArray[n6++] = this.data[n19 + n17];
                    ++n20;
                    n19 += this.pixelStride;
                }
                ++n18;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 4) {
            n5 += this.dataOffsets[0];
            int n21 = this.dataOffsets[1] - this.dataOffsets[0];
            int n22 = this.dataOffsets[2] - this.dataOffsets[0];
            int n23 = this.dataOffsets[3] - this.dataOffsets[0];
            int n24 = 0;
            while (n24 < n4) {
                int n25 = n5;
                int n26 = 0;
                while (n26 < n3) {
                    byArray[n6++] = this.data[n25];
                    byArray[n6++] = this.data[n25 + n21];
                    byArray[n6++] = this.data[n25 + n22];
                    byArray[n6++] = this.data[n25 + n23];
                    ++n26;
                    n25 += this.pixelStride;
                }
                ++n24;
                n5 += this.scanlineStride;
            }
        } else {
            int n27 = 0;
            while (n27 < n4) {
                int n28 = n5;
                int n29 = 0;
                while (n29 < n3) {
                    for (int i = 0; i < this.numDataElements; ++i) {
                        byArray[n6++] = this.data[this.dataOffsets[i] + n28];
                    }
                    ++n29;
                    n28 += this.pixelStride;
                }
                ++n27;
                n5 += this.scanlineStride;
            }
        }
        return byArray;
    }

    public void setDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        for (int i = 0; i < this.numDataElements; ++i) {
            this.data[this.dataOffsets[i] + n3] = byArray[i];
        }
        this.notifyChanged();
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = raster.getWidth();
        int n8 = raster.getHeight();
        if (n5 < this.minX || n6 < this.minY || n5 + n7 > this.maxX || n6 + n8 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n5, n6, n3, n4, n7, n8, raster);
    }

    private void setDataElements(int n, int n2, int n3, int n4, int n5, int n6, Raster raster) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        int n7 = raster.getMinX();
        int n8 = raster.getMinY();
        Object object = null;
        if (raster instanceof ByteInterleavedRaster) {
            ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)raster;
            byte[] byArray = byteInterleavedRaster.getDataStorage();
            if (this.inOrder && byteInterleavedRaster.inOrder && this.pixelStride == byteInterleavedRaster.pixelStride) {
                int n9 = byteInterleavedRaster.getDataOffset(0);
                int n10 = byteInterleavedRaster.getScanlineStride();
                int n11 = byteInterleavedRaster.getPixelStride();
                int n12 = n9 + (n4 - n8) * n10 + (n3 - n7) * n11;
                int n13 = this.dataOffsets[0] + (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
                int n14 = n5 * this.pixelStride;
                for (int i = 0; i < n6; ++i) {
                    System.arraycopy(byArray, n12, this.data, n13, n14);
                    n12 += n10;
                    n13 += this.scanlineStride;
                }
                this.notifyChanged();
                return;
            }
        }
        for (int i = 0; i < n6; ++i) {
            object = raster.getDataElements(n7, n8 + i, n5, 1, object);
            this.setDataElements(n, n2 + i, n5, 1, object);
        }
        this.notifyChanged();
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        this.putByteData(n, n2, n3, n4, (byte[])object);
    }

    public void putByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride + this.dataOffsets[n5];
        int n7 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n3) {
                System.arraycopy(byArray, 0, this.data, n6, n3 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(byArray, n7, this.data, n6, n3);
                    n7 += n3;
                    ++n8;
                    n6 += this.scanlineStride;
                }
            }
        } else {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    this.data[n10] = byArray[n7++];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n6 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public void putByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) * this.pixelStride;
        int n6 = 0;
        if (this.inOrder) {
            n5 += this.dataOffsets[0];
            int n7 = n3 * this.pixelStride;
            if (n7 == this.scanlineStride) {
                System.arraycopy(byArray, 0, this.data, n5, n7 * n4);
            } else {
                int n8 = 0;
                while (n8 < n4) {
                    System.arraycopy(byArray, n6, this.data, n5, n7);
                    n6 += n7;
                    ++n8;
                    n5 += this.scanlineStride;
                }
            }
        } else if (this.numDataElements == 1) {
            n5 += this.dataOffsets[0];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n5;
                int n11 = 0;
                while (n11 < n3) {
                    this.data[n10] = byArray[n6++];
                    ++n11;
                    n10 += this.pixelStride;
                }
                ++n9;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 2) {
            n5 += this.dataOffsets[0];
            int n12 = this.dataOffsets[1] - this.dataOffsets[0];
            int n13 = 0;
            while (n13 < n4) {
                int n14 = n5;
                int n15 = 0;
                while (n15 < n3) {
                    this.data[n14] = byArray[n6++];
                    this.data[n14 + n12] = byArray[n6++];
                    ++n15;
                    n14 += this.pixelStride;
                }
                ++n13;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 3) {
            n5 += this.dataOffsets[0];
            int n16 = this.dataOffsets[1] - this.dataOffsets[0];
            int n17 = this.dataOffsets[2] - this.dataOffsets[0];
            int n18 = 0;
            while (n18 < n4) {
                int n19 = n5;
                int n20 = 0;
                while (n20 < n3) {
                    this.data[n19] = byArray[n6++];
                    this.data[n19 + n16] = byArray[n6++];
                    this.data[n19 + n17] = byArray[n6++];
                    ++n20;
                    n19 += this.pixelStride;
                }
                ++n18;
                n5 += this.scanlineStride;
            }
        } else if (this.numDataElements == 4) {
            n5 += this.dataOffsets[0];
            int n21 = this.dataOffsets[1] - this.dataOffsets[0];
            int n22 = this.dataOffsets[2] - this.dataOffsets[0];
            int n23 = this.dataOffsets[3] - this.dataOffsets[0];
            int n24 = 0;
            while (n24 < n4) {
                int n25 = n5;
                int n26 = 0;
                while (n26 < n3) {
                    this.data[n25] = byArray[n6++];
                    this.data[n25 + n21] = byArray[n6++];
                    this.data[n25 + n22] = byArray[n6++];
                    this.data[n25 + n23] = byArray[n6++];
                    ++n26;
                    n25 += this.pixelStride;
                }
                ++n24;
                n5 += this.scanlineStride;
            }
        } else {
            int n27 = 0;
            while (n27 < n4) {
                int n28 = n5;
                int n29 = 0;
                while (n29 < n3) {
                    for (int i = 0; i < this.numDataElements; ++i) {
                        this.data[this.dataOffsets[i] + n28] = byArray[n6++];
                    }
                    ++n29;
                    n28 += this.pixelStride;
                }
                ++n27;
                n5 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public int getSample(int n, int n2, int n3) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (this.packed) {
            int n4 = n2 * this.scanlineStride + n + this.dbOffsetPacked;
            byte by = this.data[n4];
            return (by & this.bitMasks[n3]) >>> this.bitOffsets[n3];
        }
        int n5 = n2 * this.scanlineStride + n * this.pixelStride + this.dbOffset;
        return this.data[n5 + this.dataOffsets[n3]] & 0xFF;
    }

    public void setSample(int n, int n2, int n3, int n4) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (this.packed) {
            int n5 = n2 * this.scanlineStride + n + this.dbOffsetPacked;
            int n6 = this.bitMasks[n3];
            byte by = this.data[n5];
            by = (byte)(by & ~n6);
            this.data[n5] = by = (byte)(by | n4 << this.bitOffsets[n3] & n6);
        } else {
            int n7 = n2 * this.scanlineStride + n * this.pixelStride + this.dbOffset;
            this.data[n7 + this.dataOffsets[n3]] = (byte)n4;
        }
        this.notifyChanged();
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        int n6 = n2 * this.scanlineStride + n * this.pixelStride;
        int n7 = 0;
        if (this.packed) {
            n6 += this.dbOffsetPacked;
            int n8 = this.bitMasks[n5];
            int n9 = this.bitOffsets[n5];
            for (int i = 0; i < n4; ++i) {
                int n10 = n6;
                for (int j = 0; j < n3; ++j) {
                    byte by = this.data[n10++];
                    nArray2[n7++] = (by & n8) >>> n9;
                }
                n6 += this.scanlineStride;
            }
        } else {
            n6 += this.dbOffset + this.dataOffsets[n5];
            for (int i = 0; i < n4; ++i) {
                int n11 = n6;
                for (int j = 0; j < n3; ++j) {
                    nArray2[n7++] = this.data[n11] & 0xFF;
                    n11 += this.pixelStride;
                }
                n6 += this.scanlineStride;
            }
        }
        return nArray2;
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n2 * this.scanlineStride + n * this.pixelStride;
        int n7 = 0;
        if (this.packed) {
            n6 += this.dbOffsetPacked;
            int n8 = this.bitMasks[n5];
            for (int i = 0; i < n4; ++i) {
                int n9 = n6;
                for (int j = 0; j < n3; ++j) {
                    byte by = this.data[n9];
                    by = (byte)(by & ~n8);
                    int n10 = nArray[n7++];
                    by = (byte)(by | n10 << this.bitOffsets[n5] & n8);
                    this.data[n9++] = by;
                }
                n6 += this.scanlineStride;
            }
        } else {
            n6 += this.dbOffset + this.dataOffsets[n5];
            for (int i = 0; i < n4; ++i) {
                int n11 = n6;
                for (int j = 0; j < n3; ++j) {
                    this.data[n11] = (byte)nArray[n7++];
                    n11 += this.pixelStride;
                }
                n6 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4 * this.numBands];
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        int n6 = 0;
        if (this.packed) {
            n5 += this.dbOffsetPacked;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    byte by = this.data[n5 + j];
                    for (int k = 0; k < this.numBands; ++k) {
                        nArray2[n6++] = (by & this.bitMasks[k]) >>> this.bitOffsets[k];
                    }
                }
                n5 += this.scanlineStride;
            }
        } else {
            n5 += this.dbOffset;
            int n7 = this.dataOffsets[0];
            if (this.numBands == 1) {
                for (int i = 0; i < n4; ++i) {
                    int n8 = n5 + n7;
                    for (int j = 0; j < n3; ++j) {
                        nArray2[n6++] = this.data[n8] & 0xFF;
                        n8 += this.pixelStride;
                    }
                    n5 += this.scanlineStride;
                }
            } else if (this.numBands == 2) {
                int n9 = this.dataOffsets[1] - n7;
                for (int i = 0; i < n4; ++i) {
                    int n10 = n5 + n7;
                    for (int j = 0; j < n3; ++j) {
                        nArray2[n6++] = this.data[n10] & 0xFF;
                        nArray2[n6++] = this.data[n10 + n9] & 0xFF;
                        n10 += this.pixelStride;
                    }
                    n5 += this.scanlineStride;
                }
            } else if (this.numBands == 3) {
                int n11 = this.dataOffsets[1] - n7;
                int n12 = this.dataOffsets[2] - n7;
                for (int i = 0; i < n4; ++i) {
                    int n13 = n5 + n7;
                    for (int j = 0; j < n3; ++j) {
                        nArray2[n6++] = this.data[n13] & 0xFF;
                        nArray2[n6++] = this.data[n13 + n11] & 0xFF;
                        nArray2[n6++] = this.data[n13 + n12] & 0xFF;
                        n13 += this.pixelStride;
                    }
                    n5 += this.scanlineStride;
                }
            } else if (this.numBands == 4) {
                int n14 = this.dataOffsets[1] - n7;
                int n15 = this.dataOffsets[2] - n7;
                int n16 = this.dataOffsets[3] - n7;
                for (int i = 0; i < n4; ++i) {
                    int n17 = n5 + n7;
                    for (int j = 0; j < n3; ++j) {
                        nArray2[n6++] = this.data[n17] & 0xFF;
                        nArray2[n6++] = this.data[n17 + n14] & 0xFF;
                        nArray2[n6++] = this.data[n17 + n15] & 0xFF;
                        nArray2[n6++] = this.data[n17 + n16] & 0xFF;
                        n17 += this.pixelStride;
                    }
                    n5 += this.scanlineStride;
                }
            } else {
                for (int i = 0; i < n4; ++i) {
                    int n18 = n5;
                    for (int j = 0; j < n3; ++j) {
                        for (int k = 0; k < this.numBands; ++k) {
                            nArray2[n6++] = this.data[n18 + this.dataOffsets[k]] & 0xFF;
                        }
                        n18 += this.pixelStride;
                    }
                    n5 += this.scanlineStride;
                }
            }
        }
        return nArray2;
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = n2 * this.scanlineStride + n * this.pixelStride;
        int n6 = 0;
        if (this.packed) {
            n5 += this.dbOffsetPacked;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    int n7 = 0;
                    for (int k = 0; k < this.numBands; ++k) {
                        int n8 = nArray[n6++];
                        n7 |= n8 << this.bitOffsets[k] & this.bitMasks[k];
                    }
                    this.data[n5 + j] = (byte)n7;
                }
                n5 += this.scanlineStride;
            }
        } else {
            n5 += this.dbOffset;
            int n9 = this.dataOffsets[0];
            if (this.numBands == 1) {
                for (int i = 0; i < n4; ++i) {
                    int n10 = n5 + n9;
                    for (int j = 0; j < n3; ++j) {
                        this.data[n10] = (byte)nArray[n6++];
                        n10 += this.pixelStride;
                    }
                    n5 += this.scanlineStride;
                }
            } else if (this.numBands == 2) {
                int n11 = this.dataOffsets[1] - n9;
                for (int i = 0; i < n4; ++i) {
                    int n12 = n5 + n9;
                    for (int j = 0; j < n3; ++j) {
                        this.data[n12] = (byte)nArray[n6++];
                        this.data[n12 + n11] = (byte)nArray[n6++];
                        n12 += this.pixelStride;
                    }
                    n5 += this.scanlineStride;
                }
            } else if (this.numBands == 3) {
                int n13 = this.dataOffsets[1] - n9;
                int n14 = this.dataOffsets[2] - n9;
                for (int i = 0; i < n4; ++i) {
                    int n15 = n5 + n9;
                    for (int j = 0; j < n3; ++j) {
                        this.data[n15] = (byte)nArray[n6++];
                        this.data[n15 + n13] = (byte)nArray[n6++];
                        this.data[n15 + n14] = (byte)nArray[n6++];
                        n15 += this.pixelStride;
                    }
                    n5 += this.scanlineStride;
                }
            } else if (this.numBands == 4) {
                int n16 = this.dataOffsets[1] - n9;
                int n17 = this.dataOffsets[2] - n9;
                int n18 = this.dataOffsets[3] - n9;
                for (int i = 0; i < n4; ++i) {
                    int n19 = n5 + n9;
                    for (int j = 0; j < n3; ++j) {
                        this.data[n19] = (byte)nArray[n6++];
                        this.data[n19 + n16] = (byte)nArray[n6++];
                        this.data[n19 + n17] = (byte)nArray[n6++];
                        this.data[n19 + n18] = (byte)nArray[n6++];
                        n19 += this.pixelStride;
                    }
                    n5 += this.scanlineStride;
                }
            } else {
                for (int i = 0; i < n4; ++i) {
                    int n20 = n5;
                    for (int j = 0; j < n3; ++j) {
                        for (int k = 0; k < this.numBands; ++k) {
                            this.data[n20 + this.dataOffsets[k]] = (byte)nArray[n6++];
                        }
                        n20 += this.pixelStride;
                    }
                    n5 += this.scanlineStride;
                }
            }
        }
        this.notifyChanged();
    }

    public void setRect(int n, int n2, Raster raster) {
        int n3;
        if (!(raster instanceof ByteInterleavedRaster)) {
            super.setRect(n, n2, raster);
            return;
        }
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int n8 = n + n6;
        int n9 = n2 + n7;
        if (n8 < this.minX) {
            n3 = this.minX - n8;
            n4 -= n3;
            n6 += n3;
            n8 = this.minX;
        }
        if (n9 < this.minY) {
            n3 = this.minY - n9;
            n5 -= n3;
            n7 += n3;
            n9 = this.minY;
        }
        if (n8 + n4 > this.maxX) {
            n4 = this.maxX - n8;
        }
        if (n9 + n5 > this.maxY) {
            n5 = this.maxY - n9;
        }
        this.setDataElements(n8, n9, n6, n7, n4, n5, raster);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
        return writableRaster;
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n + n3 < n || n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        this.notifyStolen();
        return new ByteInterleavedRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new ByteInterleavedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl) {
        int n = 0;
        for (int i = 0; i < this.numDataElements; ++i) {
            int n2 = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[i];
            if (n2 <= n) continue;
            n = n2;
        }
        if (this.data.length < n) {
            throw new RasterFormatException("Data array too small (should be " + n + " )");
        }
    }

    public String toString() {
        return new String("ByteInterleavedRaster: width = " + this.width + " height = " + this.height + " #numDataElements " + this.numDataElements + " dataOff[0] = " + this.dataOffsets[0]);
    }
}

