/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.exception;

import com.sun.xml.internal.ws.util.localization.Localizable;
import com.sun.xml.internal.ws.util.localization.LocalizableImpl;
import com.sun.xml.internal.ws.util.localization.Localizer;
import com.sun.xml.internal.ws.util.localization.NullLocalizable;
import javax.xml.ws.WebServiceException;

public abstract class JAXWSExceptionBase
extends WebServiceException
implements Localizable {
    private final Localizable msg;

    protected JAXWSExceptionBase(String string, Object ... objectArray) {
        super(JAXWSExceptionBase.findNestedException(objectArray));
        this.msg = new LocalizableImpl(string, JAXWSExceptionBase.fixNull(objectArray), this.getDefaultResourceBundleName());
    }

    protected JAXWSExceptionBase(String string) {
        super(string);
        this.msg = null;
    }

    private static Object[] fixNull(Object[] objectArray) {
        if (objectArray == null) {
            return new Object[0];
        }
        return objectArray;
    }

    protected JAXWSExceptionBase(Throwable throwable) {
        this(new NullLocalizable(throwable.toString()), throwable);
    }

    protected JAXWSExceptionBase(Localizable localizable) {
        this.msg = localizable;
    }

    protected JAXWSExceptionBase(Localizable localizable, Throwable throwable) {
        super(throwable);
        this.msg = localizable;
    }

    private static Throwable findNestedException(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        for (Object object : objectArray) {
            if (!(object instanceof Throwable)) continue;
            return (Throwable)object;
        }
        return null;
    }

    public String getMessage() {
        Localizer localizer = new Localizer();
        return localizer.localize(this);
    }

    protected abstract String getDefaultResourceBundleName();

    public final String getKey() {
        return this.msg.getKey();
    }

    public final Object[] getArguments() {
        return this.msg.getArguments();
    }

    public final String getResourceBundleName() {
        return this.msg.getResourceBundleName();
    }
}

