/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.jobs;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpUtils {
    private static final boolean DEBUG = false;
    private static final String RES_URL = "http://share.xmind.net/_res/upload/mapfile/";

    private HttpUtils() {
    }

    private static void debug(String message) {
    }

    public static String[] prepareUpload(HttpClient client, String userName, String token, String title) throws HttpException, IOException, JSONException {
        HttpUtils.debug("[prepare upload] userName=" + userName + ", token=" + token + ", title=" + title);
        String postURL = HttpUtils.mergeUrl(userName);
        HttpUtils.debug("[prepare upload] url=" + postURL);
        PostMethod method = new PostMethod(postURL);
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        HttpUtils.setTokenAndJson((HttpMethod)method, token);
        method.setParameter("title", title);
        HttpUtils.debug("[prepare upload] execute 'post'");
        int result = client.executeMethod((HttpMethod)method);
        HttpUtils.debug("[prepare upload] result=" + result);
        if (result != 200) {
            throw new HttpException("Failed to upload a map to server");
        }
        String response = method.getResponseBodyAsString();
        HttpUtils.debug("[prepare upload] response=" + response);
        JSONObject json = new JSONObject(response);
        String[] data = new String[3];
        data[0] = json.getString("session");
        if (json.has("url")) {
            data[1] = json.getString("url");
        }
        if (json.has("mapname")) {
            data[2] = json.getString("mapname");
        }
        return data;
    }

    public static int uploadFile(HttpClient client, String userName, String session, Part[] parts) throws HttpException, IOException {
        PostMethod method = new PostMethod(HttpUtils.mergeUrl(userName, session));
        method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
        return client.executeMethod((HttpMethod)method);
    }

    public static double retrieveUploadingProcess(HttpClient client, String userName, String session, String token) throws HttpException, IOException, JSONException {
        GetMethod method = new GetMethod(HttpUtils.mergeUrl(userName, session));
        HttpUtils.setTokenAndJson((HttpMethod)method, token);
        if (200 == client.executeMethod((HttpMethod)method)) {
            JSONObject result = new JSONObject(method.getResponseBodyAsString());
            return result.getDouble("progress");
        }
        return -1.0;
    }

    public static void cancelUploading(HttpClient client, String userName, String session, String token) throws HttpException, IOException {
        DeleteMethod method = new DeleteMethod(HttpUtils.mergeUrl(userName, session));
        HttpUtils.setTokenAndJson((HttpMethod)method, token);
        client.executeMethod((HttpMethod)method);
    }

    private static void setTokenAndJson(HttpMethod method, String token) {
        method.setRequestHeader("AuthToken", token);
        method.setRequestHeader("accept", "application/json");
    }

    private static String mergeUrl(String ... paths) {
        StringBuilder sb = new StringBuilder(RES_URL.length() + paths.length * 10);
        sb.append(RES_URL);
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            sb.append(path);
            ++n2;
        }
        return sb.toString();
    }

    public static JSONObject testSignIn(HttpClient client, String email, String password) throws IOException, HttpException, JSONException {
        PostMethod method = new PostMethod("http://share.xmind.net/_res/upload/mapfile/sign-in");
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("email", email), new NameValuePair("password", password)};
        method.setRequestBody(data);
        method.setRequestHeader("accept", "application/json");
        client.executeMethod((HttpMethod)method);
        String body = method.getResponseBodyAsString();
        return new JSONObject(body);
    }

    public static String testSignIn() throws Exception {
        String email = "rz2@xmind.org";
        String password = "test";
        HttpClient client = new HttpClient();
        JSONObject user = HttpUtils.testSignIn(client, email, password);
        return user.getString("token");
    }
}

