/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.dialog;

import net.xmind.share.Messages;
import net.xmind.share.dialog.InfoField;
import net.xmind.share.dialog.RadioInfoFieldGroup;
import net.xmind.share.dialog.UploaderPage;
import net.xmind.signin.IVerifyListener;
import net.xmind.signin.XMindNetEntry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GeneralUploaderPage
extends UploaderPage
implements IVerifyListener {
    private InfoField titleField;
    private InfoField descriptionField;
    private RadioInfoFieldGroup privacyGroup;
    private Button privateButton;

    public GeneralUploaderPage() {
        this.setTitle(Messages.UploaderDialog_GeneralPage_title);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        this.titleField = new InfoField(false, true, true);
        this.titleField.fill(composite);
        this.titleField.setName(Messages.UploaderDialog_Title_text);
        this.titleField.setText(this.getInfo().getString("Title"));
        this.titleField.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralUploaderPage.this.getInfo().setProperty("Title", GeneralUploaderPage.this.titleField.getText());
            }
        });
        this.descriptionField = new InfoField(true, false, false);
        this.descriptionField.fill(composite);
        this.descriptionField.setName(Messages.UploaderDialog_Description_text);
        this.descriptionField.setText(this.getInfo().getString("Description"));
        this.descriptionField.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralUploaderPage.this.getInfo().setProperty("Description", GeneralUploaderPage.this.descriptionField.getText());
            }
        });
        this.privacyGroup = new RadioInfoFieldGroup(false);
        this.privacyGroup.fill(composite);
        this.privacyGroup.setName(Messages.UploaderDialog_Privacy_title);
        this.privacyGroup.addOption("1", Messages.UploaderDialog_Public_label);
        this.privacyGroup.addOption("0", Messages.UploaderDialog_PublicView_label);
        if (this.isPrivateVisible()) {
            this.privateButton = this.privacyGroup.addOption("2", Messages.UploaderDialog_Private_label);
            this.privateButton.setEnabled(this.isPrivateEnabled());
        }
        Object value = this.getPrivacyValue();
        this.setPrivacyValue(value);
        this.privacyGroup.setSelectedValue(value);
        this.privacyGroup.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GeneralUploaderPage.this.setPrivacyValue(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        this.setControl((Control)composite);
    }

    private boolean isPrivateVisible() {
        return Platform.getBundle((String)"org.xmind.meggy") != null;
    }

    private boolean isPrivateEnabled() {
        int code;
        IStatus validity = XMindNetEntry.getValidity();
        if (validity != null && (code = validity.getCode()) == 0) {
            return true;
        }
        XMindNetEntry.verify((IVerifyListener)this);
        return false;
    }

    private void setPrivacyValue(Object value) {
        this.getInfo().setProperty("Share/AllowDownload", value);
    }

    private Object getPrivacyValue() {
        Object value = this.getInfo().getProperty("Share/AllowDownload");
        if (value == null && (value = this.getContainer().getDialogSettings().get("Share/AllowDownload")) == null) {
            value = "1";
        }
        return value;
    }

    public void setFocus() {
        if (this.descriptionField != null && !this.descriptionField.isDisposed()) {
            this.descriptionField.setFocus();
        }
    }

    public void notifyValidity(IStatus validity) {
        int code;
        if (validity != null && (code = validity.getCode()) == 0 && this.privateButton != null && !this.privateButton.isDisposed()) {
            this.privateButton.setEnabled(true);
        }
    }
}

