/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;
    boolean open;
    int fontID;
    int fontSize;

    public FontDialog(Shell parent) {
        this(parent, 65536);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, FontDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    int fontProc(int nextHandler, int theEvent, int userData) {
        int kind = OS.GetEventKind(theEvent);
        block0 : switch (kind) {
            case 1: {
                this.open = false;
                break;
            }
            case 2: {
                RGBColor color;
                int[] actualSize;
                int[] fontSize;
                int[] fontID = new int[1];
                if (OS.GetEventParameter(theEvent, 1635084644, 1835100014, null, 4, null, fontID) == 0) {
                    this.fontID = fontID[0];
                }
                if (OS.GetEventParameter(theEvent, 1635087226, 1718188132, null, 4, null, fontSize = new int[1]) == 0) {
                    this.fontSize = fontSize[0];
                }
                if (OS.GetEventParameter(theEvent, 1717791858, 1666336578, null, 6, actualSize = new int[1], color = new RGBColor()) == 0) {
                    int red = color.red >> 8 & 0xFF;
                    int green = color.green >> 8 & 0xFF;
                    int blue = color.blue >> 8 & 0xFF;
                    this.rgb = new RGB(red, green, blue);
                    break;
                }
                int[] dict = new int[1];
                if (OS.GetEventParameter(theEvent, 1684628340, 0x63666463, null, 4, actualSize, dict) != 0) break;
                int[] attrib = new int[1];
                if (!OS.CFDictionaryGetValueIfPresent(dict[0], OS.kFontPanelAttributesKey(), attrib)) break;
                int[] tags = new int[1];
                int[] sizes = new int[1];
                int[] values = new int[1];
                if (!OS.CFDictionaryGetValueIfPresent(attrib[0], OS.kFontPanelAttributeTagsKey(), tags) || !OS.CFDictionaryGetValueIfPresent(attrib[0], OS.kFontPanelAttributeSizesKey(), sizes) || !OS.CFDictionaryGetValueIfPresent(attrib[0], OS.kFontPanelAttributeValuesKey(), values)) break;
                int count = OS.CFDataGetLength(tags[0]) / 4;
                int tagPtr = OS.CFDataGetBytePtr(tags[0]);
                int sizePtr = OS.CFDataGetBytePtr(sizes[0]);
                int[] tag = new int[1];
                int[] size = new int[1];
                int valueOffset = 0;
                int i = 0;
                while (i < count) {
                    OS.memmove(tag, tagPtr + i * 4, 4);
                    OS.memmove(size, sizePtr + i * 4, 4);
                    if (tag[0] == 263 && size[0] == 6) {
                        int valuePtr = OS.CFDataGetBytePtr(values[0]);
                        OS.memmove(color, valuePtr + valueOffset, 6);
                        int red = color.red >> 8 & 0xFF;
                        int green = color.green >> 8 & 0xFF;
                        int blue = color.blue >> 8 & 0xFF;
                        this.rgb = new RGB(red, green, blue);
                        break block0;
                    }
                    valueOffset = size[0];
                    ++i;
                }
                break;
            }
        }
        return 0;
    }

    public FontData open() {
        Display display;
        Display display2 = display = this.parent != null ? this.parent.display : Display.getCurrent();
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            int ptr = OS.NewPtr(4);
            OS.memmove(ptr, new int[]{font.atsuiStyle}, 4);
            OS.SetFontInfoForSelection(1634956396, 1, ptr, 0);
            OS.DisposePtr(ptr);
            font.dispose();
        }
        int[] mask = new int[]{1718578804, 2, 1718578804, 1};
        Callback fontPanelCallback = new Callback(this, "fontProc", 3);
        int fontPanelCallbackAddress = fontPanelCallback.getAddress();
        if (fontPanelCallbackAddress == 0) {
            SWT.error(3);
        }
        int appTarget = OS.GetApplicationEventTarget();
        int[] outRef = new int[1];
        OS.InstallEventHandler(appTarget, fontPanelCallbackAddress, mask.length / 2, mask, 0, outRef);
        this.fontID = 0;
        this.fontSize = 0;
        this.fontData = null;
        this.rgb = null;
        this.open = true;
        int count = 0;
        int window = OS.GetPreviousWindow(0);
        while (window != 0) {
            ++count;
            window = OS.GetPreviousWindow(window);
        }
        int[] windows = new int[count];
        boolean[] visible = new boolean[count];
        count = 0;
        window = OS.GetPreviousWindow(0);
        while (window != 0) {
            windows[count] = window;
            visible[count] = OS.IsWindowVisible(window);
            ++count;
            window = OS.GetPreviousWindow(window);
        }
        OS.FPShowHideFontPanel();
        int fontsWindow = 0;
        window = OS.GetPreviousWindow(0);
        while (window != 0 && fontsWindow == 0) {
            if (OS.IsWindowVisible(window)) {
                boolean found = false;
                int i = 0;
                while (i < windows.length) {
                    if (windows[i] == window) {
                        found = true;
                        if (!visible[i]) {
                            fontsWindow = window;
                            break;
                        }
                    }
                    ++i;
                }
                if (!found) {
                    fontsWindow = window;
                    break;
                }
            }
            window = OS.GetPreviousWindow(window);
        }
        if (fontsWindow != 0) {
            int inModalKind = 0;
            if ((this.style & 0x8000) != 0) {
                inModalKind = 3;
            }
            if ((this.style & 0x10000) != 0) {
                inModalKind = 2;
            }
            if ((this.style & 0x20000) != 0) {
                inModalKind = 1;
            }
            if (inModalKind != 0) {
                int inUnavailableWindow = 0;
                if (this.parent != null) {
                    inUnavailableWindow = OS.GetControlOwner(this.parent.handle);
                }
                OS.SetWindowModality(fontsWindow, inModalKind, inUnavailableWindow);
                OS.SelectWindow(fontsWindow);
            }
        }
        while (!this.parent.isDisposed() && this.open) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        OS.RemoveEventHandler(outRef[0]);
        fontPanelCallback.dispose();
        if (this.fontID != 0 && this.fontSize != 0) {
            int atsFont = OS.FMGetATSFontRefFromFont(this.fontID);
            Font font = Font.carbon_new(display, atsFont, (short)0, (float)OS.Fix2X(this.fontSize));
            this.fontData = font.getFontData()[0];
            font.dispose();
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

