/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CFRunLoopSourceContext;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.EventRecord;
import org.eclipse.swt.internal.carbon.GDevice;
import org.eclipse.swt.internal.carbon.HICommand;
import org.eclipse.swt.internal.carbon.MenuTrackingData;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    Event[] eventQueue;
    Callback actionCallback;
    Callback appleEventCallback;
    Callback clockCallback;
    Callback commandCallback;
    Callback controlCallback;
    Callback accessibilityCallback;
    Callback appearanceCallback;
    Callback drawItemCallback;
    Callback itemDataCallback;
    Callback itemNotificationCallback;
    Callback itemCompareCallback;
    Callback searchCallback;
    Callback trayItemCallback;
    Callback hitTestCallback;
    Callback keyboardCallback;
    Callback menuCallback;
    Callback mouseHoverCallback;
    Callback helpCallback;
    Callback observerCallback;
    Callback sourceCallback;
    Callback mouseCallback;
    Callback trackingCallback;
    Callback windowCallback;
    Callback colorCallback;
    Callback textInputCallback;
    Callback releaseCallback;
    Callback coreEventCallback;
    Callback pollingCallback;
    int actionProc;
    int appleEventProc;
    int clockProc;
    int commandProc;
    int controlProc;
    int appearanceProc;
    int accessibilityProc;
    int drawItemProc;
    int itemDataProc;
    int itemNotificationProc;
    int itemCompareProc;
    int helpProc;
    int searchProc;
    int trayItemProc;
    int hitTestProc;
    int keyboardProc;
    int menuProc;
    int mouseHoverProc;
    int observerProc;
    int sourceProc;
    int mouseProc;
    int trackingProc;
    int windowProc;
    int colorProc;
    int textInputProc;
    int releaseProc;
    int coreEventProc;
    int pollingProc;
    EventTable eventTable;
    EventTable filterTable;
    int queue;
    int runLoop;
    int runLoopSource;
    int runLoopObserver;
    int lastModifiers;
    int lastState;
    int lastX;
    int lastY;
    boolean disposing;
    boolean inPaint;
    boolean needsPaint;
    int gcWindow;
    int disposeWindow;
    int[] disposeWindowList;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    boolean runAsyncMessages = true;
    int freeSlot;
    int[] indexTable;
    int[] property;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT0 = 1937208368;
    Shell activeShell;
    int focusEvent;
    Control focusControl;
    Combo focusCombo;
    boolean ignoreFocus;
    boolean delayDispose;
    Shell[] modalShells;
    Menu menuBar;
    Menu[] menus;
    Menu[] popups;
    static final int ID_TEMPORARY = 1000;
    static final int ID_START = 1001;
    Runnable[] disposeList;
    Tray tray;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    boolean allowTimers = true;
    int pollingTimer;
    static final int POLLING_TIMEOUT = 10;
    Caret currentCaret;
    Callback caretCallback;
    int caretID;
    int caretProc;
    Control grabControl;
    int helpString;
    Widget helpWidget;
    int lastHelpX;
    int lastHelpY;
    int clickCount;
    int clickCountButton;
    Control currentControl;
    int mouseHoverID;
    boolean mouseMoved;
    int dragButton;
    int dragX;
    int dragY;
    int dragState;
    int dragModifiers;
    boolean dragging;
    Rect buttonInset;
    Rect tabFolderNorthInset;
    Rect tabFolderSouthInset;
    Rect comboInset;
    Rect editTextInset;
    Rect searchTextInset;
    boolean smallFonts;
    int kchrPtr;
    int[] kchrState = new int[1];
    Image errorImage;
    Image infoImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    boolean runSettings;
    RGBColor highlightColor;
    int dockImage;
    static int[][] KeyTable = new int[][]{{58, 65536}, {56, 131072}, {59, 262144}, {55, 0x400000}, {126, 0x1000001}, {125, 0x1000002}, {123, 0x1000003}, {124, 0x1000004}, {116, 0x1000005}, {121, 0x1000006}, {115, 0x1000007}, {119, 0x1000008}, {51, 8}, {36, 13}, {117, 127}, {53, 27}, {76, 10}, {48, 9}, {122, 0x100000A}, {120, 0x100000B}, {99, 0x100000C}, {118, 0x100000D}, {96, 0x100000E}, {97, 0x100000F}, {98, 0x1000010}, {100, 0x1000011}, {101, 0x1000012}, {109, 0x1000013}, {103, 0x1000014}, {111, 0x1000015}, {105, 0x1000016}, {107, 0x1000017}, {113, 0x1000018}, {67, 16777258}, {69, 16777259}, {76, 0x1000050}, {78, 16777261}, {65, 16777262}, {75, 16777263}, {82, 0x1000030}, {83, 0x1000031}, {84, 16777266}, {85, 0x1000033}, {86, 16777268}, {87, 16777269}, {88, 16777270}, {89, 16777271}, {91, 16777272}, {92, 16777273}, {81, 16777277}, {71, 16777299}, {114, 0x1000051}};
    static String APP_NAME = "SWT";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static Display Default;
    static Display[] Displays;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    Object data;
    String[] keys;
    Object[] values;
    static /* synthetic */ Class class$0;

    static {
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    static byte[] ascii(String name) {
        int length = name.length();
        char[] chars = new char[length];
        name.getChars(0, length, chars, 0);
        byte[] buffer = new byte[length + 1];
        int i = 0;
        while (i < length) {
            buffer[i] = (byte)chars[i];
            ++i;
        }
        return buffer;
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    int actionProc(int theControl, int partCode) {
        Widget widget = this.getWidget(theControl);
        if (widget != null) {
            return widget.actionProc(theControl, partCode);
        }
        return 0;
    }

    int appearanceProc(int theAppleEvent, int reply, int handlerRefcon) {
        this.runSettings = true;
        this.wakeThread();
        return -9874;
    }

    int appleEventProc(int nextHandler, int theEvent, int userData) {
        int eventClass = OS.GetEventClass(theEvent);
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventClass) {
            case 1634758764: {
                switch (eventKind) {
                    case 110: {
                        if (this.dockImage == 0) break;
                        int[] reason = new int[1];
                        OS.GetEventParameter(theEvent, 2003335487, 1835100014, null, 4, null, reason);
                        if (reason[0] != 1) break;
                        OS.SetApplicationDockTileImage(this.dockImage);
                    }
                }
                break;
            }
            case 1701867619: {
                EventRecord eventRecord = new EventRecord();
                boolean release = false;
                if (OS.IsEventInQueue(this.queue, theEvent)) {
                    OS.RetainEvent(theEvent);
                    release = true;
                    OS.RemoveEventFromQueue(this.queue, theEvent);
                }
                OS.ConvertEventRefToEventRecord(theEvent, eventRecord);
                OS.AEProcessAppleEvent(eventRecord);
                if (!release) break;
                OS.ReleaseEvent(theEvent);
            }
        }
        return -9874;
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[12];
        }
        int i = 0;
        while (i < this.menus.length) {
            if (this.menus[i] == null) {
                menu.id = (short)(1001 + i);
                this.menus[i] = menu;
                return;
            }
            ++i;
        }
        Menu[] newMenus = new Menu[this.menus.length + 12];
        menu.id = (short)(1001 + this.menus.length);
        newMenus[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, newMenus, 0, this.menus.length);
        this.menus = newMenus;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addToDisposeWindow(int control) {
        int[] root = new int[1];
        if (this.disposeWindow == 0) {
            int[] outWindow = new int[1];
            OS.CreateNewWindow(14, 0, new Rect(), outWindow);
            this.disposeWindow = outWindow[0];
            OS.CreateRootControl(this.disposeWindow, root);
        } else {
            OS.GetRootControl(this.disposeWindow, root);
        }
        OS.EmbedControl(control, root[0]);
    }

    void addWidget(int handle, Widget widget) {
        if (handle == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            int length = this.freeSlot + 1024;
            int[] newIndexTable = new int[length];
            Widget[] newWidgetTable = new Widget[length];
            System.arraycopy(this.indexTable, 0, newIndexTable, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, newWidgetTable, 0, this.freeSlot);
            int i = this.freeSlot;
            while (i < length - 1) {
                newIndexTable[i] = i + 1;
                ++i;
            }
            newIndexTable[length - 1] = -1;
            this.indexTable = newIndexTable;
            this.widgetTable = newWidgetTable;
        }
        this.property[0] = this.freeSlot + 1;
        OS.SetControlProperty(handle, 1937208368, 1937208368, 4, this.property);
        int oldSlot = this.freeSlot;
        this.freeSlot = this.indexTable[oldSlot];
        this.indexTable[oldSlot] = -2;
        this.widgetTable[oldSlot] = widget;
    }

    void addDisposeWindow(int window) {
        if (this.disposeWindowList == null) {
            this.disposeWindowList = new int[4];
        }
        int length = this.disposeWindowList.length;
        int i = 0;
        while (i < length) {
            if (this.disposeWindowList[i] == window) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.disposeWindowList[index] == 0) break;
            ++index;
        }
        if (index == length) {
            int[] newList = new int[length + 4];
            System.arraycopy(this.disposeWindowList, 0, newList, 0, length);
            this.disposeWindowList = newList;
        }
        this.disposeWindowList[index] = window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        this.checkDevice();
        OS.SysBeep((short)100);
    }

    int caretProc(int id, int clientData) {
        if (this.currentCaret == null || this.currentCaret.isDisposed()) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int blinkRate = this.currentCaret.blinkRate;
            if (blinkRate == 0) {
                return 0;
            }
            OS.SetEventLoopTimerNextFireTime(id, (double)blinkRate / 1000.0);
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) break;
            if (this.modalShells[index] == null) {
                return;
            }
            ++index;
        }
        if (index == length) {
            return;
        }
        System.arraycopy(this.modalShells, index + 1, this.modalShells, index, --length - index);
        this.modalShells[length] = null;
        if (index == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    int[] createImage(int type) {
        int[] ref = new int[1];
        int result = OS.GetIconRef((short)Short.MIN_VALUE, 1835098995, type, ref);
        if (result != 0) {
            return null;
        }
        int[] family = new int[1];
        result = OS.IconRefToIconFamily(ref[0], -1, family);
        OS.ReleaseIconRef(ref[0]);
        if (result != 0) {
            return null;
        }
        int[] image = this.createImageFromFamily(family[0], 1768698674, 1815637355, 32, 32);
        OS.DisposeHandle(family[0]);
        return image;
    }

    int[] createImageFromFamily(int family, int type, int maskType, int width, int height) {
        int dataHandle = OS.NewHandle(0);
        int result = OS.GetIconFamilyData(family, type, dataHandle);
        if (result != 0) {
            OS.DisposeHandle(dataHandle);
            return null;
        }
        int maskHandle = OS.NewHandle(0);
        result = OS.GetIconFamilyData(family, maskType, maskHandle);
        if (result != 0) {
            OS.DisposeHandle(maskHandle);
            OS.DisposeHandle(dataHandle);
            return null;
        }
        int bpr = width * 4;
        int dataSize = OS.GetHandleSize(dataHandle);
        int data = OS.NewPtrClear(dataSize);
        if (data == 0) {
            OS.DisposeHandle(maskHandle);
            OS.DisposeHandle(dataHandle);
            return null;
        }
        OS.HLock(dataHandle);
        OS.HLock(maskHandle);
        int[] iconPtr = new int[1];
        int[] maskPtr = new int[1];
        OS.memmove(iconPtr, dataHandle, 4);
        OS.memmove(maskPtr, maskHandle, 4);
        OS.memmove(data, iconPtr[0], dataSize);
        int pixelCount = dataSize / 4;
        int i = 0;
        while (i < pixelCount) {
            OS.memmove(data + i * 4, maskPtr[0] + i, 1);
            ++i;
        }
        OS.HUnlock(maskHandle);
        OS.HUnlock(dataHandle);
        OS.DisposeHandle(maskHandle);
        OS.DisposeHandle(dataHandle);
        int provider = OS.CGDataProviderCreateWithData(0, data, dataSize, this.releaseProc);
        if (provider == 0) {
            OS.DisposePtr(data);
            return null;
        }
        int colorspace = OS.CGColorSpaceCreateDeviceRGB();
        if (colorspace == 0) {
            OS.CGDataProviderRelease(provider);
            return null;
        }
        int cgImage = OS.CGImageCreate(width, height, 8, 32, bpr, colorspace, 4, provider, null, true, 0);
        OS.CGColorSpaceRelease(colorspace);
        OS.CGDataProviderRelease(provider);
        return new int[]{cgImage, data};
    }

    int createOverlayWindow() {
        int gdevice = OS.GetMainDevice();
        int[] ptr = new int[1];
        OS.memmove(ptr, gdevice, 4);
        GDevice device = new GDevice();
        OS.memmove(device, ptr[0], 62);
        Rect rect = new Rect();
        OS.SetRect(rect, device.left, device.top, device.right, device.bottom);
        int[] outWindow = new int[1];
        OS.CreateNewWindow(14, 0, rect, outWindow);
        if (outWindow[0] == 0) {
            SWT.error(2);
        }
        return outWindow[0];
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean multiple) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] != null) {
                    if (!multiple) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[i].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    int colorProc(int inControl, int inMessage, int inDrawDepth, int inDrawInColor) {
        Widget widget = this.getWidget(inControl);
        if (widget != null) {
            return widget.colorProc(inControl, inMessage, inDrawDepth, inDrawInColor);
        }
        return -9874;
    }

    int commandProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        HICommand command = new HICommand();
        OS.GetEventParameter(theEvent, 0x2D2D2D2D, 1751346532, null, 14, null, command);
        switch (eventKind) {
            case 1: {
                if ((command.attributes & 1) == 0) break;
                if (userData != 0) {
                    Widget widget = this.getWidget(userData);
                    if (widget == null) break;
                    return widget.commandProc(nextHandler, theEvent, userData);
                }
                int result = -9874;
                int menuRef = command.menu_menuRef;
                short menuID = OS.GetMenuID(menuRef);
                Menu menu = this.getMenu(menuID);
                if (menu != null) {
                    MenuItem item = null;
                    item = menu.closed && menu.modified ? menu.lastTarget : menu.getItem(command.menu_menuItemIndex - 1);
                    if (item != null) {
                        result = item.kEventProcessCommand(nextHandler, theEvent, userData);
                    }
                }
                OS.HiliteMenu((short)0);
                return result;
            }
        }
        return -9874;
    }

    Rect computeInset(int control) {
        int tempRgn = OS.NewRgn();
        Rect rect = new Rect();
        OS.GetControlRegion(control, (short)-1, tempRgn);
        OS.GetControlBounds(control, rect);
        Rect rgnRect = new Rect();
        OS.GetRegionBounds(tempRgn, rgnRect);
        OS.DisposeRgn(tempRgn);
        rect.left = (short)(rect.left - rgnRect.left);
        rect.top = (short)(rect.top - rgnRect.top);
        rect.right = (short)(rgnRect.right - rect.right);
        rect.bottom = (short)(rgnRect.bottom - rect.bottom);
        return rect;
    }

    int clockProc(int nextHandler, int theEvent, int userData) {
        Widget widget = this.getWidget(userData);
        if (widget != null) {
            return widget.clockProc(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    int controlProc(int nextHandler, int theEvent, int userData) {
        Widget widget = this.getWidget(userData);
        if (widget != null) {
            return widget.controlProc(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    int coreEventProc(int theAppleEvent, int reply, int handlerRefcon) {
        if (!this.disposing) {
            Event event = new Event();
            this.sendEvent(21, event);
            if (event.doit) {
                this.dispose();
            } else {
                return -128;
            }
        }
        return 0;
    }

    int accessibilityProc(int nextHandler, int theEvent, int userData) {
        Widget widget = this.getWidget(userData);
        if (widget != null) {
            return widget.accessibilityProc(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    static String convertToLf(String text) {
        char Cr = '\r';
        char Lf = '\n';
        int length = text.length();
        if (length == 0) {
            return text;
        }
        int i = text.indexOf(Lf, 0);
        if (i == -1 || i == 0) {
            return text;
        }
        if (text.charAt(i - 1) != Cr) {
            return text;
        }
        i = 0;
        StringBuffer result = new StringBuffer();
        while (i < length) {
            int j = text.indexOf(Cr, i);
            if (j == -1) {
                j = length;
            }
            String s = text.substring(i, j);
            result.append(s);
            i = j + 2;
            result.append(Lf);
        }
        return result.toString();
    }

    void clearMenuFlags() {
        if (this.menus == null) {
            return;
        }
        int i = 0;
        while (i < this.menus.length) {
            Menu menu = this.menus[i];
            if (menu != null) {
                menu.closed = false;
                menu.modified = false;
                menu.lastTarget = null;
            }
            ++i;
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
        int[] psn;
        if (OS.VERSION < 4144) {
            System.out.println("***WARNING: SWT requires MacOS X version 10.3 or greater");
            System.out.println("***WARNING: Detected: " + Integer.toHexString((OS.VERSION & 0xFF00) >> 8) + "." + Integer.toHexString((OS.VERSION & 0xF0) >> 4) + "." + Integer.toHexString(OS.VERSION & 0xF));
        }
        if (OS.GetCurrentProcess(psn = new int[2]) == 0) {
            int image;
            int pid = OS.getpid();
            byte[] buffer = null;
            int ptr = OS.getenv(Display.ascii("APP_NAME_" + pid));
            if (ptr != 0) {
                buffer = new byte[OS.strlen(ptr) + 1];
                OS.memmove(buffer, ptr, buffer.length);
            } else if (APP_NAME != null) {
                char[] chars = new char[APP_NAME.length()];
                APP_NAME.getChars(0, chars.length, chars, 0);
                int cfstring = OS.CFStringCreateWithCharacters(0, chars, chars.length);
                if (cfstring != 0) {
                    int[] size;
                    CFRange range = new CFRange();
                    range.length = chars.length;
                    int encoding = OS.CFStringGetSystemEncoding();
                    int numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, null, 0, size = new int[1]);
                    if (numChars != 0) {
                        buffer = new byte[size[0] + 1];
                        numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, buffer, size[0], size);
                    }
                    OS.CFRelease(cfstring);
                }
            }
            if (buffer != null) {
                OS.CPSSetProcessName(psn, buffer);
            }
            OS.CPSEnableForegroundOperation(psn, 3, 60, 44, 4355);
            OS.SetFrontProcess(psn);
            ptr = OS.getenv(Display.ascii("APP_ICON_" + pid));
            if (ptr != 0 && (image = this.readImageRef(ptr)) != 0) {
                this.dockImage = image;
                OS.SetApplicationDockTileImage(this.dockImage);
            }
        }
        OS.ClearMenuBar();
        this.queue = OS.GetCurrentEventQueue();
        this.runLoop = OS.GetCFRunLoopFromEventLoop(OS.GetCurrentEventLoop());
        OS.TXNInitTextension(0, 0, 0);
        OS.RegisterAppearanceClient();
        this.highlightColor = new RGBColor();
        OS.GetThemeBrushAsColor((short)-3, (short)this.getDepth(), true, this.highlightColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (display == Displays[i]) {
                    Display.Displays[i] = null;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    int drawItemProc(int browser, int item, int property, int itemState, int theRect, int gdDepth, int colorDevice) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.drawItemProc(browser, item, property, itemState, theRect, gdDepth, colorDevice);
        }
        return 0;
    }

    void disposeWindows() {
        if (this.disposeWindow != 0) {
            OS.DisposeWindow(this.disposeWindow);
            this.disposeWindow = 0;
        }
        if (this.disposeWindowList != null) {
            int i = 0;
            while (i < this.disposeWindowList.length) {
                if (this.disposeWindowList[i] != 0) {
                    OS.DisposeWindow(this.disposeWindowList[i]);
                }
                ++i;
            }
            this.disposeWindowList = null;
        }
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(int handle, int id) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, int id) {
        this.checkDevice();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                Display display = Displays[i];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public Shell getActiveShell() {
        boolean[] result;
        int[] psn2;
        this.checkDevice();
        int[] psn1 = new int[2];
        if (OS.GetCurrentProcess(psn1) == 0 && OS.GetFrontProcess(psn2 = new int[2]) == 0 && OS.SameProcess(psn1, psn2, result = new boolean[1]) == 0 && !result[0]) {
            return null;
        }
        if (this.activeShell != null && !this.activeShell.isDisposed()) {
            return this.activeShell;
        }
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget != null && widget instanceof Shell) {
                Shell shell = (Shell)widget;
                if (OS.IsWindowActive(shell.shellHandle)) {
                    return shell;
                }
            }
            ++i;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int gdevice = OS.GetDeviceList();
        if (gdevice == 0 || OS.GetNextDevice(gdevice) == 0) {
            return super.getBounds();
        }
        Monitor[] monitors = this.getMonitors();
        Rectangle rect = monitors[0].getBounds();
        int i = 1;
        while (i < monitors.length) {
            rect = rect.union(monitors[i].getBounds());
            ++i;
        }
        return rect;
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        return OS.GetCaretTime() * 1000 / 60;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        int gdevice = OS.GetDeviceList();
        if (gdevice == 0 || OS.GetNextDevice(gdevice) == 0) {
            return super.getClientArea();
        }
        Monitor[] monitors = this.getMonitors();
        Rectangle rect = monitors[0].getBounds();
        int i = 1;
        while (i < monitors.length) {
            rect = rect.union(monitors[i].getBounds());
            ++i;
        }
        return rect;
    }

    public Control getCursorControl() {
        Widget widget;
        this.checkDevice();
        Point where = new Point();
        OS.GetGlobalMouse(where);
        int[] theWindow = new int[1];
        if (OS.FindWindow(where, theWindow) != 3) {
            return null;
        }
        if (theWindow[0] == 0) {
            return null;
        }
        Rect rect = new Rect();
        OS.GetWindowBounds(theWindow[0], (short)33, rect);
        CGPoint inPoint = new CGPoint();
        inPoint.x = where.h - rect.left;
        inPoint.y = where.v - rect.top;
        int[] theRoot = new int[1];
        OS.GetRootControl(theWindow[0], theRoot);
        int[] theControl = new int[1];
        int[] event = new int[1];
        OS.CreateEvent(0, 1836021107, 1, 0.0, 0, event);
        OS.SetEventParameter(event[0], 2003660661, 1751740532, 8, inPoint);
        OS.HIViewGetViewForMouseEvent(theRoot[0], event[0], theControl);
        OS.ReleaseEvent(event[0]);
        while (theControl[0] != 0 && !OS.IsControlEnabled(theControl[0])) {
            OS.GetSuperControl(theControl[0], theControl);
        }
        if (theControl[0] != 0) {
            do {
                Control control;
                if ((widget = this.getWidget(theControl[0])) != null && widget instanceof Control && (control = (Control)widget).isEnabled()) {
                    return control.isEnabledModal() ? control : null;
                }
                OS.GetSuperControl(theControl[0], theControl);
            } while (theControl[0] != 0);
        }
        if ((widget = this.getWidget(theRoot[0])) != null && widget instanceof Control) {
            return (Control)widget;
        }
        return null;
    }

    public org.eclipse.swt.graphics.Point getCursorLocation() {
        this.checkDevice();
        Point pt = new Point();
        OS.GetGlobalMouse(pt);
        return new org.eclipse.swt.graphics.Point(pt.h, pt.v);
    }

    public org.eclipse.swt.graphics.Point[] getCursorSizes() {
        this.checkDevice();
        return new org.eclipse.swt.graphics.Point[]{new org.eclipse.swt.graphics.Point(16, 16)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDblTime() * 1000 / 60;
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        int theWindow = OS.GetUserFocusWindow();
        if (theWindow == 0) {
            return null;
        }
        return this.getFocusControl(theWindow, false);
    }

    Control getFocusControl(int window, boolean disabled) {
        int[] theControl = new int[1];
        OS.GetKeyboardFocus(window, theControl);
        if (theControl[0] == 0) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(theControl[0])) != null && widget instanceof Control) {
                Control control = (Control)widget;
                if (disabled) {
                    return control;
                }
                return control.isEnabled() ? control : null;
            }
            OS.GetSuperControl(theControl[0], theControl);
        } while (theControl[0] != 0);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public org.eclipse.swt.graphics.Point[] getIconSizes() {
        this.checkDevice();
        return new org.eclipse.swt.graphics.Point[]{new org.eclipse.swt.graphics.Point(16, 16), new org.eclipse.swt.graphics.Point(32, 32), new org.eclipse.swt.graphics.Point(64, 64), new org.eclipse.swt.graphics.Point(128, 128)};
    }

    int getLastEventTime() {
        return (int)System.currentTimeMillis();
    }

    Menu[] getMenus(Decorations shell) {
        if (this.menus == null) {
            return new Menu[0];
        }
        int count = 0;
        int i = 0;
        while (i < this.menus.length) {
            Menu menu = this.menus[i];
            if (menu != null && menu.parent == shell) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Menu[] result = new Menu[count];
        int i2 = 0;
        while (i2 < this.menus.length) {
            Menu menu = this.menus[i2];
            if (menu != null && menu.parent == shell) {
                result[index++] = menu;
            }
            ++i2;
        }
        return result;
    }

    Menu getMenu(int id) {
        if (this.menus == null) {
            return null;
        }
        int index = id - 1001;
        if (index >= 0 && index < this.menus.length) {
            return this.menus[index];
        }
        return null;
    }

    Menu getMenuBar() {
        return this.menuBar;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    public Monitor[] getMonitors() {
        Monitor[] newMonitors;
        this.checkDevice();
        int count = 0;
        Monitor[] monitors = new Monitor[1];
        Rect rect = new Rect();
        GDevice device = new GDevice();
        int gdevice = OS.GetDeviceList();
        while (gdevice != 0) {
            if (count >= monitors.length) {
                newMonitors = new Monitor[monitors.length + 4];
                System.arraycopy(monitors, 0, newMonitors, 0, monitors.length);
                monitors = newMonitors;
            }
            Monitor monitor = new Monitor();
            monitor.handle = gdevice;
            int[] ptr = new int[1];
            OS.memmove(ptr, gdevice, 4);
            OS.memmove(device, ptr[0], 62);
            monitor.x = device.left;
            monitor.y = device.top;
            monitor.width = device.right - device.left;
            monitor.height = device.bottom - device.top;
            OS.GetAvailableWindowPositioningBounds(gdevice, rect);
            monitor.clientX = rect.left;
            monitor.clientY = rect.top;
            monitor.clientWidth = rect.right - rect.left;
            monitor.clientHeight = rect.bottom - rect.top;
            monitors[count++] = monitor;
            gdevice = OS.GetNextDevice(gdevice);
        }
        if (count < monitors.length) {
            newMonitors = new Monitor[count];
            System.arraycopy(monitors, 0, newMonitors, 0, count);
            monitors = newMonitors;
        }
        return monitors;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        int gdevice = OS.GetMainDevice();
        Monitor monitor = new Monitor();
        monitor.handle = gdevice;
        int[] ptr = new int[1];
        OS.memmove(ptr, gdevice, 4);
        GDevice device = new GDevice();
        OS.memmove(device, ptr[0], 62);
        monitor.x = device.left;
        monitor.y = device.top;
        monitor.width = device.right - device.left;
        monitor.height = device.bottom - device.top;
        Rect rect = new Rect();
        OS.GetAvailableWindowPositioningBounds(gdevice, rect);
        monitor.clientX = rect.left;
        monitor.clientY = rect.top;
        monitor.clientWidth = rect.right - rect.left;
        monitor.clientHeight = rect.bottom - rect.top;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int index = 0;
        Shell[] result = new Shell[16];
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget != null && widget instanceof Shell) {
                int j = 0;
                while (j < index) {
                    if (result[j] == widget) break;
                    ++j;
                }
                if (j == index) {
                    if (index == result.length) {
                        Shell[] newResult = new Shell[index + 16];
                        System.arraycopy(result, 0, newResult, 0, index);
                        result = newResult;
                    }
                    result[index++] = (Shell)widget;
                }
            }
            ++i;
        }
        if (index == result.length) {
            return result;
        }
        Shell[] newResult = new Shell[index];
        System.arraycopy(result, 0, newResult, 0, index);
        return newResult;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        RGBColor rgb = new RGBColor();
        switch (id) {
            case 28: {
                return super.getSystemColor(2);
            }
            case 29: {
                return Color.carbon_new(this, new float[]{1.0f, 1.0f, 0.88235295f, 1.0f});
            }
            case 30: {
                OS.GetThemeTextColor((short)23, (short)this.getDepth(), true, rgb);
                break;
            }
            case 31: {
                OS.GetThemeBrushAsColor((short)-5, (short)this.getDepth(), true, rgb);
                break;
            }
            case 32: {
                OS.GetThemeBrushAsColor((short)-3, (short)this.getDepth(), true, rgb);
                break;
            }
            case 33: {
                OS.GetThemeTextColor((short)24, (short)this.getDepth(), true, rgb);
                break;
            }
            case 34: {
                OS.GetThemeBrushAsColor((short)-4, (short)this.getDepth(), true, rgb);
                break;
            }
            case 35: {
                OS.GetThemeBrushAsColor((short)-4, (short)this.getDepth(), true, rgb);
                break;
            }
            case 17: {
                return Color.carbon_new(this, new float[]{0.2f, 0.2f, 0.2f, 1.0f});
            }
            case 18: {
                return Color.carbon_new(this, new float[]{0.4f, 0.4f, 0.4f, 1.0f});
            }
            case 19: {
                return Color.carbon_new(this, new float[]{0.6f, 0.6f, 0.6f, 1.0f});
            }
            case 20: {
                return Color.carbon_new(this, new float[]{0.8f, 0.8f, 0.8f, 1.0f});
            }
            case 22: {
                OS.GetThemeBrushAsColor((short)(OS.VERSION < 4176 ? 29 : 36), (short)this.getDepth(), true, rgb);
                break;
            }
            case 21: {
                OS.GetThemeTextColor((short)12, (short)this.getDepth(), true, rgb);
                break;
            }
            case 23: {
                return super.getSystemColor(2);
            }
            case 24: {
                OS.GetThemeTextColor((short)22, (short)this.getDepth(), true, rgb);
                break;
            }
            case 25: {
                OS.GetThemeBrushAsColor((short)10, (short)this.getDepth(), true, rgb);
                break;
            }
            case 27: {
                OS.GetThemeTextColor((short)22, (short)this.getDepth(), true, rgb);
                break;
            }
            case 26: {
                OS.GetThemeBrushAsColor((short)-3, (short)this.getDepth(), true, rgb);
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        float red = (float)(rgb.red >> 8 & 0xFF) / 255.0f;
        float green = (float)(rgb.green >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb.blue >> 8 & 0xFF) / 255.0f;
        return Color.carbon_new(this, new float[]{red, green, blue, 1.0f});
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        if (id < 0 || id >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id] == null) {
            this.cursors[id] = new Cursor(this, id);
        }
        return this.cursors[id];
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        switch (id) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                int[] image = this.createImage(1937010544);
                if (image == null) break;
                this.errorImage = Image.carbon_new(this, 1, image[0], image[1]);
                return this.errorImage;
            }
            case 2: 
            case 4: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                int[] image = this.createImage(1852798053);
                if (image == null) break;
                this.infoImage = Image.carbon_new(this, 1, image[0], image[1]);
                return this.infoImage;
            }
            case 8: {
                if (this.warningImage != null) {
                    return this.warningImage;
                }
                int[] image = this.createImage(1667331444);
                if (image == null) break;
                this.warningImage = Image.carbon_new(this, 1, image[0], image[1]);
                return this.warningImage;
            }
        }
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    Widget getWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        this.property[0] = 0;
        OS.GetControlProperty(handle, 1937208368, 1937208368, 4, null, this.property);
        int index = this.property[0] - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            return this.widgetTable[index];
        }
        return null;
    }

    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        Widget widget = this.getWidget(inControl);
        if (widget != null) {
            return widget.helpProc(inControl, inGlobalMouse, inRequest, outContentProvided, ioHelpContent);
        }
        return -9874;
    }

    int hitTestProc(int browser, int item, int property, int theRect, int mouseRect) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.hitTestProc(browser, item, property, theRect, mouseRect);
        }
        return 0;
    }

    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeInsets();
        this.initializeWidgetTable();
        this.initializeFonts();
    }

    void initializeCallbacks() {
        this.actionCallback = new Callback(this, "actionProc", 2);
        this.actionProc = this.actionCallback.getAddress();
        if (this.actionProc == 0) {
            this.error(3);
        }
        this.appleEventCallback = new Callback(this, "appleEventProc", 3);
        this.appleEventProc = this.appleEventCallback.getAddress();
        if (this.appleEventProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 2);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.clockCallback = new Callback(this, "clockProc", 3);
        this.clockProc = this.clockCallback.getAddress();
        if (this.clockProc == 0) {
            this.error(3);
        }
        this.commandCallback = new Callback(this, "commandProc", 3);
        this.commandProc = this.commandCallback.getAddress();
        if (this.commandProc == 0) {
            this.error(3);
        }
        this.controlCallback = new Callback(this, "controlProc", 3);
        this.controlProc = this.controlCallback.getAddress();
        if (this.controlProc == 0) {
            this.error(3);
        }
        this.accessibilityCallback = new Callback(this, "accessibilityProc", 3);
        this.accessibilityProc = this.accessibilityCallback.getAddress();
        if (this.accessibilityProc == 0) {
            this.error(3);
        }
        this.drawItemCallback = new Callback(this, "drawItemProc", 7);
        this.drawItemProc = this.drawItemCallback.getAddress();
        if (this.drawItemProc == 0) {
            this.error(3);
        }
        this.itemCompareCallback = new Callback(this, "itemCompareProc", 4);
        this.itemCompareProc = this.itemCompareCallback.getAddress();
        if (this.itemCompareProc == 0) {
            this.error(3);
        }
        this.itemDataCallback = new Callback(this, "itemDataProc", 5);
        this.itemDataProc = this.itemDataCallback.getAddress();
        if (this.itemDataProc == 0) {
            this.error(3);
        }
        this.itemNotificationCallback = new Callback(this, "itemNotificationProc", 3);
        this.itemNotificationProc = this.itemNotificationCallback.getAddress();
        if (this.itemNotificationProc == 0) {
            this.error(3);
        }
        this.helpCallback = new Callback(this, "helpProc", 5);
        this.helpProc = this.helpCallback.getAddress();
        if (this.helpProc == 0) {
            this.error(3);
        }
        this.hitTestCallback = new Callback(this, "hitTestProc", 5);
        this.hitTestProc = this.hitTestCallback.getAddress();
        if (this.hitTestProc == 0) {
            this.error(3);
        }
        this.keyboardCallback = new Callback(this, "keyboardProc", 3);
        this.keyboardProc = this.keyboardCallback.getAddress();
        if (this.keyboardProc == 0) {
            this.error(3);
        }
        this.menuCallback = new Callback(this, "menuProc", 3);
        this.menuProc = this.menuCallback.getAddress();
        if (this.menuProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 2);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.mouseCallback = new Callback(this, "mouseProc", 3);
        this.mouseProc = this.mouseCallback.getAddress();
        if (this.mouseProc == 0) {
            this.error(3);
        }
        this.timerCallback = new Callback(this, "timerProc", 2);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.trackingCallback = new Callback(this, "trackingProc", 6);
        this.trackingProc = this.trackingCallback.getAddress();
        if (this.trackingProc == 0) {
            this.error(3);
        }
        this.windowCallback = new Callback(this, "windowProc", 3);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.colorCallback = new Callback(this, "colorProc", 4);
        this.colorProc = this.colorCallback.getAddress();
        if (this.colorProc == 0) {
            this.error(3);
        }
        this.textInputCallback = new Callback(this, "textInputProc", 3);
        this.textInputProc = this.textInputCallback.getAddress();
        if (this.textInputProc == 0) {
            this.error(3);
        }
        this.appearanceCallback = new Callback(this, "appearanceProc", 3);
        this.appearanceProc = this.appearanceCallback.getAddress();
        if (this.appearanceProc == 0) {
            this.error(3);
        }
        this.trayItemCallback = new Callback(this, "trayItemProc", 4);
        this.trayItemProc = this.trayItemCallback.getAddress();
        if (this.trayItemProc == 0) {
            this.error(3);
        }
        this.observerCallback = new Callback(this, "observerProc", 3);
        this.observerProc = this.observerCallback.getAddress();
        if (this.observerProc == 0) {
            this.error(3);
        }
        this.sourceCallback = new Callback(this, "sourceProc", 1);
        this.sourceProc = this.sourceCallback.getAddress();
        if (this.sourceProc == 0) {
            this.error(3);
        }
        this.searchCallback = new Callback(this, "searchProc", 3);
        this.searchProc = this.searchCallback.getAddress();
        if (this.searchProc == 0) {
            this.error(3);
        }
        this.releaseCallback = new Callback(this, "releaseDataProc", 3);
        this.releaseProc = this.releaseCallback.getAddress();
        if (this.releaseProc == 0) {
            SWT.error(3);
        }
        this.coreEventCallback = new Callback(this, "coreEventProc", 3);
        this.coreEventProc = this.coreEventCallback.getAddress();
        if (this.coreEventProc == 0) {
            SWT.error(3);
        }
        this.pollingCallback = new Callback(this, "pollingProc", 2);
        this.pollingProc = this.pollingCallback.getAddress();
        if (this.pollingProc == 0) {
            SWT.error(3);
        }
        int[] mask1 = new int[]{1668113523, 1};
        int appTarget = OS.GetApplicationEventTarget();
        OS.InstallEventHandler(appTarget, this.commandProc, mask1.length / 2, mask1, 0, null);
        int[] mask2 = new int[]{1836021107, 1, 1836021107, 6, 1836021107, 5, 1836021107, 2, 1836021107, 10};
        OS.InstallEventHandler(appTarget, this.mouseProc, mask2.length / 2, mask2, 0, null);
        int[] mask3 = new int[]{1634758764, 110, 1701867619, 1};
        OS.InstallEventHandler(appTarget, this.appleEventProc, mask3.length / 2, mask3, 0, null);
        OS.AEInstallEventHandler(1634039412, 1903520116, this.coreEventProc, 0, false);
        int[] mask4 = new int[]{1801812322, 1, 1801812322, 4, 1801812322, 2, 1801812322, 3};
        int focusTarget = OS.GetUserFocusEventTarget();
        OS.InstallEventHandler(focusTarget, this.keyboardProc, mask4.length / 2, mask4, 0, null);
        int[] mask5 = new int[]{1952807028, 2, 1952807028, 1, 1952807028, 3, 1952807028, 4, 1952807028, 6};
        OS.InstallEventHandler(focusTarget, this.textInputProc, mask5.length / 2, mask5, 0, null);
        OS.AEInstallEventHandler(1634758770, 1953000805, this.appearanceProc, 0, false);
        OS.AEInstallEventHandler(1634758770, 1936942702, this.appearanceProc, 0, false);
        OS.AEInstallEventHandler(1634758770, 1937339238, this.appearanceProc, 0, false);
        OS.AEInstallEventHandler(1634758770, 1986424436, this.appearanceProc, 0, false);
        int mode = OS.kCFRunLoopCommonModes();
        int activities = 32;
        this.runLoopObserver = OS.CFRunLoopObserverCreate(0, activities, true, 0, this.observerProc, 0);
        if (this.runLoopObserver == 0) {
            this.error(2);
        }
        OS.CFRunLoopAddObserver(this.runLoop, this.runLoopObserver, mode);
        CFRunLoopSourceContext context = new CFRunLoopSourceContext();
        context.version = 0;
        context.perform = this.sourceProc;
        this.runLoopSource = OS.CFRunLoopSourceCreate(0, 0, context);
        if (this.runLoopSource == 0) {
            this.error(2);
        }
        OS.CFRunLoopAddSource(this.runLoop, this.runLoopSource, mode);
    }

    void initializeFonts() {
        this.smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
    }

    void initializeInsets() {
        int[] outControl = new int[1];
        Rect rect = new Rect();
        rect.bottom = (short)200;
        rect.right = (short)200;
        OS.CreatePushButtonControl(0, rect, 0, outControl);
        this.buttonInset = this.computeInset(outControl[0]);
        OS.DisposeControl(outControl[0]);
        OS.CreateTabsControl(0, rect, (short)0, (short)0, (short)0, 0, outControl);
        this.tabFolderNorthInset = this.computeInset(outControl[0]);
        OS.DisposeControl(outControl[0]);
        OS.CreateTabsControl(0, rect, (short)0, (short)1, (short)0, 0, outControl);
        this.tabFolderSouthInset = this.computeInset(outControl[0]);
        OS.DisposeControl(outControl[0]);
        OS.CreateEditUnicodeTextControl(0, rect, 0, false, null, outControl);
        this.editTextInset = this.computeInset(outControl[0]);
        OS.DisposeControl(outControl[0]);
        int attributes = 3;
        OS.HISearchFieldCreate(null, attributes, 0, 0, outControl);
        if (this.smallFonts) {
            OS.SetControlData(outControl[0], 0, 1936292453, 2, new short[]{1});
        }
        this.searchTextInset = this.computeInset(outControl[0]);
        this.searchTextInset.bottom = this.searchTextInset.top;
        OS.DisposeControl(outControl[0]);
        CGRect cgRect = new CGRect();
        cgRect.height = 200.0f;
        cgRect.width = 200.0f;
        int inAttributes = 9;
        OS.HIComboBoxCreate(cgRect, 0, null, 0, inAttributes, outControl);
        this.comboInset = this.computeInset(outControl[0]);
        this.comboInset.bottom = this.comboInset.top;
        OS.DisposeControl(outControl[0]);
    }

    void initializeWidgetTable() {
        this.property = new int[1];
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        int i = 0;
        while (i < 1023) {
            this.indexTable[i] = i + 1;
            ++i;
        }
        this.indexTable[1023] = -1;
    }

    public int internal_new_GC(GCData data) {
        int window;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((window = this.gcWindow) == 0) {
            window = this.gcWindow = this.createOverlayWindow();
        } else {
            int gdevice = OS.GetMainDevice();
            int[] ptr = new int[1];
            OS.memmove(ptr, gdevice, 4);
            GDevice device = new GDevice();
            OS.memmove(device, ptr[0], 62);
            Rect rect = new Rect();
            OS.SetRect(rect, device.left, device.top, device.right, device.bottom);
            OS.SetWindowBounds(window, 32, rect);
        }
        int port = OS.GetWindowPort(window);
        int[] buffer = new int[1];
        OS.CreateCGContextForPort(port, buffer);
        int context = buffer[0];
        if (context == 0) {
            SWT.error(2);
        }
        Rect portRect = new Rect();
        OS.GetPortBounds(port, portRect);
        OS.CGContextScaleCTM(context, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(context, 0.0f, portRect.top - portRect.bottom);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.window = window;
            data.background = this.getSystemColor((int)1).handle;
            data.foreground = this.getSystemColor((int)2).handle;
            data.font = this.getSystemFont();
            data.updateClip = true;
            data.portRect = portRect;
        } else {
            OS.ShowWindow(window);
        }
        return context;
    }

    public void internal_dispose_GC(int context, GCData data) {
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if (data != null) {
            int window = data.window;
            if (this.gcWindow == window) {
                OS.HideWindow(window);
            } else {
                OS.DisposeWindow(window);
            }
            data.window = 0;
        }
        OS.CGContextSynchronize(context);
        OS.CGContextRelease(context);
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    int itemCompareProc(int browser, int itemOne, int itemTwo, int sortProperty) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.itemCompareProc(browser, itemOne, itemTwo, sortProperty);
        }
        return 0;
    }

    int itemDataProc(int browser, int item, int property, int itemData, int setValue) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.itemDataProc(browser, item, property, itemData, setValue);
        }
        return 0;
    }

    int itemNotificationProc(int browser, int item, int message) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.itemNotificationProc(browser, item, message);
        }
        return 0;
    }

    int keyboardProc(int nextHandler, int theEvent, int userData) {
        int theWindow = OS.GetUserFocusWindow();
        if (theWindow != 0) {
            MenuTrackingData outData;
            int[] theControl = new int[1];
            OS.GetKeyboardFocus(theWindow, theControl);
            Widget widget = this.getWidget(theControl[0]);
            if (widget != null && OS.GetMenuTrackingData(0, outData = new MenuTrackingData()) != 0) {
                return widget.keyboardProc(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    int pollingProc(int inTimer, int inUserData) {
        if (this.grabControl == null || this.grabControl.isDisposed()) {
            return 0;
        }
        this.grabControl.sendTrackEvents();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean post(Event event) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (event == null) {
                this.error(4);
            }
            int type = event.type;
            switch (type) {
                case 1: 
                case 2: {
                    int result;
                    short regionCode;
                    int vKey = Display.untranslateKey(event.keyCode);
                    if (vKey != 0) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return OS.CGPostKeyboardEvent(0, vKey, type == 1) == 0;
                    }
                    int kchrPtr = OS.GetScriptManagerVariable((short)38);
                    int key = -1;
                    int[] encoding = new int[1];
                    short keyScript = (short)OS.GetScriptManagerVariable((short)22);
                    if (OS.UpgradeScriptInfoToTextEncoding(keyScript, (short)-128, regionCode = (short)OS.GetScriptManagerVariable((short)40), null, encoding) == -50 && OS.UpgradeScriptInfoToTextEncoding(keyScript, (short)-128, (short)-128, null, encoding) == -50) {
                        encoding[0] = 0;
                    }
                    int[] encodingInfo = new int[1];
                    OS.CreateUnicodeToTextInfoByEncoding(encoding[0], encodingInfo);
                    if (encodingInfo[0] != 0) {
                        char[] input = new char[]{event.character};
                        byte[] buffer = new byte[2];
                        OS.ConvertFromUnicodeToPString(encodingInfo[0], 2, input, buffer);
                        OS.DisposeUnicodeToTextInfo(encodingInfo);
                        key = buffer[1] & 0x7F;
                    }
                    if (key == -1) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    int[] state = new int[1];
                    vKey = -1;
                    int i = 0;
                    while (i <= 127) {
                        result = OS.KeyTranslate(kchrPtr, (short)i, state);
                        if ((result & 0x7F) == key) {
                            vKey = i;
                            break;
                        }
                        ++i;
                    }
                    if (vKey == -1) {
                        i = 0;
                        while (i <= 127) {
                            result = OS.KeyTranslate(kchrPtr, (short)(i | 0x200), state);
                            if ((result & 0x7F) == key) {
                                vKey = i;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (vKey == -1) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return OS.CGPostKeyboardEvent(key, vKey, type == 1) == 0;
                }
                case 3: 
                case 4: 
                case 5: {
                    CGPoint mouseCursorPosition = new CGPoint();
                    int chord = OS.GetCurrentEventButtonState();
                    if (type == 5) {
                        mouseCursorPosition.x = event.x;
                        mouseCursorPosition.y = event.y;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return OS.CGPostMouseEvent(mouseCursorPosition, true, 5, (chord & 1) != 0, (chord & 2) != 0, (chord & 4) != 0, (chord & 8) != 0, (chord & 0x10) != 0) == 0;
                    }
                    int button = event.button;
                    if (button < 1 || button > 5) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    boolean button1 = false;
                    boolean button2 = false;
                    boolean button3 = false;
                    boolean button4 = false;
                    boolean button5 = false;
                    switch (button) {
                        case 1: {
                            button1 = type == 3;
                            button2 = (chord & 4) != 0;
                            button3 = (chord & 2) != 0;
                            button4 = (chord & 8) != 0;
                            button5 = (chord & 0x10) != 0;
                            break;
                        }
                        case 2: {
                            button1 = (chord & 1) != 0;
                            button2 = type == 3;
                            button3 = (chord & 2) != 0;
                            button4 = (chord & 8) != 0;
                            button5 = (chord & 0x10) != 0;
                            break;
                        }
                        case 3: {
                            button1 = (chord & 1) != 0;
                            button2 = (chord & 4) != 0;
                            button3 = type == 3;
                            button4 = (chord & 8) != 0;
                            button5 = (chord & 0x10) != 0;
                            break;
                        }
                        case 4: {
                            button1 = (chord & 1) != 0;
                            button2 = (chord & 4) != 0;
                            button3 = (chord & 2) != 0;
                            button4 = type == 3;
                            button5 = (chord & 0x10) != 0;
                            break;
                        }
                        case 5: {
                            button1 = (chord & 1) != 0;
                            button2 = (chord & 4) != 0;
                            button3 = (chord & 2) != 0;
                            button4 = (chord & 8) != 0;
                            button5 = type == 3;
                        }
                    }
                    Point pt = new Point();
                    OS.GetGlobalMouse(pt);
                    mouseCursorPosition.x = pt.h;
                    mouseCursorPosition.y = pt.v;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return OS.CGPostMouseEvent(mouseCursorPosition, true, 5, button1, button3, button2, button4, button5) == 0;
                }
                case 37: {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return OS.CGPostScrollWheelEvent(1, event.count) == 0;
                }
                default: 
            }
        }
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public org.eclipse.swt.graphics.Point map(Control from, Control to, org.eclipse.swt.graphics.Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public org.eclipse.swt.graphics.Point map(Control from, Control to, int x, int y) {
        Rect inset;
        CGPoint pt;
        int window;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        org.eclipse.swt.graphics.Point point = new org.eclipse.swt.graphics.Point(x, y);
        if (from == to) {
            return point;
        }
        Rect rect = new Rect();
        if (from != null) {
            window = OS.GetControlOwner(from.handle);
            pt = new CGPoint();
            OS.HIViewConvertPoint(pt, from.handle, 0);
            point.x += (int)pt.x;
            point.y += (int)pt.y;
            OS.GetWindowBounds(window, (short)32, rect);
            point.x += rect.left;
            point.y += rect.top;
            inset = from.getInset();
            point.x -= inset.left;
            point.y -= inset.top;
        }
        if (to != null) {
            window = OS.GetControlOwner(to.handle);
            pt = new CGPoint();
            OS.HIViewConvertPoint(pt, to.handle, 0);
            point.x -= (int)pt.x;
            point.y -= (int)pt.y;
            OS.GetWindowBounds(window, (short)32, rect);
            point.x -= rect.left;
            point.y -= rect.top;
            inset = to.getInset();
            point.x += inset.left;
            point.y += inset.top;
        }
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        Rect inset;
        CGPoint pt;
        int window;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(x, y, width, height);
        if (from == to) {
            return rectangle;
        }
        Rect rect = new Rect();
        if (from != null) {
            window = OS.GetControlOwner(from.handle);
            pt = new CGPoint();
            OS.HIViewConvertPoint(pt, from.handle, 0);
            rectangle.x += (int)pt.x;
            rectangle.y += (int)pt.y;
            OS.GetWindowBounds(window, (short)32, rect);
            rectangle.x += rect.left;
            rectangle.y += rect.top;
            inset = from.getInset();
            rectangle.x -= inset.left;
            rectangle.y -= inset.top;
        }
        if (to != null) {
            window = OS.GetControlOwner(to.handle);
            pt = new CGPoint();
            OS.HIViewConvertPoint(pt, to.handle, 0);
            rectangle.x -= (int)pt.x;
            rectangle.y -= (int)pt.y;
            OS.GetWindowBounds(window, (short)32, rect);
            rectangle.x -= rect.left;
            rectangle.y -= rect.top;
            inset = to.getInset();
            rectangle.x += inset.left;
            rectangle.y += inset.top;
        }
        return rectangle;
    }

    int menuProc(int nextHandler, int theEvent, int userData) {
        short menuID = 0;
        if (userData != 0) {
            menuID = OS.GetMenuID(userData);
        } else {
            int[] theMenu = new int[1];
            OS.GetEventParameter(theEvent, 0x2D2D2D2D, 1835363957, null, 4, null, theMenu);
            menuID = OS.GetMenuID(theMenu[0]);
        }
        Menu menu = this.getMenu(menuID);
        if (menu != null) {
            return menu.menuProc(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    int mouseProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 1: {
                short[] buttonData = new short[1];
                OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, buttonData);
                int[] clickCountData = new int[1];
                OS.GetEventParameter(theEvent, 1667460724, 1835100014, null, 4, null, clickCountData);
                this.clickCount = this.clickCountButton == buttonData[0] ? clickCountData[0] : 1;
                this.clickCountButton = buttonData[0];
                break;
            }
            case 5: 
            case 6: {
                this.mouseMoved = true;
                if (OS.CGCursorIsVisible()) break;
                OS.CGDisplayShowCursor(OS.CGMainDisplayID());
            }
        }
        int sizeof = 4;
        Point where = new Point();
        OS.GetEventParameter(theEvent, 1835822947, 1363439732, null, sizeof, null, where);
        int[] theWindow = new int[1];
        short part = OS.FindWindow(where, theWindow);
        switch (part) {
            case 1: {
                if (eventKind != 1) break;
                this.clearMenuFlags();
                if (this.menuBar == null || this.menuBar.isEnabled()) {
                    OS.MenuSelect(where);
                }
                this.clearMenuFlags();
                return 0;
            }
            case 3: {
                Rect windowRect = new Rect();
                OS.GetWindowBounds(theWindow[0], (short)33, windowRect);
                CGPoint inPoint = new CGPoint();
                inPoint.x = where.h - windowRect.left;
                inPoint.y = where.v - windowRect.top;
                int root = OS.HIViewGetRoot(theWindow[0]);
                int[] buffer = new int[1];
                OS.HIViewGetViewForMouseEvent(root, theEvent, buffer);
                int view = buffer[0];
                OS.HIViewFindByID(root, OS.kHIViewWindowContentID(), buffer);
                int contentView = buffer[0];
                while (view != 0 && view != contentView && !OS.IsControlEnabled(view)) {
                    view = OS.HIViewGetSuperview(view);
                }
                Widget widget = null;
                boolean consume = false;
                do {
                    if ((widget = this.getWidget(view)) == null) continue;
                    if (widget.isEnabled()) break;
                    consume = true;
                } while ((view = OS.HIViewGetSuperview(view)) != 0 && view != contentView);
                if (widget == null || !widget.contains((int)inPoint.x, (int)inPoint.y)) break;
                int result = userData != 0 ? widget.mouseProc(nextHandler, theEvent, userData) : -9874;
                return consume ? 0 : result;
            }
        }
        switch (eventKind) {
            case 5: 
            case 6: {
                OS.InitCursor();
            }
        }
        return -9874;
    }

    int mouseHoverProc(int id, int handle) {
        OS.RemoveEventLoopTimer(id);
        this.mouseHoverID = 0;
        this.mouseMoved = false;
        if (this.currentControl != null && !this.currentControl.isDisposed()) {
            int chord = OS.GetCurrentEventButtonState();
            int modifiers = OS.GetCurrentEventKeyModifiers();
            org.eclipse.swt.graphics.Point pt = this.currentControl.toControl(this.getCursorLocation());
            this.currentControl.sendMouseEvent(32, (short)0, 0, true, chord, (short)pt.x, (short)pt.y, modifiers);
        }
        return 0;
    }

    int observerProc(int observer, int activity, int info) {
        switch (activity) {
            case 32: {
                if (!this.runAsyncMessages || !this.runAsyncMessages(false)) break;
                this.wakeThread();
            }
        }
        return 0;
    }

    int readImageRef(int path) {
        int image = 0;
        int url = OS.CFURLCreateFromFileSystemRepresentation(0, path, OS.strlen(path), false);
        if (url != 0) {
            int extention = OS.CFURLCopyPathExtension(url);
            if (extention != 0) {
                byte[] fsSpec;
                byte[] fsRef;
                int length = OS.CFStringGetLength(extention);
                char[] buffer = new char[length];
                CFRange range = new CFRange();
                range.length = length;
                OS.CFStringGetCharacters(extention, range, buffer);
                String ext = new String(buffer);
                if (ext.equalsIgnoreCase("png")) {
                    int provider = OS.CGDataProviderCreateWithURL(url);
                    if (provider != 0) {
                        image = OS.CGImageCreateWithPNGDataProvider(provider, null, true, 0);
                        OS.CGDataProviderRelease(provider);
                    }
                } else if (ext.equalsIgnoreCase("jpeg") || ext.equals("jpg")) {
                    int provider = OS.CGDataProviderCreateWithURL(url);
                    if (provider != 0) {
                        image = OS.CGImageCreateWithJPEGDataProvider(provider, null, true, 0);
                        OS.CGDataProviderRelease(provider);
                    }
                } else if (ext.equalsIgnoreCase("icns") && OS.CFURLGetFSRef(url, fsRef = new byte[80]) && OS.FSGetCatalogInfo(fsRef, 0, null, null, fsSpec = new byte[70], null) == 0) {
                    int[] iconFamily = new int[1];
                    OS.ReadIconFile(fsSpec, iconFamily);
                    if (iconFamily[0] != 0) {
                        int[] icon = this.createImageFromFamily(iconFamily[0], 1769222962, 1949855083, 128, 128);
                        if (icon == null) {
                            icon = this.createImageFromFamily(iconFamily[0], 1768436530, 1748528491, 64, 64);
                        }
                        if (icon == null) {
                            icon = this.createImageFromFamily(iconFamily[0], 1768698674, 1815637355, 32, 32);
                        }
                        if (icon != null) {
                            image = icon[0];
                        }
                        OS.DisposeHandle(iconFamily[0]);
                    }
                }
                OS.CFRelease(extention);
            }
            OS.CFRelease(url);
        }
        return image;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        boolean events = false;
        events |= this.runSettings();
        events |= this.runTimers();
        events |= this.runPopups();
        int[] outEvent = new int[1];
        int status = OS.ReceiveNextEvent(0, null, 0.0, true, outEvent);
        if (status == 0) {
            events = true;
            OS.SendEventToEventTarget(outEvent[0], OS.GetEventDispatcherTarget());
            OS.ReleaseEvent(outEvent[0]);
            if (this.focusCombo != null && !this.focusCombo.isDisposed()) {
                this.focusCombo.checkSelection();
            }
        }
        if (events |= this.runPaint()) {
            this.runEnterExit();
            this.runDeferredEvents();
            return true;
        }
        return this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] == null) {
                    Display.Displays[i] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            Display[] newDisplays = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
            newDisplays[Display.Displays.length] = display;
            Displays = newDisplays;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void release() {
        this.disposing = true;
        this.sendEvent(12, new Event());
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    this.disposeList[i].run();
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int i;
        this.disposeWindows();
        if (this.gcWindow != 0) {
            OS.DisposeWindow(this.gcWindow);
        }
        this.gcWindow = 0;
        if (this.caretID != 0) {
            OS.RemoveEventLoopTimer(this.caretID);
        }
        if (this.mouseHoverID != 0) {
            OS.RemoveEventLoopTimer(this.mouseHoverID);
        }
        this.mouseHoverID = 0;
        this.caretID = 0;
        if (this.timerIds != null) {
            i = 0;
            while (i < this.timerIds.length) {
                if (this.timerIds[i] != 0 && this.timerIds[i] != -1) {
                    OS.RemoveEventLoopTimer(this.timerIds[i]);
                }
                ++i;
            }
        }
        this.timerIds = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.infoImage = null;
        this.errorImage = null;
        i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.cursors[i].dispose();
            }
            ++i;
        }
        this.cursors = null;
        if (this.dockImage != 0) {
            OS.CGImageRelease(this.dockImage);
        }
        this.dockImage = 0;
        if (this.runLoopObserver != 0) {
            OS.CFRunLoopObserverInvalidate(this.runLoopObserver);
            OS.CFRelease(this.runLoopObserver);
        }
        if (this.runLoopSource != 0) {
            OS.CFRunLoopSourceInvalidate(this.runLoopSource);
            OS.CFRelease(this.runLoopSource);
        }
        this.runLoopObserver = 0;
        this.runLoopSource = 0;
        this.runLoop = 0;
        this.releaseCallback.dispose();
        this.actionCallback.dispose();
        this.appleEventCallback.dispose();
        this.caretCallback.dispose();
        this.clockCallback.dispose();
        this.commandCallback.dispose();
        this.controlCallback.dispose();
        this.accessibilityCallback.dispose();
        this.drawItemCallback.dispose();
        this.itemCompareCallback.dispose();
        this.itemDataCallback.dispose();
        this.itemNotificationCallback.dispose();
        this.helpCallback.dispose();
        this.hitTestCallback.dispose();
        this.keyboardCallback.dispose();
        this.menuCallback.dispose();
        this.mouseHoverCallback.dispose();
        this.mouseCallback.dispose();
        this.trackingCallback.dispose();
        this.windowCallback.dispose();
        this.colorCallback.dispose();
        this.textInputCallback.dispose();
        this.appearanceCallback.dispose();
        this.trayItemCallback.dispose();
        this.observerCallback.dispose();
        this.sourceCallback.dispose();
        this.searchCallback.dispose();
        this.coreEventCallback.dispose();
        this.pollingCallback.dispose();
        this.appearanceCallback = null;
        this.commandCallback = null;
        this.caretCallback = null;
        this.appleEventCallback = null;
        this.actionCallback = null;
        this.itemNotificationCallback = null;
        this.itemDataCallback = null;
        this.drawItemCallback = null;
        this.controlCallback = null;
        this.clockCallback = null;
        this.accessibilityCallback = null;
        this.trayItemCallback = null;
        this.searchCallback = null;
        this.itemCompareCallback = null;
        this.menuCallback = null;
        this.keyboardCallback = null;
        this.hitTestCallback = null;
        this.helpCallback = null;
        this.sourceCallback = null;
        this.observerCallback = null;
        this.colorCallback = null;
        this.windowCallback = null;
        this.trackingCallback = null;
        this.mouseCallback = null;
        this.mouseHoverCallback = null;
        this.pollingCallback = null;
        this.releaseCallback = null;
        this.coreEventCallback = null;
        this.textInputCallback = null;
        this.trayItemProc = 0;
        this.searchProc = 0;
        this.appearanceProc = 0;
        this.commandProc = 0;
        this.caretProc = 0;
        this.appleEventProc = 0;
        this.actionProc = 0;
        this.itemCompareProc = 0;
        this.itemNotificationProc = 0;
        this.itemDataProc = 0;
        this.drawItemProc = 0;
        this.controlProc = 0;
        this.clockProc = 0;
        this.accessibilityProc = 0;
        this.releaseProc = 0;
        this.sourceProc = 0;
        this.observerProc = 0;
        this.menuProc = 0;
        this.keyboardProc = 0;
        this.hitTestProc = 0;
        this.helpProc = 0;
        this.coreEventProc = 0;
        this.colorProc = 0;
        this.windowProc = 0;
        this.trackingProc = 0;
        this.mouseProc = 0;
        this.mouseHoverProc = 0;
        this.pollingProc = 0;
        this.textInputProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.timerList = null;
        this.timerProc = 0;
        this.focusCombo = null;
        this.focusControl = null;
        this.currentControl = null;
        this.activeShell = null;
        this.helpWidget = null;
        if (this.helpString != 0) {
            OS.CFRelease(this.helpString);
        }
        this.helpString = 0;
        this.popups = null;
        this.menus = null;
        this.widgetTable = null;
        this.modalShells = null;
        this.menuBar = null;
        this.filterTable = null;
        this.eventTable = null;
        this.thread = null;
        this.kchrState = null;
        this.property = null;
        this.indexTable = null;
        this.searchTextInset = null;
        this.editTextInset = null;
        this.comboInset = null;
        this.tabFolderSouthInset = null;
        this.tabFolderNorthInset = null;
        this.buttonInset = null;
        this.highlightColor = null;
        this.data = null;
        this.keys = null;
        this.values = null;
    }

    int releaseDataProc(int info, int data, int size) {
        OS.DisposePtr(data);
        return 0;
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        this.menus[menu.id - 1001] = null;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    Widget removeWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        Widget widget = null;
        this.property[0] = 0;
        OS.GetControlProperty(handle, 1937208368, 1937208368, 4, null, this.property);
        int index = this.property[0] - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            widget = this.widgetTable[index];
            this.widgetTable[index] = null;
            this.indexTable[index] = this.freeSlot;
            this.freeSlot = index;
            OS.RemoveControlProperty(handle, 1937208368, 1937208368);
        }
        return widget;
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runEnterExit() {
        Rect rect;
        boolean eventSent = false;
        Widget control = null;
        int[] theControl = new int[1];
        Point where = new Point();
        OS.GetGlobalMouse(where);
        int[] theWindow = new int[1];
        if (OS.FindWindow(where, theWindow) == 3 && theWindow[0] != 0) {
            Control cursorControl;
            Widget widget;
            rect = new Rect();
            OS.GetWindowBounds(theWindow[0], (short)33, rect);
            CGPoint inPoint = new CGPoint();
            inPoint.x = where.h - rect.left;
            inPoint.y = where.v - rect.top;
            int[] theRoot = new int[1];
            OS.GetRootControl(theWindow[0], theRoot);
            int[] event = new int[1];
            OS.CreateEvent(0, 1836021107, 1, 0.0, 0, event);
            OS.SetEventParameter(event[0], 2003660661, 1751740532, 8, inPoint);
            OS.HIViewGetViewForMouseEvent(theRoot[0], event[0], theControl);
            OS.ReleaseEvent(event[0]);
            while (theControl[0] != 0 && !OS.IsControlEnabled(theControl[0])) {
                OS.GetSuperControl(theControl[0], theControl);
            }
            boolean propagate = true;
            if (theControl[0] != 0) {
                do {
                    if ((widget = this.getWidget(theControl[0])) != null && widget instanceof Control && (cursorControl = (Control)widget).isEnabled()) {
                        if (!cursorControl.isEnabledModal()) break;
                        if (widget.isTrimHandle(theControl[0])) {
                            propagate = false;
                            break;
                        }
                        control = cursorControl;
                        break;
                    }
                    OS.GetSuperControl(theControl[0], theControl);
                } while (theControl[0] != 0);
            }
            if (control == null && propagate) {
                theControl[0] = theRoot[0];
                widget = this.getWidget(theControl[0]);
                if (widget != null && widget instanceof Control && (cursorControl = (Control)widget).isEnabled() && cursorControl.isEnabledModal()) {
                    control = cursorControl;
                    theControl[0] = ((Control)control).handle;
                }
            }
            if (control != null && !control.contains((int)inPoint.x, (int)inPoint.y)) {
                control = null;
            }
        }
        if (control != this.currentControl) {
            org.eclipse.swt.graphics.Point pt;
            if (this.currentControl != null && !this.currentControl.isDisposed()) {
                eventSent = true;
                int chord = OS.GetCurrentEventButtonState();
                int modifiers = OS.GetCurrentEventKeyModifiers();
                pt = this.currentControl.toControl(where.h, where.v);
                this.currentControl.sendMouseEvent(7, (short)0, 0, true, chord, (short)pt.x, (short)pt.y, modifiers);
                if (this.mouseHoverID != 0) {
                    OS.RemoveEventLoopTimer(this.mouseHoverID);
                }
                this.mouseHoverID = 0;
                this.mouseMoved = false;
            }
            if (control != null && control.isDisposed()) {
                control = null;
            }
            if ((this.currentControl = control) != null) {
                eventSent = true;
                int chord = OS.GetCurrentEventButtonState();
                int modifiers = OS.GetCurrentEventKeyModifiers();
                pt = this.currentControl.toControl(where.h, where.v);
                this.currentControl.sendMouseEvent(6, (short)0, 0, true, chord, (short)pt.x, (short)pt.y, modifiers);
            }
        }
        if (control != null && this.mouseMoved) {
            int[] outDelay = new int[1];
            OS.HMGetTagDelay(outDelay);
            if (this.mouseHoverID != 0) {
                OS.SetEventLoopTimerNextFireTime(this.mouseHoverID, (double)outDelay[0] / 1000.0);
            } else {
                int eventLoop = OS.GetCurrentEventLoop();
                int[] id = new int[1];
                OS.InstallEventLoopTimer(eventLoop, (double)outDelay[0] / 1000.0, 0.0, this.mouseHoverProc, 0, id);
                this.mouseHoverID = id[0];
            }
            this.mouseMoved = false;
        }
        if (!OS.StillDown() && theWindow[0] != 0 && theControl[0] != 0) {
            rect = new Rect();
            OS.GetWindowBounds(theWindow[0], (short)33, rect);
            CGPoint pt = new CGPoint();
            OS.HIViewConvertPoint(pt, theControl[0], 0);
            where.h = (short)(where.h - (int)pt.x);
            where.v = (short)(where.v - (int)pt.y);
            OS.GetWindowBounds(theWindow[0], (short)32, rect);
            where.h = (short)(where.h - rect.left);
            where.v = (short)(where.v - rect.top);
            int modifiers = OS.GetCurrentEventKeyModifiers();
            boolean[] cursorWasSet = new boolean[1];
            OS.HandleControlSetCursor(theControl[0], where, (short)modifiers, cursorWasSet);
            if (!cursorWasSet[0]) {
                OS.SetThemeCursor(0);
            }
        }
        return eventSent;
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            widget.notifyListeners(event.type, event);
        }
        this.eventQueue = null;
        return true;
    }

    boolean runEventLoopTimers() {
        this.allowTimers = false;
        boolean result = OS.ReceiveNextEvent(0, null, 0.0, false, null) == 0;
        this.allowTimers = true;
        return result;
    }

    boolean runPaint() {
        if (!this.needsPaint) {
            return false;
        }
        this.needsPaint = false;
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget != null && widget instanceof Shell) {
                Shell shell = (Shell)widget;
                if (shell.invalRgn != 0) {
                    int invalRgn = shell.invalRgn;
                    shell.invalRgn = 0;
                    shell.redrawChildren(OS.HIViewGetRoot(shell.shellHandle), invalRgn);
                    OS.DisposeRgn(invalRgn);
                }
            }
            ++i;
        }
        return true;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.clearMenuFlags();
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            this.clearMenuFlags();
            result = true;
        }
        this.popups = null;
        return result;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.initializeInsets();
        this.sendEvent(39, null);
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.redraw(true);
                shell.layout(true, true);
            }
            ++i;
        }
        return true;
    }

    boolean runTimers() {
        if (this.timerList == null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < this.timerList.length) {
            if (this.timerIds[i] == -1) {
                Runnable runnable = this.timerList[i];
                this.timerList[i] = null;
                this.timerIds[i] = 0;
                if (runnable != null) {
                    result = true;
                    runnable.run();
                }
            }
            ++i;
        }
        return result;
    }

    int searchProc(int nextHandler, int theEvent, int userData) {
        Widget widget = this.getWidget(userData);
        if (widget != null) {
            return widget.searchProc(nextHandler, theEvent, userData);
        }
        return -9874;
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretID != 0) {
            OS.RemoveEventLoopTimer(this.caretID);
        }
        this.caretID = 0;
        this.currentCaret = caret;
        if (this.currentCaret != null) {
            int blinkRate = this.currentCaret.blinkRate;
            int[] timerId = new int[1];
            double time = (double)blinkRate / 1000.0;
            int eventLoop = OS.GetCurrentEventLoop();
            OS.InstallEventLoopTimer(eventLoop, time, time, this.caretProc, 0, timerId);
            this.caretID = timerId[0];
        }
    }

    void setCursor(int cursor) {
        switch (cursor) {
            case 0: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                OS.SetThemeCursor(cursor);
                break;
            }
            default: {
                if (OS.VERSION >= 4160) {
                    Cocoa.objc_msgSend(cursor, Cocoa.S_set);
                    break;
                }
                OS.SetCursor(cursor);
            }
        }
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        CGPoint pt = new CGPoint();
        pt.x = x;
        pt.y = y;
        OS.CGWarpMouseCursorPosition(pt);
    }

    public void setCursorLocation(org.eclipse.swt.graphics.Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(ADD_WIDGET_KEY)) {
            Object[] data = (Object[])value;
            int handle = (Integer)data[0];
            Widget widget = (Widget)data[1];
            if (widget == null) {
                this.removeWidget(handle);
            } else {
                this.addWidget(handle, widget);
            }
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Synchronizer oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (oldSynchronizer != null) {
                oldSynchronizer.runAsyncMessages(true);
            }
            return;
        }
    }

    void setMenuBar(Menu menu) {
        if (menu == this.menuBar) {
            return;
        }
        int theMenu = 0;
        if (menu == null) {
            int[] outMenuRef = new int[1];
            OS.CreateNewMenu((short)1000, 0, outMenuRef);
            theMenu = outMenuRef[0];
        } else {
            theMenu = menu.handle;
        }
        OS.SetRootMenu(theMenu);
        if (menu == null) {
            OS.ClearMenuBar();
            OS.DisposeMenu(theMenu);
        }
        this.menuBar = menu;
    }

    void setModalShell(Shell shell) {
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) {
                return;
            }
            if (this.modalShells[index] == null) break;
            ++index;
        }
        if (index == length) {
            Shell[] newModalShells = new Shell[length + 4];
            System.arraycopy(this.modalShells, 0, newModalShells, 0, length);
            this.modalShells = newModalShells;
        }
        this.modalShells[index] = shell;
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        this.disposeWindows();
        if (this.eventTable != null && this.eventTable.hooks(39)) {
            RGBColor color = new RGBColor();
            int result = 0;
            int depth = this.getDepth();
            do {
                this.runAsyncMessages = false;
                this.allowTimers = false;
                result = OS.CFRunLoopRunInMode(OS.kCFRunLoopDefaultMode(), 0.5, true);
                this.runAsyncMessages = true;
                this.allowTimers = true;
                if (result != 3) continue;
                OS.GetThemeBrushAsColor((short)-3, (short)depth, true, color);
                if (this.highlightColor.red == color.red && this.highlightColor.green == color.green && this.highlightColor.blue == color.blue) continue;
                this.highlightColor = color;
                this.runSettings = true;
                return true;
            } while (result == 3);
            return result == 4;
        }
        this.runAsyncMessages = false;
        this.allowTimers = false;
        int result = OS.CFRunLoopRunInMode(OS.kCFRunLoopDefaultMode(), 86400.0, true);
        this.runAsyncMessages = true;
        this.allowTimers = true;
        return result == 4;
    }

    int sourceProc(int info) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    int textInputProc(int nextHandler, int theEvent, int userData) {
        int theWindow = OS.GetUserFocusWindow();
        if (theWindow != 0) {
            MenuTrackingData outData;
            int[] theControl = new int[1];
            OS.GetKeyboardFocus(theWindow, theControl);
            Widget widget = this.getWidget(theControl[0]);
            if (widget != null && OS.GetMenuTrackingData(0, outData = new MenuTrackingData()) != 0) {
                OS.GetWindowDefaultButton(theWindow, theControl);
                OS.SetWindowDefaultButton(theWindow, 0);
                int result = widget.textInputProc(nextHandler, theEvent, userData);
                if (result == -9874) {
                    result = OS.CallNextEventHandler(nextHandler, theEvent);
                }
                OS.SetWindowDefaultButton(theWindow, theControl[0]);
                return result;
            }
        }
        return -9874;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            int timerId = this.timerIds[index];
            if (milliseconds < 0) {
                OS.RemoveEventLoopTimer(timerId);
                this.timerList[index] = null;
                this.timerIds[index] = 0;
            } else {
                OS.SetEventLoopTimerNextFireTime(timerId, (double)milliseconds / 1000.0);
            }
            return;
        }
        if (milliseconds < 0) {
            return;
        }
        index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == null) break;
            ++index;
        }
        if (index == this.timerList.length) {
            Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
            System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
            this.timerList = newTimerList;
            int[] newTimerIds = new int[this.timerIds.length + 4];
            System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
            this.timerIds = newTimerIds;
        }
        int[] timerId = new int[1];
        int eventLoop = OS.GetCurrentEventLoop();
        OS.InstallEventLoopTimer(eventLoop, (double)milliseconds / 1000.0, 0.0, this.timerProc, index, timerId);
        if (timerId[0] != 0) {
            this.timerIds[index] = timerId[0];
            this.timerList[index] = runnable;
        }
    }

    int timerProc(int id, int index) {
        OS.RemoveEventLoopTimer(id);
        if (this.timerList == null) {
            return 0;
        }
        if (index >= 0 && index < this.timerList.length) {
            if (this.allowTimers) {
                Runnable runnable = this.timerList[index];
                this.timerList[index] = null;
                this.timerIds[index] = 0;
                if (runnable != null) {
                    runnable.run();
                }
            } else {
                this.timerIds[index] = -1;
                this.wakeThread();
            }
        }
        return 0;
    }

    int trackingProc(int browser, int itemID, int property, int theRect, int startPt, int modifiers) {
        Widget widget = this.getWidget(browser);
        if (widget != null) {
            return widget.trackingProc(browser, itemID, property, theRect, startPt, modifiers);
        }
        return 0;
    }

    int trayItemProc(int target, int userData, int selector, int event) {
        TrayItem item = (TrayItem)OS.JNIGetObject(userData);
        if (item != null) {
            return item.trayItemProc(target, userData, selector, event);
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.update(true);
            }
            ++i;
        }
    }

    void updateQuitMenu() {
        boolean enabled = true;
        Shell[] shells = this.getShells();
        int mask = 229376;
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if ((shell.style & mask) != 0 && shell.isVisible()) {
                enabled = false;
                break;
            }
            ++i;
        }
        if (enabled) {
            OS.EnableMenuCommand(0, 1903520116);
        } else {
            OS.DisableMenuCommand(0, 1903520116);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        OS.CFRunLoopSourceSignal(this.runLoopSource);
        OS.CFRunLoopWakeUp(this.runLoop);
    }

    int windowProc(int nextHandler, int theEvent, int userData) {
        Widget widget = this.getWidget(userData);
        if (widget == null) {
            int[] theWindow = new int[1];
            OS.GetEventParameter(theEvent, 0x2D2D2D2D, 2003398244, null, 4, null, theWindow);
            int[] theRoot = new int[1];
            OS.GetRootControl(theWindow[0], theRoot);
            widget = this.getWidget(theRoot[0]);
        }
        if (widget != null) {
            return widget.windowProc(nextHandler, theEvent, userData);
        }
        return -9874;
    }
}

