/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.internal.spreadsheet.structures.Cell;
import org.xmind.ui.internal.spreadsheet.structures.Chart;
import org.xmind.ui.internal.spreadsheet.structures.Column;
import org.xmind.ui.internal.spreadsheet.structures.Item;
import org.xmind.ui.mindmap.IBranchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Row
extends BranchStructureData {
    private Chart ownedChart;
    private List<Cell> cells = new ArrayList<Cell>();
    private int prefCellHeight = -1;
    private Integer y = null;
    private Integer height = null;

    public Row(IBranchPart head, Chart ownedChart) {
        super(head);
        Assert.isNotNull((Object)head);
        Assert.isNotNull((Object)((Object)ownedChart));
        this.ownedChart = ownedChart;
    }

    public Chart getOwnedChart() {
        return this.ownedChart;
    }

    public IBranchPart getHead() {
        return this.getBranch();
    }

    void addCell(Cell cell) {
        this.cells.add(cell);
    }

    void removeCell(Cell cell) {
        this.cells.remove((Object)cell);
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public int getPrefCellHeight() {
        if (this.prefCellHeight < 0) {
            this.prefCellHeight = this.calcPrefCellHeight();
        }
        return this.prefCellHeight;
    }

    private int calcPrefCellHeight() {
        int h = 0;
        for (Cell cell : this.cells) {
            h = Math.max(h, cell.getPrefContentSize().height);
        }
        return h;
    }

    public int getPrefHeight() {
        return Math.max(this.getHead().getTopicPart().getFigure().getPreferredSize().height, this.getPrefCellHeight());
    }

    public Cell findCellByColumn(Column col) {
        for (Cell cell : this.cells) {
            if (cell.getOwnedColumn() != col) continue;
            return cell;
        }
        return null;
    }

    public Cell findCellByItem(IBranchPart itemBranch) {
        for (Cell cell : this.cells) {
            if (cell.findItem(itemBranch) == null) continue;
            return cell;
        }
        return null;
    }

    public Item findItem(IBranchPart itemBranch) {
        for (Cell cell : this.cells) {
            Item item = cell.findItem(itemBranch);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public Cell getPreviousCell(Cell cell) {
        int index = this.getCellIndex(cell);
        if (index > 0) {
            return this.cells.get(index - 1);
        }
        return null;
    }

    public Cell getNextCell(Cell cell) {
        int index = this.getCellIndex(cell);
        if (index < this.cells.size() - 1) {
            return this.cells.get(index + 1);
        }
        return null;
    }

    public int getCellIndex(Cell cell) {
        return this.cells.indexOf((Object)cell);
    }

    public int getTop() {
        this.ensurePosition();
        return this.y;
    }

    public int getHeight() {
        this.ensurePosition();
        return this.height;
    }

    private void ensurePosition() {
        if (this.y != null && this.height != null) {
            return;
        }
        int lineWidth = this.getOwnedChart().getLineWidth();
        Row prev = this.getOwnedChart().getPreviousRow(this);
        if (prev != null) {
            this.y = prev.getTop() + prev.getHeight() + lineWidth;
        } else {
            int intY = this.getOwnedChart().getTitle().getTopicPart().getFigure().getBounds().bottom() + lineWidth;
            if (this.getOwnedChart().hasColumns()) {
                intY += this.getOwnedChart().getColumnHeadHeight() + lineWidth + this.getOwnedChart().getMajorSpacing();
            }
            this.y = intY;
        }
        int headHeight = this.getBranch().getTopicPart().getFigure().getBounds().height;
        int cellHeight = 0;
        for (Cell cell : this.cells) {
            cellHeight = Math.max(cellHeight, cell.getContentHeight());
        }
        int h = Math.max(headHeight, cellHeight);
        this.height = h + this.getOwnedChart().getMinorSpacing();
    }

    public Cell findCell(Point point) {
        if (this.getTop() < point.y && this.getTop() + this.getHeight() > point.y) {
            for (Cell cell : this.cells) {
                Column col = cell.getOwnedColumn();
                if (col.getLeft() >= point.x || col.getLeft() + col.getWidth() <= point.x) continue;
                return cell;
            }
        }
        return null;
    }

    public int getMajorSpacing() {
        return super.getMajorSpacing();
    }

    public int getMinorSpacing() {
        return super.getMinorSpacing();
    }

    public String toString() {
        return this.getHead().toString();
    }
}

