/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.xmind.ui.internal.spreadsheet.structures.Chart;
import org.xmind.ui.internal.spreadsheet.structures.Column;
import org.xmind.ui.internal.spreadsheet.structures.ColumnHead;
import org.xmind.ui.texteditor.FloatingTextEditorHelperBase;

public class ColumnHeadEditorHelper
extends FloatingTextEditorHelperBase {
    private Chart chart;
    private Column column;
    private ColumnHead columnHead;
    private Rectangle bounds;

    public ColumnHeadEditorHelper() {
    }

    public ColumnHeadEditorHelper(boolean extend) {
        super(extend);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public ColumnHead getColumnHead() {
        return this.columnHead;
    }

    public void setColumnHead(ColumnHead columnHead) {
        this.columnHead = columnHead;
    }

    public void activate() {
        this.bounds = null;
        super.activate();
        if (this.getEditor() != null && this.getViewer() != null && this.getColumn() != null && this.getChart() != null && this.getColumnHead() != null) {
            Rectangle b = this.getPreferredBounds();
            Point loc = this.getViewer().computeToControl(b.getLocation(), true);
            this.getEditor().setInitialLocation(new org.eclipse.swt.graphics.Point(loc.x, loc.y));
            this.getEditor().setInitialSize(new org.eclipse.swt.graphics.Point(b.width, b.height));
        }
    }

    public void deactivate() {
        this.bounds = null;
        super.deactivate();
    }

    protected Rectangle getPreferredBounds() {
        if (this.bounds == null) {
            this.bounds = this.calcBounds();
        }
        return this.bounds.getCopy();
    }

    private Rectangle calcBounds() {
        Dimension size = this.columnHead.getPrefSize();
        int width = this.column.getWidth();
        int height = this.chart.getColumnHeadHeight() + this.chart.getMajorSpacing();
        int x = this.column.getLeft() + (width - size.width) / 2;
        int y = this.chart.getTitle().getTopicPart().getFigure().getBounds().bottom() + this.chart.getLineWidth() + (height - size.height) / 2;
        return new Rectangle(x, y, size.width, size.height);
    }

    protected Font getPreferredFont() {
        return this.columnHead.getFont();
    }
}

