/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.ArraySourceProvider;
import org.xmind.gef.EditDomain;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CreateTopicCommand;
import org.xmind.ui.commands.ModifyLabelCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.spreadsheet.Messages;
import org.xmind.ui.internal.spreadsheet.structures.Chart;
import org.xmind.ui.internal.spreadsheet.structures.Column;
import org.xmind.ui.internal.spreadsheet.structures.SpreadsheetStructure;
import org.xmind.ui.mindmap.AbstractIconTipContributor;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

public class AddColumnIconTipContributor
extends AbstractIconTipContributor {
    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        IViewer viewer;
        IBranchPart branch = MindMapUtils.findBranch((IPart)topicPart);
        if (branch != null && (viewer = branch.getSite().getViewer()) != null && this.isStructureAlgorithmId(branch, "org.xmind.ui.structure.spreadsheet")) {
            return new AddColumnAction(viewer, topic);
        }
        return null;
    }

    private boolean isStructureAlgorithmId(IBranchPart branch, String expectedValue) {
        String id = (String)MindMapUtils.getCache((IPart)branch, (String)"org.xmind.ui.branchCache.structureId");
        if (id == null) {
            return expectedValue != null;
        }
        return id.equals(expectedValue);
    }

    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
    }

    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
    }

    private static class AddColumnAction
    extends Action {
        private IViewer viewer;
        private ITopic chartTopic;

        public AddColumnAction(IViewer viewer, ITopic chartTopic) {
            this.viewer = viewer;
            this.chartTopic = chartTopic;
        }

        public void run() {
            EditDomain domain = this.viewer.getEditDomain();
            if (domain == null) {
                return;
            }
            ICommandStack cs = domain.getCommandStack();
            if (cs == null) {
                return;
            }
            IPart part = this.viewer.findPart((Object)this.chartTopic);
            IBranchPart branch = MindMapUtils.findBranch((IPart)part);
            if (branch == null) {
                return;
            }
            IStructure sa = branch.getBranchPolicy().getStructure((IGraphicalPart)branch);
            if (sa instanceof SpreadsheetStructure) {
                int childrenSize;
                ArraySourceProvider rowProvider;
                SpreadsheetStructure ca = (SpreadsheetStructure)sa;
                Chart chart = ca.getChart(branch);
                String newColumnTitle = this.createColumnHead(branch, chart);
                ArrayList<Object> cmds = new ArrayList<Object>();
                List children = this.chartTopic.getChildren("attached");
                IWorkbook workbook = this.chartTopic.getOwnedWorkbook();
                if (children.isEmpty()) {
                    CreateTopicCommand createRow = new CreateTopicCommand(workbook);
                    cmds.add(createRow);
                    rowProvider = createRow;
                    cmds.add(this.createSetTitleTextCommand(this.chartTopic.isRoot(), this.chartTopic.getChildren("attached").size(), (ISourceProvider)rowProvider));
                    cmds.add(new AddTopicCommand((ISourceProvider)rowProvider, this.chartTopic));
                    childrenSize = 0;
                } else {
                    ITopic rowTopic = (ITopic)children.get(0);
                    rowProvider = new ArraySourceProvider((Object)rowTopic);
                    childrenSize = rowTopic.getChildren("attached").size();
                }
                CreateTopicCommand createCell = new CreateTopicCommand(workbook);
                cmds.add(createCell);
                cmds.add(this.createSetTitleTextCommand(false, childrenSize, (ISourceProvider)createCell));
                cmds.add(new ModifyLabelCommand((ISourceProvider)createCell, (Collection)Collections.singletonList(newColumnTitle)));
                cmds.add(new AddTopicCommand((ISourceProvider)createCell, (ISourceProvider)rowProvider));
                cs.execute((Command)new CompoundCommand(Messages.Command_AddColumn, cmds));
                this.viewer.setSelection((ISelection)new StructuredSelection(createCell.getSource()));
            }
        }

        private Command createSetTitleTextCommand(boolean isRoot, int childrenSize, ISourceProvider sourceProvider) {
            int index = childrenSize + 1;
            String newTitle = isRoot ? NLS.bind((String)MindMapMessages.TitleText_MainTopic, (Object)index) : NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)index);
            return new ModifyTitleTextCommand(sourceProvider, newTitle);
        }

        private String createColumnHead(IBranchPart branch, Chart chart) {
            int numCols = chart.getNumValidColumns();
            String newColumnHead = NLS.bind((String)Messages.Column_pattern, (Object)(numCols + 1));
            while (this.containsColumnHead(branch, chart, newColumnHead)) {
                newColumnHead = NLS.bind((String)Messages.Column_pattern, (Object)(++numCols + 1));
            }
            return newColumnHead;
        }

        private boolean containsColumnHead(IBranchPart branch, Chart chart, String newColumnTitle) {
            for (Column col : chart.getColumns()) {
                if (!newColumnTitle.equals(col.getHead().toString())) continue;
                return true;
            }
            return false;
        }
    }
}

