/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.LayoutManager;
import org.xmind.gef.draw2d.AdvancedToolbarLayout;

public class ContentPane
extends Figure {
    private AdvancedToolbarLayout layout = null;
    private FlowLayout wrapLayout = null;
    private int minorAlign = -1;
    private int minorSpacing = -1;

    public ContentPane() {
        this(false, false, false);
    }

    public ContentPane(boolean isHorizontal, boolean stretchMinorAxis, boolean wrap) {
        if (wrap) {
            this.wrapLayout = new FlowLayout(isHorizontal);
            this.wrapLayout.setStretchMinorAxis(stretchMinorAxis);
            this.wrapLayout.setMajorAlignment(0);
            this.wrapLayout.setMinorAlignment(0);
            this.wrapLayout.setMajorSpacing(10);
            this.wrapLayout.setMinorSpacing(5);
            super.setLayoutManager((LayoutManager)this.wrapLayout);
        } else {
            this.layout = new AdvancedToolbarLayout(isHorizontal);
            this.layout.setStretchMinorAxis(stretchMinorAxis);
            this.layout.setMinorAlignment(0);
            this.layout.setMajorAlignment(0);
            this.layout.setInnerMinorAlignment(0);
            this.layout.setSpacing(10);
            super.setLayoutManager((LayoutManager)this.layout);
        }
    }

    public void setLayoutManager(LayoutManager manager) {
    }

    public boolean isHorizontal() {
        if (this.isWrap()) {
            return this.wrapLayout.isHorizontal();
        }
        return this.layout.isHorizontal();
    }

    public void setHorizontal(boolean horizontal) {
        if (horizontal == this.isHorizontal()) {
            return;
        }
        if (this.wrapLayout != null) {
            this.wrapLayout.setHorizontal(horizontal);
        }
        if (this.layout != null) {
            this.layout.setVertical(!horizontal);
        }
        this.revalidate();
    }

    public boolean isWrap() {
        return this.getLayoutManager() == this.wrapLayout;
    }

    public void setWrap(boolean wrap) {
        if (wrap == this.isWrap()) {
            return;
        }
        if (wrap) {
            if (this.wrapLayout == null) {
                boolean horizontal = this.isHorizontal();
                int majorAlignment = this.getMajorAlignment();
                int minorAlignment = this.getMinorAlignment();
                int majorSpacing = this.getMajorSpacing();
                int minorSpacing = this.getMinorSpacing();
                this.wrapLayout = new FlowLayout(horizontal);
                this.wrapLayout.setMajorAlignment(majorAlignment);
                this.wrapLayout.setMajorSpacing(majorSpacing);
                this.wrapLayout.setMinorSpacing(minorSpacing);
                boolean fill = minorAlignment == 3;
                this.wrapLayout.setStretchMinorAxis(fill);
                this.wrapLayout.setMinorAlignment(fill ? 0 : minorAlignment);
            }
            super.setLayoutManager((LayoutManager)this.wrapLayout);
        } else {
            if (this.layout == null) {
                boolean horizontal = this.isHorizontal();
                int majorAlignment = this.getMajorAlignment();
                int minorAlignment = this.getMinorAlignment();
                this.layout = new AdvancedToolbarLayout(horizontal);
                this.layout.setMajorAlignment(majorAlignment);
                this.layout.setSpacing(this.minorSpacing);
                boolean fill = minorAlignment == 3;
                this.layout.setStretchMinorAxis(fill);
                this.layout.setMinorAlignment(fill ? 0 : minorAlignment);
            }
            super.setLayoutManager((LayoutManager)this.layout);
        }
    }

    public int getMajorAlignment() {
        if (this.isWrap()) {
            return this.wrapLayout.getMajorAlignment();
        }
        return this.layout.getMajorAlignment();
    }

    public int getMinorAlignment() {
        return this.minorAlign;
    }

    public void setMajorAlignment(int alignment) {
        if (alignment == this.getMajorAlignment()) {
            return;
        }
        if (this.wrapLayout != null) {
            this.wrapLayout.setMajorAlignment(alignment);
        }
        if (this.layout != null) {
            this.layout.setMajorAlignment(alignment);
        }
        this.revalidate();
    }

    public void setMinorAlignment(int alignment) {
        boolean fill;
        if (this.minorAlign >= 0 && alignment == this.getMinorAlignment()) {
            return;
        }
        this.minorAlign = alignment;
        boolean bl = fill = alignment == 3;
        if (this.wrapLayout != null) {
            this.wrapLayout.setStretchMinorAxis(fill);
            this.wrapLayout.setMinorAlignment(fill ? 0 : alignment);
        }
        if (this.layout != null) {
            this.layout.setStretchMinorAxis(fill);
            this.layout.setInnerMinorAlignment(fill ? 0 : alignment);
        }
        this.revalidate();
    }

    public int getMajorSpacing() {
        if (this.isWrap()) {
            return this.wrapLayout.getMajorSpacing();
        }
        return this.layout.getSpacing();
    }

    public void setMajorSpacing(int spacing) {
        if (spacing == this.getMajorSpacing()) {
            return;
        }
        if (this.wrapLayout != null) {
            this.wrapLayout.setMajorSpacing(spacing);
        }
        if (this.layout != null) {
            this.layout.setSpacing(spacing);
        }
        this.revalidate();
    }

    public int getMinorSpacing() {
        return this.minorSpacing;
    }

    public void setMinorSpacing(int spacing) {
        if (this.minorSpacing >= 0 && spacing == this.getMinorSpacing()) {
            return;
        }
        this.minorSpacing = spacing;
        if (this.wrapLayout != null) {
            this.wrapLayout.setMinorSpacing(spacing);
        }
        this.revalidate();
    }
}

