/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.viewers.CategorizedViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategorizedGalleryViewer
extends CategorizedViewer {
    private Map<Object, GalleryViewer> viewers = new HashMap<Object, GalleryViewer>();
    private Properties properties = new Properties();
    private ISelectionChangedListener viewerSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (CategorizedGalleryViewer.this.settingViewerSelections) {
                return;
            }
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (CategorizedGalleryViewer.this.getControl().isDisposed()) {
                        return;
                    }
                    CategorizedGalleryViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)CategorizedGalleryViewer.this, CategorizedGalleryViewer.this.getSelection()));
                }
            });
        }
    };
    private IOpenListener viewerOpenListener = new IOpenListener(){

        public void open(OpenEvent event) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (CategorizedGalleryViewer.this.getControl().isDisposed()) {
                        return;
                    }
                    CategorizedGalleryViewer.this.fireOpen(new OpenEvent((Viewer)CategorizedGalleryViewer.this, CategorizedGalleryViewer.this.getSelection()));
                }
            });
        }
    };
    private boolean settingViewerSelections = false;
    private Listener viewerControlListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 15 || event.type == 16) {
                CategorizedGalleryViewer.this.updateFocus(event.display);
            }
        }
    };

    public Properties getProperties() {
        return this.properties;
    }

    protected void refreshControls() {
        this.viewers.clear();
        super.refreshControls();
    }

    protected Control createSectionContent(Composite parent, Object category, List<Object> elements) {
        GalleryViewer viewer = this.createNestedViewer();
        this.configureNestedViewer(viewer);
        viewer.createControl(parent);
        this.hookViewerControl(viewer);
        viewer.setInput(elements);
        viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.viewers.put(category, viewer);
        return viewer.getControl();
    }

    protected GalleryViewer createNestedViewer() {
        return new GalleryViewer();
    }

    protected void configureNestedViewer(GalleryViewer viewer) {
        viewer.setProperties(this.properties);
        viewer.setLabelProvider(this.getLabelProvider());
        viewer.setFilters(this.getFilters());
        viewer.setSorter(this.getSorter());
        viewer.addSelectionChangedListener(this.viewerSelectionChangedListener);
        viewer.addOpenListener(this.viewerOpenListener);
    }

    protected void hookViewerControl(GalleryViewer viewer) {
        viewer.getCanvas().setScrollBarVisibility(FigureCanvas.NEVER);
    }

    protected void reveal(Object category, Object element) {
        super.reveal(category, element);
        GalleryViewer viewer = this.viewers.get(category);
        if (viewer != null) {
            viewer.reveal(new Object[]{element});
            IPart part = viewer.findPart(element);
            if (part != null && part instanceof IGraphicalPart) {
                IFigure fig = ((IGraphicalPart)part).getFigure();
                Point loc = viewer.computeToDisplay(fig.getBounds().getLocation(), true);
                this.reveal(loc.x, loc.y);
            }
        }
    }

    protected void fillSelection(Object category, List selection) {
        ISelection sel;
        GalleryViewer viewer = this.viewers.get(category);
        if (viewer != null && (sel = viewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)sel;
            selection.addAll(ss.toList());
        }
    }

    protected void setSelectionToCategory(Object category, ISelection selection, boolean reveal) {
        GalleryViewer viewer = this.viewers.get(category);
        if (viewer != null) {
            this.setSelectionToNestedViewer(viewer, selection, reveal);
        }
    }

    private void setSelectionToNestedViewer(GalleryViewer viewer, ISelection selection, boolean reveal) {
        this.settingViewerSelections = true;
        viewer.setSelection(selection, reveal);
        this.settingViewerSelections = false;
    }

    protected void hookSectionContent(Control content) {
        super.hookSectionContent(content);
        content.addListener(15, this.viewerControlListener);
        content.addListener(16, this.viewerControlListener);
    }

    private void updateFocus(final Display display) {
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                if (display.isDisposed() || CategorizedGalleryViewer.this.getControl().isDisposed()) {
                    return;
                }
                Control focusControl = display.getFocusControl();
                for (GalleryViewer viewer : CategorizedGalleryViewer.this.viewers.values()) {
                    if (viewer.getControl() == focusControl) continue;
                    CategorizedGalleryViewer.this.setSelectionToNestedViewer(viewer, (ISelection)StructuredSelection.EMPTY, false);
                }
            }
        });
    }

    protected void handleDispose(DisposeEvent event) {
        this.viewers.clear();
        super.handleDispose(event);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.setLabelProvider(labelProvider);
        }
    }

    public void setSorter(ViewerSorter sorter) {
        super.setSorter(sorter);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.setSorter(sorter);
        }
    }

    public void addFilter(ViewerFilter filter) {
        super.addFilter(filter);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.addFilter(filter);
        }
    }

    public void removeFilter(ViewerFilter filter) {
        super.removeFilter(filter);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.removeFilter(filter);
        }
    }

    public void setFilters(ViewerFilter[] filters) {
        super.setFilters(filters);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.setFilters(filters);
        }
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        super.doUpdateItem(item, element, fullMap);
        for (GalleryViewer viewer : this.viewers.values()) {
            viewer.update(new Object[]{element});
        }
    }
}

