/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.IPageSite;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.properties.IPropertyPagePart;
import org.xmind.gef.ui.properties.IPropertyPartContainer;
import org.xmind.gef.ui.properties.IPropertySectionPart;
import org.xmind.ui.forms.WidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyPagePart
implements IPropertyPagePart {
    private static final int DEFAULT_SECTION_WIDTH = 200;
    private IPropertyPartContainer container;
    private IGraphicalEditor editor;
    private WidgetFactory widgetFactory;
    private List<SectionRec> sections = new ArrayList<SectionRec>();
    private ScrolledForm form;

    @Override
    public void init(IPropertyPartContainer container, IGraphicalEditor editor) {
        this.container = container;
        this.editor = editor;
        for (SectionRec rec : this.sections) {
            rec.section.init(this, editor);
        }
    }

    @Override
    public IPageSite getContainerSite() {
        return this.container.getContainerSite();
    }

    @Override
    public void updateSectionTitle(IPropertySectionPart section) {
        SectionRec rec = this.findRecord(section);
        if (rec != null) {
            this.updateSectionTitle(rec);
        }
    }

    private SectionRec findRecord(IPropertySectionPart section) {
        for (SectionRec rec : this.sections) {
            if (rec.section != section) continue;
            return rec;
        }
        return null;
    }

    public IGraphicalEditor getContributedEditor() {
        return this.editor;
    }

    protected void addSection(IPropertySectionPart section) {
        Assert.isNotNull((Object)section);
        SectionRec rec = new SectionRec(section);
        this.sections.add(rec);
        section.init(this.container, this.editor);
        if (this.form != null && !this.form.isDisposed()) {
            this.createSectionControl(this.form.getBody(), rec);
        }
    }

    @Override
    public List<IPropertySectionPart> getSections() {
        ArrayList<IPropertySectionPart> list = new ArrayList<IPropertySectionPart>(this.sections.size());
        for (SectionRec rec : this.sections) {
            list.add(rec.section);
        }
        return list;
    }

    @Override
    public void createControl(Composite parent) {
        this.widgetFactory = new WidgetFactory(parent.getDisplay());
        this.form = this.widgetFactory.createScrolledForm(parent);
        this.form.setMinWidth(200);
        this.form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PropertyPagePart.this.widgetFactory != null) {
                    PropertyPagePart.this.widgetFactory.dispose();
                    PropertyPagePart.this.widgetFactory = null;
                }
            }
        });
        this.createSectionControls(this.form, this.form.getBody());
        this.form.reflow(true);
    }

    protected void createSectionControls(final ScrolledForm form, final Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        for (SectionRec rec : this.sections) {
            this.createSectionControl(parent, rec);
        }
        form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                boolean change;
                Rectangle area = form.getClientArea();
                GridLayout layout = (GridLayout)parent.getLayout();
                int newNumColumns = area.width / 200;
                boolean bl = change = newNumColumns != layout.numColumns && newNumColumns >= 0 && newNumColumns <= parent.getChildren().length;
                if (change) {
                    layout.numColumns = newNumColumns;
                    parent.layout();
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    private void createSectionControl(Composite parent, SectionRec rec) {
        rec.control = this.widgetFactory.createSection(parent, 2370);
        Composite client = this.widgetFactory.createComposite((Composite)rec.control, 524352);
        rec.control.setClient((Control)client);
        GridData data = new GridData(768);
        data.verticalAlignment = 1;
        data.widthHint = 200;
        rec.control.setLayoutData((Object)data);
        rec.section.createControl(client);
        this.updateSectionTitle(rec);
    }

    private void updateSectionTitle(SectionRec rec) {
        if (rec.control == null || rec.control.isDisposed()) {
            return;
        }
        String title = rec.section.getTitle();
        if (title == null) {
            title = "";
        }
        rec.control.setText(title);
    }

    @Override
    public Control getControl() {
        return this.form;
    }

    @Override
    public abstract String getTitle();

    @Override
    public void dispose() {
        for (SectionRec rec : this.sections) {
            rec.section.dispose();
        }
        if (this.form != null) {
            this.form.dispose();
            this.form = null;
        }
    }

    @Override
    public void setSelection(ISelection selection) {
        for (SectionRec rec : this.sections) {
            rec.section.setSelection(selection);
        }
    }

    public IPropertyPartContainer getContainer() {
        return this.container;
    }

    @Override
    public void refresh() {
        for (SectionRec rec : this.sections) {
            rec.section.refresh();
        }
        if (this.form != null && !this.form.isDisposed()) {
            this.form.reflow(true);
        }
    }

    @Override
    public void setFocus() {
        if (this.sections.isEmpty()) {
            this.form.setFocus();
        } else {
            this.sections.get((int)0).section.setFocus();
        }
    }

    private static class SectionRec {
        IPropertySectionPart section;
        Section control;

        public SectionRec(IPropertySectionPart section) {
            this.section = section;
        }
    }
}

