/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.xmind.gef.ui.editor.IPanel;
import org.xmind.gef.ui.editor.IPanelContribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Panel
implements IPanel {
    private static final List<IPanelContribution> NO_CONTRIBUTIONS = Collections.emptyList();
    private Composite container;
    private Control content;
    private Map<Integer, List<IPanelContribution>> contributions = null;

    @Override
    public void addContribution(int orientation, IPanelContribution contribution) {
        List<IPanelContribution> list;
        if (contribution == null || orientation < 1 || orientation > 4) {
            return;
        }
        this.removeContribution(contribution);
        if (this.contributions == null) {
            this.contributions = new HashMap<Integer, List<IPanelContribution>>();
        }
        if ((list = this.contributions.get(orientation)) == null) {
            list = new ArrayList<IPanelContribution>();
            this.contributions.put(orientation, list);
        }
        list.add(contribution);
        this.contributionAdded(contribution);
    }

    @Override
    public List<IPanelContribution> getContributions(int orientation) {
        List<IPanelContribution> list;
        if (this.contributions != null && (list = this.contributions.get(orientation)) != null) {
            return list;
        }
        return NO_CONTRIBUTIONS;
    }

    @Override
    public void removeContribution(IPanelContribution contribution) {
        if (contribution == null || this.contributions == null) {
            return;
        }
        for (Integer orientation : this.contributions.keySet()) {
            List<IPanelContribution> list = this.contributions.get(orientation);
            if (!list.contains(contribution)) continue;
            list.remove(contribution);
            if (list.isEmpty()) {
                this.contributions.remove(orientation);
            }
            this.contributionRemoved(contribution);
            return;
        }
    }

    private void contributionAdded(IPanelContribution contribution) {
        contribution.setPanel(this);
        this.createContributionControl(contribution);
    }

    private void createContributionControl(IPanelContribution contribution) {
        if (this.containerExists()) {
            contribution.createControl(this.container);
        }
    }

    private void contributionRemoved(IPanelContribution contribution) {
        this.disposeContributionControl(contribution);
        contribution.setPanel(null);
    }

    private void disposeContributionControl(IPanelContribution contribution) {
        Control c = contribution.getControl();
        if (c != null) {
            c.dispose();
        }
    }

    protected boolean isEmpty() {
        return this.contributions == null || this.contributions.isEmpty();
    }

    @Override
    public void update() {
        if (this.containerExists()) {
            int numColumns;
            GridLayout layout = this.getContainerLayout();
            layout.numColumns = numColumns = this.calcNumColumns();
            Control last = null;
            this.adaptContributions(1, numColumns, last);
            this.adaptContributions(3, numColumns, last);
            if (this.content != null) {
                Panel.moveToLast(this.content);
                GridData data = this.getControlLayoutData(this.content);
                Panel.defaultLayoutData(data);
                data.exclude = false;
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = true;
                data.horizontalAlignment = 4;
                data.verticalAlignment = 4;
                data.horizontalSpan = 1;
                data.verticalSpan = 1;
            }
            this.adaptContributions(4, numColumns, last);
            this.adaptContributions(2, numColumns, last);
            this.container.layout();
        }
    }

    private Control adaptContributions(int orientation, int numColumns, Control last) {
        if (this.contributions == null) {
            return last;
        }
        List<IPanelContribution> list = this.contributions.get(orientation);
        if (list != null) {
            for (IPanelContribution contribution : list) {
                Control c = contribution.getControl();
                if (c == null || c.isDisposed()) continue;
                Panel.moveToLast(c);
                boolean visible = contribution.isVisible();
                c.setVisible(visible);
                GridData data = this.getControlLayoutData(c);
                this.contributionLayoutData(data, orientation == 3 || orientation == 4, orientation == 1 || orientation == 3, visible, numColumns);
            }
        }
        return last;
    }

    private void contributionLayoutData(GridData data, boolean horizontal, boolean beginning, boolean visible, int numColumns) {
        Panel.defaultLayoutData(data);
        data.exclude = !visible;
        data.grabExcessHorizontalSpace = !horizontal;
        data.grabExcessVerticalSpace = horizontal;
        data.horizontalAlignment = horizontal ? (beginning ? 16384 : 131072) : 4;
        int n = data.horizontalSpan = horizontal ? 1 : numColumns;
        data.verticalAlignment = horizontal ? 4 : (beginning ? 128 : 1024);
        data.verticalSpan = horizontal ? numColumns : 1;
    }

    private static void defaultLayoutData(GridData data) {
        data.heightHint = -1;
        data.horizontalIndent = 0;
        data.minimumHeight = 0;
        data.minimumWidth = 0;
        data.verticalIndent = 0;
        data.widthHint = -1;
    }

    private GridData getControlLayoutData(Control c) {
        Object data = c.getLayoutData();
        if (data == null || !(data instanceof GridData)) {
            data = new GridData();
            c.setLayoutData(data);
        }
        return (GridData)data;
    }

    private static void moveToLast(Control current) {
        current.moveBelow(null);
    }

    private int calcNumColumns() {
        int num = 0;
        if (this.contributions != null) {
            List<IPanelContribution> right;
            List<IPanelContribution> left = this.contributions.get(3);
            if (left != null) {
                for (IPanelContribution contribution : left) {
                    Control c = contribution.getControl();
                    if (c == null || c.isDisposed()) continue;
                    ++num;
                }
            }
            if ((right = this.contributions.get(4)) != null) {
                for (IPanelContribution contribution : right) {
                    Control c = contribution.getControl();
                    if (c == null || c.isDisposed()) continue;
                    ++num;
                }
            }
        }
        if (this.content != null) {
            ++num;
        }
        return num;
    }

    private GridLayout getContainerLayout() {
        Layout layout = this.container.getLayout();
        if (layout == null || !(layout instanceof GridLayout)) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.makeColumnsEqualWidth = false;
            this.container.setLayout((Layout)gridLayout);
            layout = gridLayout;
        }
        return (GridLayout)layout;
    }

    protected void createControls(Composite parent) {
        if (this.container == null || !this.containerExists()) {
            this.container = new Composite(parent, 524288);
            if (this.contributions != null) {
                for (List<IPanelContribution> list : this.contributions.values()) {
                    for (IPanelContribution contribution : list) {
                        this.createContributionControl(contribution);
                    }
                }
            }
        }
    }

    protected Composite getContainer() {
        return this.container;
    }

    protected void setContent(Control content) {
        this.content = content;
    }

    protected boolean containerExists() {
        return this.container != null && !this.container.isDisposed();
    }
}

