/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.xmind.gef.Disposable;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.actions.ActionRegistry;
import org.xmind.gef.ui.actions.IActionRegistry;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.gef.ui.editor.GraphicalEditorActionBarContributor;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.ui.editor.IPanelContributor;
import org.xmind.gef.ui.editor.Panel;

public abstract class GraphicalEditorPage
extends Disposable
implements IGraphicalEditorPage,
ISelectionChangedListener {
    private IGraphicalEditor parent = null;
    private Object input = null;
    private Control control = null;
    private EditDomain domain = null;
    private IGraphicalViewer viewer = null;
    private MenuManager contentPopupMenu = null;
    private boolean active = false;
    private IActionRegistry actionRegistry = null;
    private List<ISelectionAction> selectionActions = null;
    private IPanelContributor panelContributor = null;

    protected void setPanelContributor(IPanelContributor contributor) {
        this.panelContributor = contributor;
    }

    public IPanelContributor getPanelContributor() {
        return this.panelContributor;
    }

    public int getIndex() {
        return this.parent.findPage(this);
    }

    public String getPageTitle() {
        return this.parent.getPageText(this.getIndex());
    }

    public IGraphicalEditor getParentEditor() {
        return this.parent;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.viewer;
    }

    public void init(IGraphicalEditor parent, Object input) {
        this.parent = parent;
        this.input = input;
        if (input != null) {
            this.installModelListeners(input);
        }
        this.initPageActions(this.getActionRegistry());
    }

    protected void installModelListeners(Object input) {
    }

    protected void uninstallModelListeners(Object input) {
    }

    public Object getInput() {
        return this.input;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.setFocus();
        }
    }

    public void setIndex(int index) {
        this.parent.movePageTo(this.getIndex(), index);
    }

    public void setPageTitle(String title) {
        this.parent.setPageText(this.getIndex(), title);
    }

    public EditDomain getEditDomain() {
        return this.domain;
    }

    public void setEditDomain(EditDomain domain) {
        if (this.domain != null && this.getViewer() != null) {
            this.domain.setViewer(null);
        }
        this.domain = domain;
        if (domain != null && this.getViewer() != null) {
            domain.setViewer((IViewer)this.getViewer());
        }
    }

    public void createPageControl(Composite parent) {
        Composite container;
        Panel panel = null;
        if (this.panelContributor != null) {
            panel = new Panel();
            this.panelContributor.init(panel, this);
            if (panel.isEmpty()) {
                panel = null;
            }
        }
        if (panel == null) {
            container = parent;
        } else {
            panel.createControls(parent);
            container = panel.getContainer();
        }
        this.viewer = this.createViewer();
        this.initViewer(this.viewer);
        this.createViewerControl(this.viewer, container);
        this.createContentPopupMenu(this.viewer.getControl());
        if (panel != null) {
            panel.setContent(this.viewer.getControl());
            panel.update();
        }
        this.hookViewer(this.viewer);
        this.configureViewer(this.viewer);
        this.updateSelectionActions(this.viewer.getSelection());
        if (this.panelContributor != null) {
            this.panelContributor.setViewer(this.viewer);
        }
        this.control = panel != null ? panel.getContainer() : this.viewer.getControl();
    }

    protected abstract IGraphicalViewer createViewer();

    protected abstract void createViewerControl(IGraphicalViewer var1, Composite var2);

    public Control getControl() {
        return this.control;
    }

    private void createContentPopupMenu(Control control) {
        Menu menu;
        if (this.contentPopupMenu == null) {
            this.contentPopupMenu = this.createContentPopupMenu();
            String menuId = String.valueOf(this.getParentEditor().getSite().getId()) + "-" + this.hashCode() + ".content";
            this.initContentPopupMenu(this.contentPopupMenu);
            this.registerContentPopupMenu(menuId, this.contentPopupMenu);
        }
        if ((menu = this.contentPopupMenu.getMenu()) == null || menu.isDisposed()) {
            menu = this.contentPopupMenu.createContextMenu(control);
        }
        control.setMenu(menu);
    }

    protected void registerContentPopupMenu(String menuId, MenuManager menu) {
        this.getParentEditor().getSite().registerContextMenu(menuId, menu, this.getSelectionProvider());
    }

    protected MenuManager createContentPopupMenu() {
        return new MenuManager();
    }

    protected void initContentPopupMenu(MenuManager menu) {
        if (this.isContentPopupMenuDynamic()) {
            menu.setRemoveAllWhenShown(true);
            menu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    GraphicalEditorPage.this.contributeToContentPopupMenu(manager);
                }
            });
        } else {
            this.contributeToContentPopupMenu((IMenuManager)menu);
        }
    }

    protected boolean isContentPopupMenuDynamic() {
        return true;
    }

    protected void contributeToContentPopupMenu(IMenuManager menu) {
        IEditorActionBarContributor contributor = this.getParentEditor().getEditorSite().getActionBarContributor();
        if (contributor instanceof GraphicalEditorActionBarContributor) {
            ((GraphicalEditorActionBarContributor)contributor).contributeToContentPopupMenu(menu);
        }
    }

    protected void initPageActions(IActionRegistry actionRegistry) {
    }

    protected void initViewer(IGraphicalViewer viewer) {
        if (this.domain != null) {
            this.domain.setViewer((IViewer)viewer);
        }
    }

    protected void configureViewer(IGraphicalViewer viewer) {
        viewer.setInput(this.createViewerInput());
    }

    protected Object createViewerInput() {
        return this.getInput();
    }

    protected void hookViewer(IGraphicalViewer viewer) {
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void unhookViewer(IGraphicalViewer viewer) {
        viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void setFocus() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public IGraphicalViewer getViewer() {
        return this.viewer;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == IGraphicalViewer.class) {
            return this.getViewer();
        }
        if (adapter == EditDomain.class) {
            return this.getEditDomain();
        }
        return null;
    }

    protected IActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    protected void addSelectionAction(ISelectionAction action) {
        if (this.selectionActions == null) {
            this.selectionActions = new ArrayList<ISelectionAction>();
        }
        this.selectionActions.add(action);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelectionActions(event.getSelection());
    }

    protected void updateSelectionActions(ISelection selection) {
        if (this.selectionActions != null) {
            for (ISelectionAction action : this.selectionActions) {
                action.setSelection(selection);
            }
        }
    }

    public void dispose() {
        if (this.panelContributor != null) {
            this.panelContributor.dispose();
        }
        if (this.selectionActions != null) {
            for (ISelectionAction action : this.selectionActions) {
                action.setSelection(null);
            }
            this.selectionActions = null;
        }
        if (this.actionRegistry != null) {
            this.actionRegistry.dispose();
            this.actionRegistry = null;
        }
        if (this.getInput() != null) {
            this.uninstallModelListeners(this.getInput());
        }
        if (this.contentPopupMenu != null) {
            this.contentPopupMenu.dispose();
            this.contentPopupMenu = null;
        }
        if (this.viewer != null) {
            this.unhookViewer(this.viewer);
            if (this.domain != null) {
                this.domain.setViewer(null);
            }
            this.viewer.getControl().dispose();
            this.viewer = null;
        }
        super.dispose();
    }
}

