/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.actions;

import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.actions.CommandStackAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.internal.ActionMessages;

public class UndoAction
extends CommandStackAction {
    public UndoAction(IGraphicalEditor editor) {
        super(editor);
        this.setId(ActionFactory.UNDO.getId());
    }

    public void run() {
        if (this.getCommandStack() == null || this.isDisposed()) {
            return;
        }
        this.getCommandStack().undo();
    }

    protected void update() {
        ICommandStack cs = this.getCommandStack();
        boolean canUndo = cs != null && cs.canUndo();
        this.setEnabled(canUndo);
        String label = null;
        if (canUndo && cs != null) {
            label = cs.getUndoLabel();
        }
        if (label == null) {
            this.setText(ActionMessages.UndoText);
            this.setToolTipText(ActionMessages.UndoTooltip);
        } else {
            this.setText(NLS.bind((String)ActionMessages.UndoTextFormat, (Object)label));
            this.setToolTipText(NLS.bind((String)ActionMessages.UndoTooltipFormat, (Object)label));
        }
    }
}

