/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.actions;

import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ICommandStackListener;
import org.xmind.gef.ui.actions.EditorAction;
import org.xmind.gef.ui.actions.ICommandStackAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;

public abstract class CommandStackAction
extends EditorAction
implements ICommandStackAction,
ICommandStackListener {
    private ICommandStack commandStack;

    protected CommandStackAction(IGraphicalEditor editor) {
        super(editor);
        this.setCommandStack(editor.getCommandStack());
    }

    protected ICommandStack getCommandStack() {
        return this.commandStack;
    }

    public void setCommandStack(ICommandStack commandStack) {
        if (commandStack == this.commandStack) {
            return;
        }
        if (this.commandStack != null) {
            this.unhook(this.commandStack);
        }
        this.commandStack = commandStack;
        if (commandStack != null) {
            this.hook(commandStack);
        }
        this.update();
    }

    private void unhook(ICommandStack cs) {
        cs.removeCSListener((ICommandStackListener)this);
    }

    private void hook(ICommandStack cs) {
        cs.addCSListener((ICommandStackListener)this);
    }

    public void handleCommandStackEvent(CommandStackEvent event) {
        this.update();
    }

    protected abstract void update();

    public void dispose() {
        this.setCommandStack(null);
        super.dispose();
    }
}

