/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.osgi.framework.Bundle;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.MarkerImpExpUtils;
import org.xmind.ui.internal.actions.NewFromTemplateFileAction;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.internal.editor.WorkbookEditorInput;
import org.xmind.ui.internal.imports.freemind.FreeMindImporter;
import org.xmind.ui.internal.imports.mm.MindManagerImporter;
import org.xmind.ui.wizards.MindMapImporter;

public class SimpleOpenAction
implements Runnable {
    private IWorkbenchWindow window;
    private String filename;
    private boolean presentation;
    private IEditorPart resultEditor;

    public SimpleOpenAction(IWorkbenchWindow window, String filename, boolean presentation) {
        this.window = window;
        this.filename = filename;
        this.presentation = presentation;
    }

    public SimpleOpenAction(IWorkbenchWindow window, String filename) {
        this(window, filename, false);
    }

    public SimpleOpenAction(String filename) {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), filename, false);
    }

    public SimpleOpenAction(String filename, boolean presentataion) {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), filename, presentataion);
    }

    public void run() {
        this.resultEditor = this.window != null && !this.window.getShell().isDisposed() ? SimpleOpenAction.open(this.window, this.filename) : SimpleOpenAction.open(this.filename);
        if (this.resultEditor != null && this.presentation) {
            this.startPresentation(this.resultEditor);
        }
    }

    private void startPresentation(IEditorPart sourceEditor) {
        final IEditorActionDelegate ad = this.createPresentationDelegate();
        if (ad == null) {
            return;
        }
        Action action = new Action(){};
        ad.setActiveEditor((IAction)action, sourceEditor);
        sourceEditor.getSite().getWorkbenchWindow().getWorkbench().getDisplay().asyncExec(new Runnable((IAction)action){
            private final /* synthetic */ IAction val$action;
            {
                this.val$action = iAction;
            }

            public void run() {
                ad.run(this.val$action);
            }
        });
    }

    private IEditorActionDelegate createPresentationDelegate() {
        String clazz = "org.xmind.ui.internal.presentation.ShowPresentationActionDelegate";
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui.presentation");
        if (bundle != null) {
            try {
                return (IEditorActionDelegate)bundle.loadClass(clazz).newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IEditorPart open(String filename) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return SimpleOpenAction.open(window, filename);
    }

    public IEditorPart getResultEditor() {
        return this.resultEditor;
    }

    public static IEditorPart open(IWorkbenchWindow window, String filename) {
        if (window == null) {
            return null;
        }
        File file = new File(filename);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        String path = filename;
        String extension = FileUtils.getExtension((String)path);
        if (".xmt".equalsIgnoreCase(extension)) {
            return SimpleOpenAction.newFromTemplate(window, path);
        }
        if (".xmp".equalsIgnoreCase(extension)) {
            return SimpleOpenAction.importMarkers(path);
        }
        if (".mmap".equalsIgnoreCase(extension)) {
            return SimpleOpenAction.importMindManagerFile(window, path);
        }
        if (".mm".equalsIgnoreCase(extension)) {
            return SimpleOpenAction.importFreeMindFile(window, path);
        }
        return SimpleOpenAction.openMindMap(window, path);
    }

    private static IEditorPart importMindManagerFile(final IWorkbenchWindow window, String path) {
        MindManagerImporter importer = new MindManagerImporter(path);
        SafeRunner.run((ISafeRunnable)new SafeRunnable((MindMapImporter)importer){
            private final /* synthetic */ MindMapImporter val$importer;
            {
                this.val$importer = mindMapImporter;
            }

            public void run() throws Exception {
                this.val$importer.build();
            }
        });
        IWorkbook workbook = importer.getTargetWorkbook();
        if (workbook == null) {
            return null;
        }
        final WorkbookEditorInput input = new WorkbookEditorInput(workbook);
        final IEditorPart[] e = new IEditorPart[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                e[0] = window.getActivePage().openEditor((IEditorInput)input, "org.xmind.ui.MindMapEditor");
            }
        });
        return e[0];
    }

    private static IEditorPart importFreeMindFile(final IWorkbenchWindow window, String path) {
        FreeMindImporter importer = new FreeMindImporter(path);
        SafeRunner.run((ISafeRunnable)new SafeRunnable((MindMapImporter)importer){
            private final /* synthetic */ MindMapImporter val$importer;
            {
                this.val$importer = mindMapImporter;
            }

            public void run() throws Exception {
                this.val$importer.build();
            }
        });
        IWorkbook workbook = importer.getTargetWorkbook();
        if (workbook == null) {
            return null;
        }
        final WorkbookEditorInput input = new WorkbookEditorInput(workbook);
        final IEditorPart[] ediotPart = new IEditorPart[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                ediotPart[0] = window.getActivePage().openEditor((IEditorInput)input, "org.xmind.ui.MindMapEditor");
            }
        });
        return ediotPart[0];
    }

    private static IEditorPart importMarkers(String path) {
        try {
            MarkerImpExpUtils.importMarkerPackage((String)path);
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    PreferencesUtil.createPreferenceDialogOn(null, (String)"org.xmind.ui.MarkersPrefPage", null, null).open();
                }
            });
        }
        catch (IOException iOException) {}
        return null;
    }

    private static IEditorPart newFromTemplate(IWorkbenchWindow window, String path) {
        NewFromTemplateFileAction action = new NewFromTemplateFileAction(window, path);
        action.run();
        return action.getEditorPart();
    }

    private static IEditorPart openMindMap(final IWorkbenchWindow window, final String path) {
        String errMessage = NLS.bind((String)DialogMessages.FailedToLoadWorkbook_message, (Object)path);
        final IEditorPart[] editPart = new IEditorPart[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(errMessage){

            public void run() throws Exception {
                IEditorInput input = MME.createFileEditorInput((String)path);
                editPart[0] = window.getActivePage().openEditor(input, "org.xmind.ui.MindMapEditor");
            }
        });
        return editPart[0];
    }
}

