/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xmind.cathy.internal.CathyPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceFile {
    private File file;
    private FileLock fileLock;
    private RandomAccessFile raFile;

    public WorkspaceFile(File file) {
        this.file = file;
    }

    public List<String> readLines() {
        ArrayList<String> list;
        block15: {
            list = new ArrayList<String>();
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(this.file));
                    while ((line = reader.readLine()) != null) {
                        if ("".equals(line)) continue;
                        list.add(line);
                    }
                }
                catch (IOException e) {
                    CathyPlugin.log(e, null);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    public void writeLines(List<String> lines) {
        block15: {
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.file));
                    Iterator<String> it = lines.iterator();
                    while (it.hasNext()) {
                        writer.write(it.next());
                        if (!it.hasNext()) continue;
                        writer.newLine();
                    }
                }
                catch (IOException e) {
                    CathyPlugin.log(e, null);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean lock() {
        try {
            this.raFile = new RandomAccessFile(this.file, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        try {
            this.fileLock = this.raFile.getChannel().tryLock();
        }
        catch (IOException iOException) {}
        if (this.fileLock != null) {
            return true;
        }
        try {
            this.raFile.close();
        }
        catch (IOException iOException) {}
        this.raFile = null;
        return false;
    }

    public void unlock() {
        if (this.fileLock != null) {
            try {
                this.fileLock.release();
            }
            catch (IOException iOException) {}
            this.fileLock = null;
        }
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            catch (IOException iOException) {}
            this.raFile = null;
        }
    }

    public static synchronized boolean isLocked(File f) {
        WorkspaceFile fl = new WorkspaceFile(f);
        if (!fl.lock()) {
            return true;
        }
        fl.unlock();
        return false;
    }
}

