/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;

public class GeneralPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private IntegerFieldEditor autoSaveIntervalsField;
    private Composite autoSaveIntervalsParent;
    private IntegerFieldEditor recentFilesField;

    public GeneralPrefPage() {
        super(WorkbenchMessages.GeneralPrefPage_title, 0);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CathyPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        ((GridLayout)composite.getLayout()).verticalSpacing = 15;
        return composite;
    }

    protected void createFieldEditors() {
        this.addRecentFileCountField();
        this.addAutoSaveGroup();
        this.addRememberLastSessionField();
    }

    private void addRecentFileCountField() {
        this.recentFilesField = new IntegerFieldEditor("RECENT_FILES", WorkbenchMessages.RecentFiles_label, this.getFieldEditorParent());
        this.addField((FieldEditor)this.recentFilesField);
    }

    private void addRememberLastSessionField() {
        this.addField((FieldEditor)new BooleanFieldEditor("restoreLastSession", WorkbenchMessages.RestoreLastSession_label, this.getFieldEditorParent()));
    }

    private void addAutoSaveGroup() {
        Composite parent = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.addField((FieldEditor)new BooleanFieldEditor("autoSaveEnabled", WorkbenchMessages.AutoSave_label, this.createFieldContainer(parent, false)));
        this.autoSaveIntervalsParent = this.createFieldContainer(parent, true);
        this.autoSaveIntervalsField = new IntegerFieldEditor("autoSaveIntervals", "", this.autoSaveIntervalsParent);
        this.addField((FieldEditor)this.autoSaveIntervalsField);
        this.autoSaveIntervalsField.setEnabled(this.getPreferenceStore().getBoolean("autoSaveEnabled"), this.autoSaveIntervalsParent);
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(WorkbenchMessages.AutoSave_Minutes);
    }

    private Composite createFieldContainer(Composite parent, boolean grabHorizontal) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, grabHorizontal, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        return composite;
    }

    protected void initialize() {
        super.initialize();
        IPreferenceStore uiPrefStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.recentFilesField.setPreferenceStore(uiPrefStore);
        this.recentFilesField.load();
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() instanceof FieldEditor) {
            String prefName;
            FieldEditor fe = (FieldEditor)event.getSource();
            if (event.getProperty().equals("field_editor_value") && "autoSaveEnabled".equals(prefName = fe.getPreferenceName())) {
                this.autoSaveIntervalsField.setEnabled(((Boolean)event.getNewValue()).booleanValue(), this.autoSaveIntervalsParent);
            }
        }
    }
}

