/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.xmind.cathy.internal.CathyWorkbenchActionBuilder;
import org.xmind.cathy.internal.Log;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.cathy.internal.actions.SimpleOpenAction;
import org.xmind.ui.internal.editor.WorkbookEditorInput;
import org.xmind.ui.internal.editor.WorkbookRefManager;
import org.xmind.ui.internal.workbench.Util;
import org.xmind.ui.mindmap.MindMapUI;

public class CathyWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public CathyWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new CathyWorkbenchActionBuilder(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(Util.getInitialWindowSize());
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setTitle(WorkbenchMessages.AppWindowTitle);
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        final IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        if (window != null) {
            CoolBarManager coolBar = ((WorkbenchWindow)window).getCoolBarManager();
            if (coolBar != null) {
                coolBar.setLockLayout(true);
            }
            window.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CathyWorkbenchWindowAdvisor.this.postOpen(window);
                }
            });
        }
    }

    private void postOpen(IWorkbenchWindow window) {
        this.checkLog(window);
        Object[] lastSession = this.checkLastSession();
        if (lastSession != null && lastSession.length > 0) {
            Object[] objectArray = lastSession;
            int n = lastSession.length;
            int n2 = 0;
            while (n2 < n) {
                Object input = objectArray[n2];
                new WorkbookEditorInput();
                this.openEditor((IEditorInput)input, window);
                ++n2;
            }
        } else {
            this.openEditor(null, window);
        }
        window.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                WorkbookRefManager.getInstance().clearLastSession();
            }
        });
    }

    private void openEditor(final IEditorInput input, final IWorkbenchWindow window) {
        window.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        IWorkbenchPage activePage = window.getActivePage();
                        if (input != null) {
                            activePage.openEditor(input, "org.xmind.ui.MindMapEditor");
                        } else if (window.getActivePage().getActiveEditor() == null) {
                            activePage.openEditor((IEditorInput)new WorkbookEditorInput(), "org.xmind.ui.MindMapEditor");
                        }
                    }
                });
            }
        });
    }

    private Object[] checkLastSession() {
        List session = WorkbookRefManager.getInstance().loadLastSession();
        if (session == null || session.isEmpty()) {
            return null;
        }
        ListSelectionDialog dialog = new ListSelectionDialog(null, (Object)session, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new ListLabelProvider(), WorkbenchMessages.appWindow_ListSelectionDialog_Text);
        dialog.setTitle(WorkbenchMessages.appWindow_ListSelectionDialog_Title);
        dialog.setInitialElementSelections(session);
        dialog.open();
        return dialog.getResult();
    }

    private void checkLog(IWorkbenchWindow window) {
        Log opening = Log.get(".opening");
        if (opening.exists()) {
            String[] contents;
            boolean presentation = false;
            ArrayList<String> files = new ArrayList<String>();
            String[] stringArray = contents = opening.getContents();
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if ("-p".equals(line)) {
                    presentation = true;
                } else {
                    files.add(line);
                }
                ++n2;
            }
            if (files.isEmpty()) {
                return;
            }
            for (String file : files) {
                this.open(window, file, presentation);
                if (!presentation) continue;
                presentation = false;
            }
            files.clear();
            opening.delete();
        }
    }

    private void open(IWorkbenchWindow window, String path, boolean presentation) {
        File file = new File(path);
        if (file.isFile() && file.canRead()) {
            window.getShell().getDisplay().asyncExec((Runnable)new SimpleOpenAction(window, path, presentation));
        }
    }

    private class ListLabelProvider
    extends LabelProvider {
        private ListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IEditorInput) {
                return ((IEditorInput)element).getName();
            }
            return null;
        }

        public Image getImage(Object element) {
            ImageDescriptor image;
            if (element instanceof IEditorInput && (image = MindMapUI.getImages().get("icons/xmind.16.gif")) != null) {
                return image.createImage();
            }
            return null;
        }
    }
}

